package com.zollsoft.xtomedo.ti_services.api.datatype;

import java.util.Arrays;
import lombok.Getter;

public enum TLSSetting {

  NONE_HTTP(0, false), NO_AUTH(1, true), BASIC_AUTH(2, true), CERT(3, true), UNKNOWN(-1, true);

  private final int tomedoID;
  @Getter
  private final boolean tlsEnabled;

  TLSSetting(int tomedoID, boolean tlsEnabled) {
    this.tomedoID = tomedoID;
    this.tlsEnabled = tlsEnabled;
  }

  public static TLSSetting of(int tomedoID) {
    return Arrays.stream(values())
                 .filter(p -> tomedoID == p.tomedoID)
                 .findFirst()
                 .orElse(UNKNOWN);
  }
}
