package com.zollsoft.xtomedo.ti_services.api.datatype;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum Product {

  Secunet("SECUN", "secu_kon", 5),
  KoPS("EHEX", "VCon", 1 /*TIConnectorHersteller_eHEALTH */),
  KOCOBOX("KOCOC", "kocobox", 4),
  TITUS("???", "???", 6 /*TIConnectorHersteller_eHEALTH_ePAtest*/),
  RISE("???", "???", 2),
  TELEKOM("???", "???", 3),


  UNKNOWN("", "", 0);
  private final String productVendorId;
  private final String productCode;
  private final int tomedoID;

  Product(String productVendorId, String productCode, int tomedoID) {
    this.productVendorId = productVendorId;
    this.productCode = productCode;
    this.tomedoID = tomedoID;
  }

  public static Product of(String productVendorId, String productCode) {
    return Arrays.stream(values())
                 .filter(p -> StringUtils.equalsAnyIgnoreCase(productVendorId, p.productVendorId)
                     && StringUtils.equalsAnyIgnoreCase(productCode, p.productCode))
                 .findFirst()
                 .orElse(UNKNOWN);
  }

  public static Product of(int tomedoID) {
    return Arrays.stream(values())
                 .filter(p -> tomedoID == p.tomedoID)
                 .findFirst()
                 .orElse(UNKNOWN);
  }


}
