package com.zollsoft.xtomedo.ti_services.api.connectorevent;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Getter
public enum EventType {

	OPERATION("Operation"),
	SECURITY("Security"),
	INFRASTRUCTURE("Infrastructure"),
	BUSINESS("Business"),
	OTHER("Other");

	private final String name;

	public static EventType fromName(String name) {
		for (EventType c : EventType.values()) {
			if (c.name.equals(name)) {
				return c;
			}
		}
		throw new IllegalArgumentException(name);
	}

}
