package com.zollsoft.xtomedo.ti_services.api.compatibility;

import lombok.Getter;

@Getter
public class TIServiceIncompatibilityException extends Exception {

  private final ApiVersion tiServicesVersion;
  private final ApiVersion xtomedoServerVersion;


  public TIServiceIncompatibilityException(ApiVersion tiServicesVersion, ApiVersion xtomedoServerVersion) {
    super(String.format("TI-Services API is not compatible: %s <-> %s", tiServicesVersion, xtomedoServerVersion));
    this.tiServicesVersion = tiServicesVersion;
    this.xtomedoServerVersion = xtomedoServerVersion;
  }
}
