package com.zollsoft.xtomedo.ti_services.api.compatibility;

public class CompatibilityVerification {

  public static ApiVersion getCurrentVersion() {
    return ApiVersion.CURRENT;
  }

  public static void verify(ApiVersion apiVersion) throws TIServiceIncompatibilityException {

    if (!isCompatible(apiVersion)) {
      throw new TIServiceIncompatibilityException(apiVersion, ApiVersion.CURRENT);
    }

  }

  public static boolean isCompatible(ApiVersion apiVersion) {

    if (apiVersion.major() != ApiVersion.CURRENT.major()) {
      return false;
    }
    //noinspection RedundantIfStatement
    if (apiVersion.minor() != ApiVersion.CURRENT.minor()) {
      return false;
    }

    // different patch versions are compatible

    return true;

  }

}
