package com.zollsoft.xtomedo.ti_services.api.compatibility;

public record ApiVersion(int major, int minor, int patch) {

  public final static String HEADER_NAME = "api-version";

  public static final ApiVersion CURRENT = new ApiVersion(1, 0, 3);

  @Override
  public String toString() {
    return String.format("%d.%d.%d", major, minor, patch);
  }

  public static ApiVersion from(String version) {
    String[] parts = version.split("\\.");
    int[] intParts = new int[3];
    for (int i = 0; i < parts.length; i++) {
      intParts[i] = Integer.parseInt(parts[i]);
    }
    return new ApiVersion(intParts[0], intParts[1], intParts[2]);
  }

}
