package com.zollsoft.xtomedo.ti_services.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import org.springframework.lang.Nullable;

/**
 * This record will be (JSON) serialized.
 *
 * @param kartendaten    either eGK/null
 * @param kvkDaten       or KVK/null
 * @param patientenIdent to avoid (senseless) serialization of Patient, Patient is not filled within kartendaten
 * @param cardTerminalId Id of the used card terminal
 */
@JsonInclude(Include.NON_NULL)
public record VSDDataDTO(@Nullable EGKDataDTO kartendaten, @Nullable PVKDataDTO kvkDaten, @Nullable Long patientenIdent,
                         String cardTerminalId) {

}
