package com.zollsoft.xtomedo.ti_services.api;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor
public enum CardType {

  EGK("EGK"),
  HBA_Q_SIG("HBA-qSig"),
  HBA("HBA"),
  SMC_B("SMC-B"),
  HSM_B("HSM-B"),
  SMC_KT("SMC-KT"),
  KVK("KVK"),
  ZOD_2_0("ZOD_2.0"),
  UNKNOWN("UNKNOWN"),
  HB_AX("HBAx"),
  SM_B("SM-B");

  private final String value;


  public static CardType fromValue(String value) {
    for (CardType c : CardType.values()) {
      if (c.value.equals(value)) {
        return c;
      }
    }
    throw new IllegalArgumentException(value);
  }

}
