/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.impfdoc.license.model;

import de.gzim.impfdoc.license.util.LicenseServiceException;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Order {
    @Nullable
    private final UUID installationId;
    @Nullable
    private final String installationIdCheckSum;
    @Nullable
    private final String firstName;
    @Nullable
    private final String lastName;
    @Nullable
    private final String street;
    @Nullable
    private final String postalCode;
    @Nullable
    private final String houseNumber;
    @Nullable
    private final String city;
    @Nullable
    private final String country;
    @Nullable
    private final String company;
    @Nullable
    private final String phone;
    @Nullable
    private final String fax;
    @Nullable
    private final String billingMail;
    @Nullable
    private final String contactMail;
    @Nullable
    private final String customer;
    private final int doctorCount;
    private final boolean doctorCountConfirmed;
    private final boolean paymentProofWillBeSubmittedLater;
    private final int bsnrCount;
    @Nullable
    private final String institute;
    @Nullable
    private final String mandate;
    @Nullable
    private final String lastAis;
    @Nullable
    private final String contractor;
    @Nullable
    private final String iban;
    @Nullable
    private final String bic;
    @Nullable
    private final String salutation;
    @Nullable
    private final String title;
    @Nullable
    private final Boolean sepaAgreed;
    @Nullable
    private final String licenseFee;
    @Nullable
    private final String monthlyFee;
    @Nullable
    private final String comment;
    @Nullable
    private final String attentionSource;

    public Order(@Nullable UUID installationId, @Nullable String installationIdCheckSum, @Nullable String firstName, @Nullable String lastName, @Nullable String street, @Nullable String postalCode, @Nullable String houseNumber, @Nullable String city, @Nullable String country, @Nullable String company, @Nullable String phone, @Nullable String fax, @Nullable String billingMail, @Nullable String contactMail, @Nullable String customer, int doctorCount, int bsnrCount, @Nullable String institute, @Nullable String mandate, @Nullable String lastAis, @Nullable String contractor, @Nullable String iban, @Nullable String bic, @Nullable String salutation, @Nullable String title, @Nullable Boolean sepaAgreed, @Nullable String licenseFee, @Nullable String monthlyFee, @Nullable String comment, boolean doctorCountConfirmed, boolean paymentProofWillBeSubmittedLater, @Nullable String attentionSource) {
        this.installationId = installationId;
        this.installationIdCheckSum = installationIdCheckSum;
        this.firstName = firstName;
        this.lastName = lastName;
        this.street = street;
        this.postalCode = postalCode;
        this.houseNumber = houseNumber;
        this.city = city;
        this.country = country;
        this.company = company;
        this.phone = phone;
        this.fax = fax;
        this.billingMail = billingMail;
        this.contactMail = contactMail;
        this.customer = customer;
        this.doctorCount = doctorCount;
        this.institute = institute;
        this.mandate = mandate;
        this.lastAis = lastAis;
        this.contractor = contractor;
        this.iban = iban;
        this.bic = bic;
        this.salutation = salutation;
        this.title = title;
        this.sepaAgreed = sepaAgreed;
        this.bsnrCount = bsnrCount;
        this.licenseFee = licenseFee;
        this.monthlyFee = monthlyFee;
        this.comment = comment;
        this.doctorCountConfirmed = doctorCountConfirmed;
        this.paymentProofWillBeSubmittedLater = paymentProofWillBeSubmittedLater;
        this.attentionSource = attentionSource;
    }

    @NotNull
    public static Order loadOrder(@NotNull Properties properties) throws LicenseServiceException {
        String installationId = properties.getProperty("InstallationId");
        String installationIdCheckSum = properties.getProperty(Property.INSTALLATION_ID_CHECK_SUM.toString());
        String firstName = properties.getProperty(Property.FIRST_NAME.toString());
        String lastName = properties.getProperty(Property.LAST_NAME.toString());
        String street = properties.getProperty(Property.STREET.toString());
        String postalCode = properties.getProperty(Property.POSTAL_CODE.toString());
        String houseNumber = properties.getProperty(Property.HOUSE_NUMBER.toString());
        String city = properties.getProperty(Property.CITY.toString());
        String country = properties.getProperty(Property.COUNTRY.toString());
        String company = properties.getProperty(Property.COMPANY.toString());
        String phone = properties.getProperty(Property.PHONE.toString());
        String fax = properties.getProperty(Property.FAX.toString());
        String billingMail = properties.getProperty(Property.BILLING_MAIL.toString());
        String contactMail = properties.getProperty(Property.CONTACT_MAIL.toString());
        String customer = properties.getProperty(Property.CUSTOMER.toString());
        String doctorCount = properties.getProperty(Property.DOCTOR_COUNT.toString());
        String bsnrCount = properties.getProperty(Property.BSNR_COUNT.toString());
        String institute = properties.getProperty(Property.INSTITUT.toString());
        String mandat = properties.getProperty(Property.MANDAT.toString());
        String lastAis = properties.getProperty(Property.LAST_AIS.toString());
        String contractor = properties.getProperty(Property.CONTRACTOR.toString());
        String iban = properties.getProperty(Property.IBAN.toString());
        String bic = properties.getProperty(Property.BIC.toString());
        String salutation = properties.getProperty(Property.SALUTATION.toString());
        String title = properties.getProperty(Property.TITEL.toString());
        String sepaAgreed = properties.getProperty(Property.SEPA_AGREED.toString());
        String licenseFee = properties.getProperty(Property.LICENSE_FEE.toString());
        String monthlyFee = properties.getProperty(Property.MONTHLY_FEE.toString());
        String comment = properties.getProperty(Property.COMMENT.toString());
        boolean doctorCountConfirmed = Boolean.parseBoolean(Order.requireNonNullElse(properties.getProperty(Property.DOCTOR_COUNT_CONFIRMED.toString()), "false"));
        boolean paymentProofWillBeSubmittedLater = Boolean.parseBoolean(Order.requireNonNullElse(properties.getProperty(Property.PAYMENT_PROOF_WILL_BE_SUBMITTED_LATER.toString()), "false"));
        String attentionSource = properties.getProperty(Property.ATTENTION_SOURCE.toString());
        return new Order(installationId != null ? UUID.fromString(installationId) : null, installationIdCheckSum, firstName, lastName, street, postalCode, houseNumber, city, country, company, phone, fax, billingMail, contactMail, customer, doctorCount != null ? Integer.parseInt(doctorCount) : 1, bsnrCount != null ? Integer.parseInt(bsnrCount) : 1, institute, mandat, lastAis, contractor, iban, bic, salutation, title, sepaAgreed != null ? Boolean.valueOf(Boolean.parseBoolean(sepaAgreed)) : null, licenseFee, monthlyFee, comment, doctorCountConfirmed, paymentProofWillBeSubmittedLater, attentionSource);
    }

    @NotNull
    public Optional<UUID> getInstallationId() {
        return Optional.ofNullable(this.installationId);
    }

    @NotNull
    public Optional<String> getInstallationIdCheckSum() {
        return Optional.ofNullable(this.installationIdCheckSum);
    }

    @NotNull
    public Optional<String> getFirstName() {
        return Optional.ofNullable(this.firstName);
    }

    @NotNull
    public Optional<String> getLastName() {
        return Optional.ofNullable(this.lastName);
    }

    @NotNull
    public Optional<String> getStreet() {
        return Optional.ofNullable(this.street);
    }

    @NotNull
    public Optional<String> getPostalCode() {
        return Optional.ofNullable(this.postalCode);
    }

    @NotNull
    public Optional<String> getHouseNumber() {
        return Optional.ofNullable(this.houseNumber);
    }

    @NotNull
    public Optional<String> getCity() {
        return Optional.ofNullable(this.city);
    }

    @NotNull
    public Optional<String> getCountry() {
        return Optional.ofNullable(this.country);
    }

    @NotNull
    public Optional<String> getCompany() {
        return Optional.ofNullable(this.company);
    }

    @NotNull
    public Optional<String> getPhone() {
        return Optional.ofNullable(this.phone);
    }

    @NotNull
    public Optional<String> getFax() {
        return Optional.ofNullable(this.fax);
    }

    @NotNull
    public Optional<String> getBillingMail() {
        return Optional.ofNullable(this.billingMail);
    }

    @NotNull
    public Optional<String> getContactMail() {
        return Optional.ofNullable(this.contactMail);
    }

    @NotNull
    public Optional<String> getCustomer() {
        return Optional.ofNullable(this.customer);
    }

    @NotNull
    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public int getDoctorCount() {
        return this.doctorCount;
    }

    public int getBsnrCount() {
        return this.bsnrCount;
    }

    public boolean isDoctorCountConfirmed() {
        return this.doctorCountConfirmed;
    }

    public boolean isPaymentProofWillBeSubmittedLater() {
        return this.paymentProofWillBeSubmittedLater;
    }

    @NotNull
    public Optional<String> getInstitute() {
        return Optional.ofNullable(this.institute);
    }

    @NotNull
    public Optional<String> getMandate() {
        return Optional.ofNullable(this.mandate);
    }

    @NotNull
    public Optional<String> getLastAis() {
        return Optional.ofNullable(this.lastAis);
    }

    @NotNull
    public Optional<String> getContractor() {
        return Optional.ofNullable(this.contractor);
    }

    @NotNull
    public Optional<String> getIban() {
        return Optional.ofNullable(this.iban);
    }

    @NotNull
    public Optional<String> getBic() {
        return Optional.ofNullable(this.bic);
    }

    @NotNull
    public Optional<String> getSalutation() {
        return Optional.ofNullable(this.salutation);
    }

    @NotNull
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @NotNull
    public Optional<Boolean> getSepaAgreed() {
        return Optional.ofNullable(this.sepaAgreed);
    }

    public Optional<String> getLicenseFee() {
        return Optional.ofNullable(this.licenseFee);
    }

    public Optional<String> getMonthlyFee() {
        return Optional.ofNullable(this.monthlyFee);
    }

    @NotNull
    public Optional<String> getAttentionSource() {
        return Optional.ofNullable(this.attentionSource);
    }

    @NotNull
    private static <T> T requireNonNullElse(@Nullable T obj, @NotNull T def) {
        return obj == null ? def : obj;
    }

    public static enum Property {
        INSTALLATION_ID_CHECK_SUM("installationIdCheckSum"),
        FIRST_NAME("firstName"),
        LAST_NAME("lastName"),
        STREET("street"),
        HOUSE_NUMBER("houseNumber"),
        POSTAL_CODE("postalCode"),
        CITY("city"),
        COUNTRY("country"),
        COMPANY("company"),
        PHONE("phone"),
        FAX("fax"),
        BILLING_MAIL("billingMail"),
        CONTACT_MAIL("contactMail"),
        CUSTOMER("customer"),
        DOCTOR_COUNT("doctorCount"),
        BSNR_COUNT("bsnrCount"),
        INSTITUT("institut"),
        MANDAT("mandatsReference"),
        LAST_AIS("lastAis"),
        CONTRACTOR("contractor"),
        IBAN("iban"),
        BIC("bic"),
        SALUTATION("salutation"),
        TITEL("title"),
        SEPA_AGREED("sepaAgreed"),
        LICENSE_FEE("licenseFee"),
        MONTHLY_FEE("monthlyFee"),
        COMMENT("comment"),
        PAYMENT_PROOF_WILL_BE_SUBMITTED_LATER("paymentProofWillBeSubmittedLater"),
        DOCTOR_COUNT_CONFIRMED("doctorCountConfirmed"),
        ATTENTION_SOURCE("attentionSource");

        @Nullable
        private final String property;

        private Property(String value) {
            this.property = value;
        }

        @Nullable
        public String toString() {
            return this.property;
        }
    }
}

