/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.impfdoc.license.model;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class License {
    @NotNull
    public static final String GERMAN_DATE_FORMAT = "dd.MM.yyyy";
    @NotNull
    public static final DateTimeFormatter germanDateFormatter = DateTimeFormat.forPattern((String)"dd.MM.yyyy");
    @NotNull
    private final UUID licenseId;
    @NotNull
    private final String firstName;
    @NotNull
    private final String lastName;
    @NotNull
    private final LocalDate expirationDate;
    private final int userCount;
    @NotNull
    private final UUID installationId;
    private static final int MAX_LENGTH = 29;

    public License(@NotNull UUID licenseId, @NotNull String firstName, @NotNull String lastName, @NotNull LocalDate expirationDate, int userCount, @NotNull UUID installationId) {
        this.licenseId = licenseId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.expirationDate = expirationDate;
        this.userCount = userCount;
        this.installationId = installationId;
    }

    @NotNull
    public UUID getLicenseId() {
        return this.licenseId;
    }

    @NotNull
    public String getFirstName() {
        return this.firstName;
    }

    @NotNull
    public String getLastName() {
        return this.lastName;
    }

    @NotNull
    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public int getUserCount() {
        return this.userCount;
    }

    @NotNull
    public UUID getInstallationId() {
        return this.installationId;
    }

    @NotNull
    public static License fromString(@NotNull String value) {
        String[] values = value.split(";");
        if (values.length != 6) {
            throw new RuntimeException("Cannot restore license from string. Wrong number of entries! License:" + value);
        }
        UUID licenseId = UUID.fromString(values[0]);
        String firstName = new String(Base64.getDecoder().decode(values[1]));
        String lastName = new String(Base64.getDecoder().decode(values[2]));
        LocalDate expirationDate = germanDateFormatter.parseLocalDate(values[3]);
        int userCount = Integer.parseInt(values[4]);
        UUID installationId = UUID.fromString(values[5]);
        return new License(licenseId, firstName, lastName, expirationDate, userCount, installationId);
    }

    @NotNull
    public String toString() {
        String firstName = Base64.getEncoder().encodeToString(this.getFirstName().getBytes());
        String lastName = Base64.getEncoder().encodeToString(this.getLastName().getBytes());
        System.out.printf("firstName encrypted length: %d;  lastName encrypted length: %d\n", firstName.length(), lastName.length());
        int totalLength = firstName.length() + lastName.length();
        if (totalLength > 29) {
            if (lastName.length() < 28 && !lastName.isEmpty()) {
                firstName = Base64.getEncoder().encodeToString("".getBytes(StandardCharsets.UTF_8));
            } else if (firstName.length() < 28 && !firstName.isEmpty()) {
                lastName = Base64.getEncoder().encodeToString("".getBytes(StandardCharsets.UTF_8));
            } else {
                firstName = Base64.getEncoder().encodeToString("".getBytes(StandardCharsets.UTF_8));
                lastName = Base64.getEncoder().encodeToString(this.getLastName().substring(0, 10).getBytes());
            }
        }
        return String.format("%s;%s;%s;%s;%d;%s", this.getLicenseId(), firstName, lastName, germanDateFormatter.print((ReadablePartial)this.getExpirationDate()), this.getUserCount(), this.getInstallationId());
    }
}

