/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.impfdoc.license.util;

import de.gzim.impfdoc.license.model.Order;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class Order2CsvConverter {
    @NotNull
    public static String order2Csv(@NotNull Order order) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Column c : Column.values()) {
            stringBuilder.append(Order2CsvConverter.escape(c.getHeader())).append(";");
        }
        stringBuilder.append("\n");
        for (Column c : Column.values()) {
            stringBuilder.append(Order2CsvConverter.escape(c.convert(order))).append(";");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @NotNull
    private static String escape(@NotNull String s) {
        return String.format("\"%s\"", s.replace("\"", "\\\""));
    }

    static enum Column {
        DATE("datum", o -> DateTimeFormatter.ofPattern("dd.MM.yyyy").format(LocalDate.now())),
        ANREDE("anrede", o -> o.getSalutation().orElse("")),
        INSTALLATION_ID("db_reference", o -> o.getInstallationId().map(UUID::toString).orElse("")),
        FIRSTNAME("vorname", o -> o.getFirstName().orElse("")),
        LASTNAME("nachname", o -> o.getLastName().orElse("")),
        COMPANY("firma", o -> o.getCompany().orElse("")),
        STREET("adresse_strasse", o -> o.getStreet().orElse("")),
        HOUSE_NUMBER("adresse_hausnummer", o -> o.getHouseNumber().orElse("")),
        PLZ("adresse_plz", o -> o.getPostalCode().orElse("")),
        CITY("adresse_stadt", o -> o.getCity().orElse("")),
        COUNTRY("adresse_land", o -> o.getCountry().orElse("")),
        PHONE("telefon", o -> o.getPhone().orElse("")),
        FAX("fax", o -> o.getFax().orElse("")),
        BILLING_MAIL("billing_email", o -> o.getBillingMail().orElse("")),
        CONTACT_MAIL("contact_email", o -> o.getContactMail().orElse("")),
        AIS("ais", o -> o.getLastAis().orElse("")),
        DOCTOR_COUNT("anzahl_aerzte", o -> Integer.toString(o.getDoctorCount())),
        BSNR_COUNT("anzahl_bsnr", o -> Integer.toString(o.getBsnrCount())),
        CONTRACTOR("vertriebspartner", o -> o.getContractor().orElse("")),
        MANDAT("rechnung_mandat", o -> o.getMandate().orElse("")),
        IBAN("rechnung_iban", o -> o.getIban().map(iban -> iban.replace(" ", "")).orElse("")),
        BIC("rechnung_bic", o -> o.getBic().orElse("")),
        INSTITUT("rechnung_bank", o -> o.getInstitute().orElse("")),
        TYPE("type", o -> o.getCustomer().orElse("")),
        TITLE("titel", o -> o.getTitle().orElse("")),
        SEPA_AGREED("sepa_agreed", o -> o.getSepaAgreed().map(b -> b != false ? "1" : "0").orElse("")),
        LICENSE_FEE("lizenz_gebuehr", o -> o.getLicenseFee().orElse("")),
        MONTHLY_FEE("monatliche_gebuehr", o -> o.getMonthlyFee().orElse("")),
        PAYMENT_PROOF_WILL_BE_SUBMITTED_LATER("payment_proof_will_be_submitted_later", o -> Boolean.toString(o.isPaymentProofWillBeSubmittedLater())),
        DOCTOR_COUNT_CONFIRMED("doctor_count_confirmed", o -> Boolean.toString(o.isDoctorCountConfirmed()));

        @NotNull
        private final String header;
        @NotNull
        private final Function<Order, String> supplier;

        private Column(String header, Function<Order, String> supplier) {
            this.header = header;
            this.supplier = supplier;
        }

        @NotNull
        public String getHeader() {
            return this.header;
        }

        @NotNull
        public String convert(@NotNull Order order) {
            return this.supplier.apply(order);
        }
    }
}

