/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.impfdoc.license.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jetbrains.annotations.NotNull;

public class KeyGenerator {
    static final String path = ".";
    static Key PRIVATE_KEY;
    static Key PUBLIC_KEY;

    public static void main(String[] args) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, InvalidKeyException, IllegalBlockSizeException, IOException, InvalidKeySpecException {
        String mode;
        switch (mode = args[0]) {
            case "GENERATE": {
                KeyGenerator.generateKeyPair();
                break;
            }
            case "ENCODE": {
                KeyGenerator.encode(args[1]);
                break;
            }
            case "DECODE": {
                KeyGenerator.decode();
            }
        }
    }

    static void generateKeyPair() throws NoSuchAlgorithmException, IOException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(1024);
        KeyPair keyPair = kpg.genKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        try (FileOutputStream fos = new FileOutputStream("./public.key");){
            fos.write(x509EncodedKeySpec.getEncoded());
        }
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        try (FileOutputStream fos = new FileOutputStream("./private.key");){
            fos.write(pkcs8EncodedKeySpec.getEncoded());
        }
        System.out.printf("Keys saved in %s%n", new File(path).getAbsolutePath());
    }

    static void readKeys() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedPrivateKey;
        byte[] encodedPublicKey;
        File filePublicKey = new File(path, "public.key");
        System.out.println(filePublicKey.getAbsolutePath());
        try (FileInputStream fis = new FileInputStream(filePublicKey);){
            encodedPublicKey = new byte[(int)filePublicKey.length()];
            fis.read(encodedPublicKey);
        }
        File filePrivateKey = new File(path, "private.key");
        try (FileInputStream fis = new FileInputStream(filePrivateKey);){
            encodedPrivateKey = new byte[(int)filePrivateKey.length()];
            fis.read(encodedPrivateKey);
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
        PUBLIC_KEY = keyFactory.generatePublic(publicKeySpec);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
        PRIVATE_KEY = keyFactory.generatePrivate(privateKeySpec);
    }

    static void encode(@NotNull String value) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException, InvalidKeySpecException {
        Cipher cipher = Cipher.getInstance("RSA");
        KeyGenerator.readKeys();
        cipher.init(1, PRIVATE_KEY);
        try (FileOutputStream fos = new FileOutputStream(new File(path, "encoded.txt"));){
            fos.write(cipher.doFinal(value.getBytes()));
        }
    }

    static void decode() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException, InvalidKeySpecException {
        Cipher cipher = Cipher.getInstance("RSA");
        KeyGenerator.readKeys();
        cipher.init(2, PUBLIC_KEY);
        try (FileInputStream fis = new FileInputStream(new File(path, "encoded.txt"));){
            int available = fis.available();
            byte[] bytes = new byte[available];
            fis.read(bytes);
            System.out.println(new String(cipher.doFinal(bytes)));
        }
    }
}

