/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.impfdoc.license;

import de.gzim.impfdoc.license.model.License;
import de.gzim.impfdoc.license.model.Order;
import de.gzim.impfdoc.license.util.LicenseServiceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDate;

public class LicenseService {
    @NotNull
    public byte[] createLicense(@NotNull License license) throws LicenseServiceException {
        Key key;
        try {
            key = LicenseService.readPrivateKey();
        }
        catch (Throwable t) {
            throw new LicenseServiceException("Unable to read private key", t);
        }
        try {
            String text = license.toString();
            System.out.printf("license text length:%d /n", text.length());
            return LicenseService.encode(text, key);
        }
        catch (Throwable t) {
            throw new LicenseServiceException("Unable to create license key", t);
        }
    }

    @NotNull
    public License loadLicense(@NotNull File file) throws LicenseServiceException {
        try {
            Key key = LicenseService.readPublicKey();
            return License.fromString(LicenseService.decode(key, file));
        }
        catch (Throwable t) {
            throw new LicenseServiceException("Lizenz konnte nicht gelesen werden");
        }
    }

    @NotNull
    public License order2License(@NotNull Properties properties) throws LicenseServiceException {
        Order order = Order.loadOrder(properties);
        License license = new License(UUID.randomUUID(), order.getFirstName().orElseThrow(() -> new LicenseServiceException("Fehlende Information: Vorname")), order.getLastName().orElseThrow(() -> new LicenseServiceException("Fehlende Information: Nachname")), LocalDate.now().plusYears(100), order.getDoctorCount(), order.getInstallationId().orElseThrow(() -> new LicenseServiceException("Fehlende Information: Installations-Id")));
        return license;
    }

    @NotNull
    private static Key readPrivateKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedPrivateKey;
        try (InputStream is = LicenseService.class.getClassLoader().getResourceAsStream("private.key");){
            encodedPrivateKey = IOUtils.toByteArray((InputStream)is);
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
        return keyFactory.generatePrivate(privateKeySpec);
    }

    @NotNull
    private static Key readPublicKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encodedPublicKey;
        try (InputStream is = LicenseService.class.getClassLoader().getResourceAsStream("public.key");){
            encodedPublicKey = IOUtils.toByteArray((InputStream)is);
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
        return keyFactory.generatePublic(publicKeySpec);
    }

    @NotNull
    private static byte[] encode(@NotNull String value, @NotNull Key privateKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException, InvalidKeySpecException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKey);
        return cipher.doFinal(value.getBytes(Charset.forName("windows-1250")));
    }

    @NotNull
    private static String decode(@NotNull Key publicKey, @NotNull File file) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, IOException, InvalidKeySpecException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = IOUtils.toByteArray((InputStream)fis);
            String string = new String(cipher.doFinal(bytes));
            return string;
        }
    }
}

