/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class Utilities {
    @NotNull
    public static <T> Optional<T> findCause(@NotNull Throwable e, @NotNull Class<T> causeType) {
        while (!causeType.isAssignableFrom(e.getClass())) {
            if (e instanceof UndeclaredThrowableException) {
                Throwable undeclaredThrowable = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
                if (e == undeclaredThrowable) {
                    return Optional.empty();
                }
                if (undeclaredThrowable == null) {
                    return Optional.empty();
                }
                e = undeclaredThrowable;
                continue;
            }
            if (e instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e).getTargetException();
                if (e == targetException) {
                    return Optional.empty();
                }
                if (targetException == null) {
                    return Optional.empty();
                }
                e = targetException;
                continue;
            }
            if (e == e.getCause()) {
                return Optional.empty();
            }
            if (e.getCause() == null) {
                return Optional.empty();
            }
            e = e.getCause();
        }
        return Optional.of(e);
    }
}

