/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ResourceEnumerator
implements AutoCloseable {
    private final FileSystem fileSystem;
    private final List<Path> files;

    public ResourceEnumerator(@NotNull String basePath) throws IOException, URISyntaxException {
        URL url = ResourceEnumerator.class.getResource(basePath);
        if (url == null) {
            this.fileSystem = null;
            this.files = Collections.emptyList();
            return;
        }
        URI uri = url.toURI();
        if (uri.getScheme().equals("jar")) {
            this.fileSystem = this.getNestedFileSystems(uri);
            this.files = Files.walk(this.fileSystem.getPath(basePath, new String[0]), 1, new FileVisitOption[0]).collect(Collectors.toList());
        } else {
            this.fileSystem = null;
            this.files = Files.walk(Paths.get(uri), 1, new FileVisitOption[0]).collect(Collectors.toList());
        }
    }

    @NotNull
    private FileSystem getNestedFileSystems(@NotNull URI generatorAssets) throws IOException {
        FileSystem currentFs;
        String[] jarFiles = generatorAssets.toString().split("!");
        URI rootJarUri = URI.create(jarFiles[0]);
        try {
            currentFs = FileSystems.getFileSystem(rootJarUri);
        }
        catch (FileSystemNotFoundException fsnf) {
            currentFs = FileSystems.newFileSystem(rootJarUri, Collections.emptyMap());
        }
        Path currentJar = null;
        if (jarFiles.length > 2) {
            for (int i = 1; i < jarFiles.length - 1; ++i) {
                Path nestedJar = currentFs.getPath(jarFiles[i], new String[0]);
                Path extractedJar = Files.createTempFile("jar-" + i, ".jar", new FileAttribute[0]);
                Files.copy(nestedJar, extractedJar, StandardCopyOption.REPLACE_EXISTING);
                currentFs.close();
                if (currentJar != null) {
                    Files.delete(currentJar);
                }
                currentJar = extractedJar;
                currentFs = FileSystems.newFileSystem(URI.create("jar:" + extractedJar.toUri().toString()), Collections.emptyMap());
            }
        }
        return currentFs;
    }

    @NotNull
    public List<Path> getFiles() {
        return this.files;
    }

    @NotNull
    public static ResourceEnumerator findResources(@NotNull String basePath) throws IOException, URISyntaxException {
        return new ResourceEnumerator(basePath);
    }

    @Override
    public void close() throws Exception {
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
    }
}

