/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector.sysconfig;

import de.impfsoft.ticonnector.ConnectorException;
import de.impfsoft.ticonnector.sysconfig.RouteInfo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.hc.core5.net.InetAddressUtils;
import org.jetbrains.annotations.NotNull;

public class RouteManager {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<RouteInfo> queryPersistentRoutes(@NotNull String remoteIP) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new UnsupportedOperationException("only supported with windows");
        }
        String queryRouteCommand = "route print -4";
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>();
        try {
            Process exec = Runtime.getRuntime().exec("route print -4");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(exec.getInputStream()));){
                String line;
                Pattern p = Pattern.compile("^\\s*(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+(\\d+)\\s*$");
                while ((line = reader.readLine()) != null) {
                    Matcher match = p.matcher(line);
                    if (!match.matches()) continue;
                    String network = match.group(1);
                    String mask = match.group(2);
                    String address = match.group(3);
                    if (network.contentEquals("0.0.0.0")) continue;
                    SubnetUtils subnet = new SubnetUtils(network, mask);
                    SubnetUtils.SubnetInfo info = subnet.getInfo();
                    boolean networkMatch = info.isInRange(remoteIP);
                    short maskLength = Short.parseShort(info.getCidrSignature().split("/")[1]);
                    if (!networkMatch) continue;
                    short metric = Short.parseShort(match.group(4));
                    routes.add(new RouteInfo(network, address, maskLength, metric));
                }
                Collections.sort(routes);
                if (routes.isEmpty()) return Collections.emptyList();
                ArrayList<RouteInfo> arrayList = routes;
                return arrayList;
            }
        }
        catch (Exception t) {
            if (!(t instanceof ConnectorException)) throw new ConnectorException(t.toString(), ConnectorException.ExceptionType.ROUTE_SETUP_ERROR);
            throw (ConnectorException)t;
        }
    }

    public void addRoute(@NotNull String destinationAdresse, @NotNull String gateway, @NotNull String subnetMask) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new UnsupportedOperationException("only supported with windows");
        }
        List<RouteInfo> routes = this.queryPersistentRoutes(destinationAdresse);
        if (routes.size() > 0) {
            throw new ConnectorException("F\u00fcr den Host wurde bereits eine Route eingetragen!", ConnectorException.ExceptionType.ROUTE_SETUP_ERROR);
        }
        if (!(InetAddressUtils.isIPv4Address((String)destinationAdresse) && InetAddressUtils.isIPv4Address((String)gateway) && InetAddressUtils.isIPv4Address((String)subnetMask))) {
            throw new ConnectorException("Keine IPv4 Adresse!", ConnectorException.ExceptionType.ROUTE_SETUP_ERROR);
        }
        String addRouteCommand = String.format("route -p add %s MASK %s %s", destinationAdresse, subnetMask, gateway);
        try {
            Process exec = Runtime.getRuntime().exec(addRouteCommand);
            exec.waitFor(5L, TimeUnit.SECONDS);
            if (exec.exitValue() != 0) {
                throw new ConnectorException(String.format("Process finished with errorCode=%s (%s)", exec.exitValue(), IOUtils.toString((InputStream)exec.getInputStream(), (Charset)StandardCharsets.UTF_8)), ConnectorException.ExceptionType.ROUTE_SETUP_ERROR);
            }
        }
        catch (Throwable t) {
            if (t instanceof ConnectorException) {
                throw (ConnectorException)t;
            }
            throw new ConnectorException(t.toString(), ConnectorException.ExceptionType.ROUTE_SETUP_ERROR, t);
        }
    }

    public void removeRoute(@NotNull String remoteIP) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            throw new UnsupportedOperationException("only supported with windows");
        }
        List<RouteInfo> routes = this.queryPersistentRoutes(remoteIP);
        if (routes.size() > 0) {
            if (!InetAddressUtils.isIPv4Address((String)remoteIP)) {
                throw new ConnectorException("Keine IPv4 Adresse!", ConnectorException.ExceptionType.ROUTE_SETUP_ERROR);
            }
            String deleteRouteCommand = "route delete " + remoteIP;
            try {
                Process exec = Runtime.getRuntime().exec(deleteRouteCommand);
                exec.waitFor(5L, TimeUnit.SECONDS);
                if (exec.exitValue() != 0) {
                    throw new ConnectorException(String.format("Process finished with errorCode=%s (%s)", exec.exitValue(), IOUtils.toString((InputStream)exec.getInputStream(), (Charset)StandardCharsets.UTF_8)), ConnectorException.ExceptionType.ROUTE_SETUP_ERROR);
                }
            }
            catch (Throwable t) {
                if (t instanceof ConnectorException) {
                    throw (ConnectorException)t;
                }
                throw new ConnectorException(t.toString(), ConnectorException.ExceptionType.ROUTE_SETUP_ERROR, t);
            }
        }
    }
}

