/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector.model;

import de.impfsoft.ticonnector.model.TiVersionFormatException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TiVersion
implements Comparable<TiVersion> {
    private final String value;

    private TiVersion(@NotNull String value) {
        this.value = value;
    }

    public boolean isLessThan(@NotNull TiVersion version) {
        return this.compareTo(version) < 0;
    }

    @NotNull
    public static TiVersion fromString(@NotNull String value) {
        if (!TiVersion.isValid(value)) {
            throw new TiVersionFormatException(String.format("Invalid version string %s", value));
        }
        return new TiVersion(value);
    }

    @NotNull
    public static TiVersion fromNumbers(int maj, int min, int maint) {
        return TiVersion.fromString(String.format("%d.%d.%d", maj, min, maint));
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    public static boolean isValid(@NotNull String version) {
        try {
            TiVersion.numbers(version);
        }
        catch (TiVersionFormatException e) {
            return false;
        }
        return true;
    }

    @NotNull
    private static int[] numbers(@NotNull String version) throws TiVersionFormatException {
        String[] parts = version.split("\\.");
        int[] list = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                list[i] = Integer.parseInt(parts[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new TiVersionFormatException(String.format("Non-Number (%s) in version (%s)", parts[i], version));
            }
        }
        return list;
    }

    @Override
    public int compareTo(@NotNull TiVersion tiVersion) {
        int[] nums1 = TiVersion.numbers(this.value);
        int[] nums2 = TiVersion.numbers(tiVersion.value);
        for (int i = 0; i < Math.min(nums1.length, nums2.length); ++i) {
            if (nums1[i] < nums2[i]) {
                return -1;
            }
            if (nums1[i] <= nums2[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TiVersion that = (TiVersion)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

