/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector;

import de.gematik.ws.conn.serviceinformation.v2.EndpointType;
import de.gematik.ws.conn.serviceinformation.v2.ServiceType;
import de.gematik.ws.conn.serviceinformation.v2.VersionType;
import de.impfsoft.ticonnector.ConnectorException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TiEndpoints {
    @NotNull
    private final Map<TiService, VersionType> services = new HashMap<TiService, VersionType>();

    public TiEndpoints(@NotNull List<ServiceType> services) {
        for (TiService tiService : TiService.values()) {
            ServiceType service = services.stream().filter(s -> s.getName().equals(tiService.getName())).findAny().orElse(null);
            if (service == null) {
                throw new ConnectorException("Service nicht gefunden " + tiService.getName(), ConnectorException.ExceptionType.DISCOVERY_ERROR);
            }
            VersionType version = service.getVersions().getVersion().stream().min((o1, o2) -> {
                boolean bestMatch1 = o1.getVersion().equals(tiService.getPreferredVersion());
                boolean bestMatch2 = o2.getVersion().equals(tiService.getPreferredVersion());
                return -Boolean.compare(bestMatch1, bestMatch2);
            }).orElse(null);
            if (version == null) {
                throw new ConnectorException("Keine geeignete Version zum Service gefunden " + tiService.getName(), ConnectorException.ExceptionType.DISCOVERY_ERROR);
            }
            this.services.put(tiService, version);
        }
    }

    @NotNull
    public VersionType getService(@NotNull TiService tiService) {
        return this.services.get((Object)tiService);
    }

    @NotNull
    public URI getServiceURL(@NotNull TiService tiService, boolean useTLS) throws URISyntaxException {
        VersionType versionType = this.getService(tiService);
        if (useTLS) {
            EndpointType endpointType = versionType.getEndpointTLS();
            if (endpointType == null) {
                throw new ConnectorException("F\u00fcr den Service " + (Object)((Object)tiService) + " wurde kein TLS Endpunkt gefunden", ConnectorException.ExceptionType.CONFIGURATION_ERROR);
            }
            return new URI(endpointType.getLocation());
        }
        EndpointType endpointType = versionType.getEndpoint();
        if (endpointType == null) {
            throw new ConnectorException("F\u00fcr den Service " + (Object)((Object)tiService) + " wurde kein Http Endpunkt gefunden. Nutzen Sie bitte Https!", ConnectorException.ExceptionType.CONFIGURATION_ERROR);
        }
        return new URI(endpointType.getLocation());
    }

    public static enum TiService {
        EventService("EventService", "7.2.0"),
        SignatureService("SignatureService", "7.4.0"),
        CertificateService("CertificateService", "6.0.0"),
        AuthSignatureService("AuthSignatureService", "7.4.1"),
        CardService("CardService", "8.1.0");

        @NotNull
        private final String name;
        @NotNull
        private final String preferredVersion;

        private TiService(String name, String preferredVersion) {
            this.name = name;
            this.preferredVersion = preferredVersion;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getPreferredVersion() {
            return this.preferredVersion;
        }
    }
}

