/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector;

import com.google.common.hash.Hashing;
import de.impfsoft.ticonnector.TIConnectorConfiguration;
import de.impfsoft.ticonnector.utils.ResourceEnumerator;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiConnectorHttpClientProvider {
    @NotNull
    private final Logger log;
    @Nullable
    private CloseableHttpClient client;
    @NotNull
    private String lastKeystoreHash;
    @NotNull
    private String lastConfigurationHash;
    private final KeyStore keyStore;

    public TiConnectorHttpClientProvider(boolean isDevMode) throws KeyStoreException {
        block55: {
            this.log = LoggerFactory.getLogger(this.getClass());
            this.client = null;
            this.lastKeystoreHash = "";
            this.lastConfigurationHash = "";
            this.keyStore = KeyStore.getInstance("PKCS12");
            try {
                X509Certificate certificate2;
                Throwable throwable;
                InputStream fileInputStream;
                this.keyStore.load(null, "1234".toCharArray());
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                try (ResourceEnumerator resourceEnumerator = ResourceEnumerator.findResources("/ticerts/");){
                    for (Path resource : resourceEnumerator.getFiles()) {
                        if (Files.isDirectory(resource, new LinkOption[0])) continue;
                        LoggerFactory.getLogger(this.getClass()).info("Loading ti-certs " + resource.getFileName());
                        try {
                            fileInputStream = Files.newInputStream(resource, new OpenOption[0]);
                            throwable = null;
                            try {
                                certificate2 = (X509Certificate)factory.generateCertificate(fileInputStream);
                                if (certificate2 == null) {
                                    this.log.error("Unable to load certificate. Factory is " + factory.getClass());
                                    continue;
                                }
                                this.keyStore.setCertificateEntry(resource.getFileName().toString(), certificate2);
                            }
                            catch (Throwable certificate2) {
                                throwable = certificate2;
                                throw certificate2;
                            }
                            finally {
                                if (fileInputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable certificate2) {
                                        throwable.addSuppressed(certificate2);
                                    }
                                    continue;
                                }
                                fileInputStream.close();
                            }
                        }
                        catch (Throwable t) {
                            LoggerFactory.getLogger(this.getClass()).error(t.toString());
                        }
                    }
                }
                if (!isDevMode) break block55;
                resourceEnumerator = ResourceEnumerator.findResources("/dev_ticerts/");
                var4_5 = null;
                try {
                    for (Path resource : resourceEnumerator.getFiles()) {
                        if (Files.isDirectory(resource, new LinkOption[0])) continue;
                        LoggerFactory.getLogger(this.getClass()).info("Loading ti-certs " + resource.getFileName());
                        try {
                            fileInputStream = Files.newInputStream(resource, new OpenOption[0]);
                            throwable = null;
                            try {
                                certificate2 = (X509Certificate)factory.generateCertificate(fileInputStream);
                                if (certificate2 == null) {
                                    this.log.error("Unable to load certificate");
                                    continue;
                                }
                                this.keyStore.setCertificateEntry(resource.getFileName().toString(), certificate2);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (fileInputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                fileInputStream.close();
                            }
                        }
                        catch (Throwable t) {
                            LoggerFactory.getLogger(this.getClass()).error(t.toString());
                        }
                    }
                }
                catch (Throwable throwable4) {
                    var4_5 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (resourceEnumerator != null) {
                        if (var4_5 != null) {
                            try {
                                resourceEnumerator.close();
                            }
                            catch (Throwable throwable5) {
                                var4_5.addSuppressed(throwable5);
                            }
                        } else {
                            resourceEnumerator.close();
                        }
                    }
                }
            }
            catch (Throwable t) {
                LoggerFactory.getLogger(this.getClass()).error(t.toString(), t);
            }
        }
    }

    @NotNull
    public synchronized CloseableHttpClient getHttpClient(@NotNull TIConnectorConfiguration connectorConfiguration) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        boolean createNewClient;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)5L)).setConnectionRequestTimeout(Timeout.ofSeconds((long)60L)).setResponseTimeout(Timeout.ofSeconds((long)60L)).build();
        KeyStore trustedCertificates = connectorConfiguration.getTrustedCertificates();
        TIConnectorConfiguration.ClientCertificate clientCertificate = connectorConfiguration.getClientCertificate().orElse(null);
        KeyStore clientCertificates = clientCertificate != null ? clientCertificate.getClientCertificate() : null;
        char[] clientCertificatesPassword = clientCertificate != null ? clientCertificate.getPrivateKeyPassword() : null;
        ArrayList<KeyStore> keyStores = new ArrayList<KeyStore>();
        keyStores.add(trustedCertificates);
        if (clientCertificates != null) {
            keyStores.add(clientCertificates);
        }
        String newKeystoreHash = this.hashKeystore(keyStores);
        String newConfigurationHash = this.hashConfiguration(connectorConfiguration);
        boolean bl = createNewClient = this.client == null || !newKeystoreHash.equals(this.lastKeystoreHash) || !newConfigurationHash.equals(this.lastConfigurationHash);
        if (createNewClient) {
            List<Object> defaultHeaders;
            this.log.info("Create new HttpClient");
            SSLContextBuilder builder = SSLContexts.custom();
            if (trustedCertificates != null && trustedCertificates.size() > 0) {
                ArrayList<String> newCustomEntries = Collections.list(trustedCertificates.aliases());
                for (String alias : newCustomEntries) {
                    if (!trustedCertificates.isCertificateEntry(alias)) continue;
                    Certificate certificate = trustedCertificates.getCertificate(alias);
                    String targetAlias = "custom_" + alias;
                    this.log.info("copy certificate with alias " + alias + " from trusted keystore");
                    if (this.keyStore.containsAlias(targetAlias)) {
                        this.log.info("replace existing entry for alias " + targetAlias);
                        this.keyStore.deleteEntry(targetAlias);
                    }
                    this.keyStore.setCertificateEntry(targetAlias, certificate);
                }
            }
            if (this.keyStore.size() > 0) {
                this.log.info("creating Keystore with the following certificates:");
                Enumeration<String> aliases = this.keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate certificate = this.keyStore.getCertificate(alias);
                    if (certificate == null) {
                        this.log.warn("certificate for alias " + alias + " is null!");
                        continue;
                    }
                    if (certificate instanceof X509Certificate) {
                        this.log.info(((X509Certificate)certificate).getSubjectDN().getName());
                        continue;
                    }
                    this.log.warn("certificate for alias " + alias + " is not an X509Certificate");
                }
                builder = builder.loadTrustMaterial(this.keyStore, null);
            }
            if (clientCertificates != null && clientCertificates.size() > 0) {
                builder = builder.loadKeyMaterial(clientCertificates, clientCertificatesPassword);
            }
            SSLContext sslContext = builder.build();
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Throwable t) {
                    this.log.error(t.toString(), t);
                }
            }
            this.lastKeystoreHash = newKeystoreHash;
            this.lastConfigurationHash = newConfigurationHash;
            UsernamePasswordCredentials usernamePasswordCredentials = connectorConfiguration.getCredentials().orElse(null);
            if (usernamePasswordCredentials != null) {
                String authString = String.format("%s:%s", usernamePasswordCredentials.getUserName(), usernamePasswordCredentials.getPassword());
                byte[] credentials = Base64.getEncoder().encode(authString.getBytes(StandardCharsets.UTF_8));
                BasicHeader authHeader = new BasicHeader("Authorization", (Object)("Basic " + new String(credentials, StandardCharsets.UTF_8)));
                defaultHeaders = Collections.singletonList(authHeader);
            } else {
                defaultHeaders = Collections.emptyList();
            }
            this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)new DefaultClientTlsStrategy(sslContext, HostnameVerificationPolicy.BOTH, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build()).setDefaultHeaders(defaultHeaders).setDefaultRequestConfig(config).build();
        }
        return this.client;
    }

    @NotNull
    private String hashKeystore(@NotNull List<KeyStore> keyStores) {
        String hash = "";
        try {
            for (KeyStore keyStore : keyStores) {
                if (keyStore == null) continue;
                Enumeration<String> alias = keyStore.aliases();
                while (alias.hasMoreElements()) {
                    try {
                        Certificate certificate = keyStore.getCertificate(alias.nextElement());
                        hash = hash + Hashing.md5().hashBytes(certificate.getEncoded()).toString();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hash;
    }

    @NotNull
    private String hashConfiguration(@NotNull TIConnectorConfiguration connectorConfiguration) {
        String uri = connectorConfiguration.getUri().toString();
        String cred = connectorConfiguration.getCredentials().map(c -> c.getUserName() + c.getPassword()).orElse("");
        return Hashing.md5().hashBytes((uri + cred).getBytes(StandardCharsets.UTF_8)).toString();
    }
}

