/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector;

import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import de.gematik.ws.conn.cardservicecommon.v2.PinResponseType;
import de.gematik.ws.conn.cardservicecommon.v2.PinResultEnum;
import de.gematik.ws.conn.certificateservice.v6.ReadCardCertificateResponse;
import de.gematik.ws.conn.certificateservicecommon.v2.CertRefEnum;
import de.gematik.ws.conn.certificateservicecommon.v2.X509DataInfoListType;
import de.gematik.ws.conn.eventservice.v7.GetCardsResponse;
import de.gematik.ws.conn.servicedirectory.v3.ConnectorServices;
import de.gematik.ws.conn.signatureservice.v7.ExternalAuthenticateResponse;
import de.gematik.ws.conn.signatureservice.v7.GetJobNumberResponse;
import de.gematik.ws.conn.signatureservice.v7.SignDocumentResponse;
import de.gematik.ws.conn.signatureservice.v7.SignResponse;
import de.gematik.ws.tel.error.v2.Error;
import de.impfsoft.ticonnector.ConnectorException;
import de.impfsoft.ticonnector.Signature;
import de.impfsoft.ticonnector.TIConnectorConfiguration;
import de.impfsoft.ticonnector.TIConnectorContext;
import de.impfsoft.ticonnector.TIConnectorService;
import de.impfsoft.ticonnector.TiConnectorHttpClientProvider;
import de.impfsoft.ticonnector.TiEndpoints;
import de.impfsoft.ticonnector.model.ExternalAuthenticateResponeEnvelope;
import de.impfsoft.ticonnector.model.Fault;
import de.impfsoft.ticonnector.model.GetCardsResponeEnvelope;
import de.impfsoft.ticonnector.model.GetJobNumberEnvelope;
import de.impfsoft.ticonnector.model.PinResponseEnvelope;
import de.impfsoft.ticonnector.model.ReadCardCertificateResponseEnvelope;
import de.impfsoft.ticonnector.model.SignDocumentResponeEnvelope;
import de.impfsoft.ticonnector.model.TiVersion;
import de.impfsoft.ticonnector.model.generic.Body;
import de.impfsoft.ticonnector.model.generic.Envelope;
import de.impfsoft.ticonnector.sysconfig.RouteManager;
import de.impfsoft.ticonnector.utils.Utilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilderException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.NumericEntityEscaper;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TIConnectorServiceImpl
implements TIConnectorService {
    @NotNull
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final CharSequenceTranslator escaper = StringEscapeUtils.ESCAPE_XML10.with(new CharSequenceTranslator[]{NumericEntityEscaper.between((int)127, (int)Integer.MAX_VALUE)});
    private final Set<CardTypeType> allowedCardTypes = Sets.newHashSet((Object[])new CardTypeType[]{CardTypeType.HBA_Q_SIG, CardTypeType.HBA, CardTypeType.SMC_B, CardTypeType.HB_AX});
    private final TiConnectorHttpClientProvider clientProvider;
    private final TiVersion signingServiceMinVersion = TiVersion.fromNumbers(2, 1, 0);
    private final TiVersion authServiceMinVersion = TiVersion.fromNumbers(2, 1, 0);
    private final TiVersion cardServiceMinVersion = TiVersion.fromNumbers(2, 1, 0);
    @NotNull
    private final RouteManager routeManager = new RouteManager();
    private final Map<String, X509DataInfoListType.X509DataInfo> certCache = new HashMap<String, X509DataInfoListType.X509DataInfo>();

    public TIConnectorServiceImpl(boolean includeTestCertificates) {
        try {
            this.clientProvider = new TiConnectorHttpClientProvider(includeTestCertificates);
        }
        catch (KeyStoreException ke) {
            throw new IllegalStateException(ke.toString(), ke);
        }
    }

    @Override
    @NotNull
    public Signature signPdfDocument(@NotNull TIConnectorConfiguration connectorConfiguration, @Nullable String cardIccsn, @NotNull InputStream document) throws ConnectorException {
        return this.signDocument(connectorConfiguration, DocumentType.PDF, cardIccsn, document);
    }

    @Override
    @NotNull
    public Signature signTextDocument(@NotNull TIConnectorConfiguration connectorConfiguration, @Nullable String cardIccsn, @NotNull InputStream document) throws ConnectorException {
        return this.signDocument(connectorConfiguration, DocumentType.TEXT_PLAIN, cardIccsn, document);
    }

    @NotNull
    public Signature signDocument(@NotNull TIConnectorConfiguration connectorConfiguration, @NotNull DocumentType documentType, @Nullable String cardIccsn, @NotNull InputStream document) throws ConnectorException {
        return this.signDocumentInternal(connectorConfiguration, documentType, cardIccsn, document, 0);
    }

    @NotNull
    private Signature signDocumentInternal(@NotNull TIConnectorConfiguration connectorConfiguration, @NotNull DocumentType documentType, @Nullable String cardIccsn, @NotNull InputStream document, int count) throws ConnectorException {
        if (count >= 3) {
            throw new ConnectorException("Die maximale Anzahl von Pin-Verifikationsversuchen wurde \u00fcberschritten", ConnectorException.ExceptionType.MAX_TRIES_EXCEEDED);
        }
        TiEndpoints tiEndpoints = this.getConnectorServices(connectorConfiguration, this.signingServiceMinVersion);
        CardInfoType cardInfoType = this.getCards(connectorConfiguration, tiEndpoints).getCards().getCard().stream().filter(cit -> this.allowedCardTypes.contains((Object)cit.getCardType())).filter(cit -> cardIccsn == null || cit.getIccsn().equals(cardIccsn)).findAny().orElseThrow(() -> new ConnectorException("Im Connector wurde keine passende Karte gefunden!", ConnectorException.ExceptionType.NO_CARD));
        try {
            String jobNumber = this.getJobNumber(connectorConfiguration, tiEndpoints).getJobNumber();
            byte[] signedDocument = ((SignResponse)this.signDocument(connectorConfiguration, tiEndpoints, cardInfoType.getCardHandle(), jobNumber, documentType, document).getSignResponse().stream().findAny().orElseThrow(() -> new ConnectorException("Response is missing in signDocument", ConnectorException.ExceptionType.INTERNAL))).getSignatureObject().getBase64Signature().getValue();
            return new Signature(new ByteArrayInputStream(signedDocument), cardInfoType.getCardType());
        }
        catch (ConnectorException ce) {
            PinResponseType responseType;
            if (ce.getType() == ConnectorException.ExceptionType.PIN_NEEDS_VERIFICATION && (responseType = this.verifyPin(connectorConfiguration, cardInfoType.getIccsn())).getPinResult() == PinResultEnum.OK) {
                return this.signDocumentInternal(connectorConfiguration, documentType, cardIccsn, document, count + 1);
            }
            throw ce;
        }
    }

    @Override
    @NotNull
    public GetCardsResponse queryCards(@NotNull TIConnectorConfiguration connectorConfiguration) throws ConnectorException {
        TiEndpoints tiEndpoints = this.getConnectorServices(connectorConfiguration, this.cardServiceMinVersion);
        return this.getCards(connectorConfiguration, tiEndpoints);
    }

    @NotNull
    public GetCardsResponse getCards(@NotNull TIConnectorConfiguration tiConnectorConfiguration, @NotNull TiEndpoints tiEndpoints) throws ConnectorException {
        TIConnectorContext context = tiConnectorConfiguration.getContext();
        String body = String.format("<?xml version=\"1.0\" ?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ZSTI_EventService=\"http://ws.gematik.de/conn/EventService/WSDL/v7.2\" xmlns:ZSTI_EVT=\"http://ws.gematik.de/conn/EventService/v7.2\" xmlns:ZSTI_CONN=\"http://ws.gematik.de/conn/ConnectorCommon/v5.0\" xmlns:ZSTI_GERROR=\"http://ws.gematik.de/tel/error/v2.0\" xmlns:dss=\"urn:oasis:names:tc:dss:1.0:core:schema\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\" xmlns:ZSTI_CCTX=\"http://ws.gematik.de/conn/ConnectorContext/v2.0\" xmlns:ZSTI_CARD=\"http://ws.gematik.de/conn/CardService/v8.1\" xmlns:ZSTI_CARDCMN=\"http://ws.gematik.de/conn/CardServiceCommon/v2.0\" xmlns:ZSTI_PI=\"http://ws.gematik.de/int/version/ProductInformation/v1.1\" xmlns:ZSTI_CTI=\"http://ws.gematik.de/conn/CardTerminalInfo/v8.0\" xmlns:ZSTI_HSM=\"http://ws.gematik.de/conn/HsmInfo/v8.0\" xsl:version=\"1.0\">\n  <soap:Body>\n    <ZSTI_EVT:GetCards mandant-wide=\"true\">\n      <ZSTI_CCTX:Context>\n        <ZSTI_CONN:MandantId>%s</ZSTI_CONN:MandantId>\n        <ZSTI_CONN:ClientSystemId>%s</ZSTI_CONN:ClientSystemId>\n        <ZSTI_CONN:WorkplaceId>%s</ZSTI_CONN:WorkplaceId>\n      </ZSTI_CCTX:Context>\n    </ZSTI_EVT:GetCards>\n  </soap:Body>\n</soap:Envelope>", this.escaper.translate((CharSequence)context.getMandantId()), this.escaper.translate((CharSequence)context.getClientSystemId()), this.escaper.translate((CharSequence)context.getWorkplaceId()));
        String result = null;
        String contextMsg = "Ein unbekannter Fehler ist bei der Abfrage der gesteckten Karten aufgetreten.";
        CloseableHttpResponse response = null;
        try {
            URI subUri = tiEndpoints.getServiceURL(TiEndpoints.TiService.EventService, tiConnectorConfiguration.useTLS());
            this.log.info("process getCards");
            this.log.info("Send to {} with body\n{}", (Object)subUri, (Object)body);
            ClassicHttpRequest request = ClassicRequestBuilder.post((URI)subUri).addHeader("Content-Type", "text/xml; charset=utf-8;").addHeader("SOAPAction", "\"http://ws.gematik.de/conn/EventService/v7.2#GetCards\"").addHeader("User-Agent", "wsdl2objc;").setEntity((HttpEntity)new StringEntity(body)).build();
            response = this.clientProvider.getHttpClient(tiConnectorConfiguration).execute(request);
            result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.log.info("Retrieve response: {}\n", (Object)result);
            if (result.isEmpty()) {
                throw this.makeConnectorEmptyResponseException("Ein unbekannter Fehler ist bei der Abfrage der gesteckten Karten aufgetreten.", (HttpResponse)response);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GetCardsResponeEnvelope.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            GetCardsResponse getCardsResponse = (GetCardsResponse)TIConnectorServiceImpl.unwrapResult((GetCardsResponeEnvelope)unmarshaller.unmarshal(IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8)));
            return getCardsResponse;
        }
        catch (ConnectorException t2) {
            throw t2;
        }
        catch (Throwable t) {
            throw this.convertToConnectorException("Ein unbekannter Fehler ist bei der Abfrage der gesteckten Karten aufgetreten.", result, t);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            this.log.info("finished getCards");
        }
    }

    @NotNull
    public GetJobNumberResponse getJobNumber(@NotNull TIConnectorConfiguration tiConnectorConfiguration, @NotNull TiEndpoints endpoints) {
        TIConnectorContext context = tiConnectorConfiguration.getContext();
        String body = String.format("<?xml version=\"1.0\"?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ZSTI_SignatureService=\"http://ws.gematik.de/conn/SignatureService/WSDL/v7.4\" xmlns:ZSTI_SIG=\"http://ws.gematik.de/conn/SignatureService/v7.4\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:sp=\"urn:oasis:names:tc:dss-x:1.0:profiles:SignaturePolicy:schema#\" xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\" xmlns:dss=\"urn:oasis:names:tc:dss:1.0:core:schema\" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\" xmlns:vr=\"urn:oasis:names:tc:dss-x:1.0:profiles:verificationreport:schema#\" xmlns:tsl=\"http://uri.etsi.org/02231/v2#\" xmlns:saml2=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:ZSTI_CERTCMN=\"http://ws.gematik.de/conn/CertificateServiceCommon/v2.0\" xmlns:ZSTI_CONN=\"http://ws.gematik.de/conn/ConnectorCommon/v5.0\" xmlns:ZSTI_GERROR=\"http://ws.gematik.de/tel/error/v2.0\" xmlns:ZSTI_CCTX=\"http://ws.gematik.de/conn/ConnectorContext/v2.0\" xsl:version=\"1.0\">\n  <soap:Body>\n    <ZSTI_SIG:GetJobNumber>\n      <ZSTI_CCTX:Context>\n        <ZSTI_CONN:MandantId>%s</ZSTI_CONN:MandantId>\n        <ZSTI_CONN:ClientSystemId>%s</ZSTI_CONN:ClientSystemId>\n        <ZSTI_CONN:WorkplaceId>%s</ZSTI_CONN:WorkplaceId>\n      </ZSTI_CCTX:Context>\n    </ZSTI_SIG:GetJobNumber>\n  </soap:Body>\n</soap:Envelope>", this.escaper.translate((CharSequence)context.getMandantId()), this.escaper.translate((CharSequence)context.getClientSystemId()), this.escaper.translate((CharSequence)context.getWorkplaceId()));
        String contextMsg = "Ein unbekannter Fehler ist bei der Anfrage nach eine Jobnumber aufgetreten.";
        String result = null;
        CloseableHttpResponse response = null;
        try {
            URI subUri = endpoints.getServiceURL(TiEndpoints.TiService.SignatureService, tiConnectorConfiguration.useTLS());
            this.log.info("process getJobNumber");
            this.log.info("Send to {} with body\n{}", (Object)subUri, (Object)body);
            ClassicHttpRequest request = ClassicRequestBuilder.post((URI)subUri).addHeader("Content-Type", "text/xml; charset=utf-8;").addHeader("SOAPAction", "\"http://ws.gematik.de/conn/SignatureService/WSDL/v7.4#GetJobNumber\"").addHeader("User-Agent", "wsdl2objc;").setEntity((HttpEntity)new StringEntity(body)).build();
            response = this.clientProvider.getHttpClient(tiConnectorConfiguration).execute(request);
            result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.log.info("Retrieve response: {}\n", (Object)result);
            if (result.isEmpty()) {
                throw this.makeConnectorEmptyResponseException(contextMsg, (HttpResponse)response);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GetJobNumberEnvelope.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            GetJobNumberResponse getJobNumberResponse = (GetJobNumberResponse)TIConnectorServiceImpl.unwrapResult((GetJobNumberEnvelope)unmarshaller.unmarshal(IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8)));
            return getJobNumberResponse;
        }
        catch (ConnectorException t2) {
            throw t2;
        }
        catch (Throwable t) {
            throw this.convertToConnectorException(contextMsg, result, t);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    @Override
    @NotNull
    public X509DataInfoListType.X509DataInfo queryCertificateViaCardInfoType(@NotNull TIConnectorConfiguration connectorConfiguration, @NotNull CardInfoType cardInfoType, @Nullable List<CertRefEnum> certRefs) throws ConnectorException {
        return this.certCache.computeIfAbsent(cardInfoType.getIccsn(), s -> this.loadCertificateFromCard(connectorConfiguration, cardInfoType, certRefs));
    }

    @Override
    @NotNull
    public X509DataInfoListType.X509DataInfo queryCertificateViaIccsn(@NotNull TIConnectorConfiguration connectorConfiguration, @Nullable String iccsnOverwrite, @Nullable List<CertRefEnum> certRefEnums) throws ConnectorException {
        String cardIccsn = connectorConfiguration.getCardIccsn().orElse(iccsnOverwrite);
        TiEndpoints tiEndpoints = this.getConnectorServices(connectorConfiguration, this.cardServiceMinVersion);
        CardInfoType cardInfoType = this.getCards(connectorConfiguration, tiEndpoints).getCards().getCard().stream().filter(cit -> this.allowedCardTypes.contains((Object)cit.getCardType())).filter(cit -> cardIccsn == null || cit.getIccsn().equals(cardIccsn)).findAny().orElseThrow(() -> new ConnectorException("Im Connector wurde keine passende Karte gefunden!", ConnectorException.ExceptionType.NO_CARD));
        return this.queryCertificateViaCardInfoType(connectorConfiguration, cardInfoType, certRefEnums);
    }

    @NotNull
    private X509DataInfoListType.X509DataInfo loadCertificateFromCard(@NotNull TIConnectorConfiguration connectorConfiguration, @NotNull CardInfoType cardInfoType, @Nullable List<CertRefEnum> certRefEnums) {
        try {
            List<Object> certRefs;
            TiEndpoints tiEndpoints;
            block12: {
                block11: {
                    tiEndpoints = this.getConnectorServices(connectorConfiguration, this.cardServiceMinVersion);
                    if (certRefEnums != null) break block11;
                    switch (cardInfoType.getCardType()) {
                        case SMC_B: {
                            certRefs = Collections.singletonList(CertRefEnum.C_SIG.value());
                            break block12;
                        }
                        case HBA: 
                        case HBA_Q_SIG: 
                        case HB_AX: {
                            certRefs = Arrays.asList(CertRefEnum.C_SIG.value(), CertRefEnum.C_QES.value());
                            break block12;
                        }
                        default: {
                            throw new ConnectorException("Kartentyp " + (Object)((Object)cardInfoType.getCardType()) + " wird nicht unterst\u00fctzt!", ConnectorException.ExceptionType.UNKNOWN);
                        }
                    }
                }
                certRefs = certRefEnums.stream().map(CertRefEnum::value).collect(Collectors.toList());
            }
            Throwable lastException = null;
            for (String string : certRefs) {
                try {
                    return this.tryToLoadCertificate(connectorConfiguration, tiEndpoints, cardInfoType, string);
                }
                catch (Throwable t2) {
                    lastException = t2;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
            throw new IllegalStateException("should never happen");
        }
        catch (ConnectorException t2) {
            throw t2;
        }
        catch (Throwable t) {
            throw this.convertToConnectorException("Ein unbekannter Fehler ist beim Auslesen des Kartenzertifikats aufgetreten.", null, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private X509DataInfoListType.X509DataInfo tryToLoadCertificate(@NotNull TIConnectorConfiguration connectorConfiguration, @NotNull TiEndpoints tiEndpoints, @NotNull CardInfoType cardInfoType, @NotNull String certRef) throws URISyntaxException, IOException, JAXBException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        TIConnectorContext context = connectorConfiguration.getContext();
        String body = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ZSTI_SignatureService=\"http://ws.gematik.de/conn/SignatureService/WSDL/v7.4\" xmlns:ZSTI_SIG=\"http://ws.gematik.de/conn/SignatureService/v7.4\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:sp=\"urn:oasis:names:tc:dss-x:1.0:profiles:SignaturePolicy:schema#\" xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\" xmlns:dss=\"urn:oasis:names:tc:dss:1.0:core:schema\" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\" xmlns:vr=\"urn:oasis:names:tc:dss-x:1.0:profiles:verificationreport:schema#\" xmlns:tsl=\"http://uri.etsi.org/02231/v2#\" xmlns:saml2=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:CERT=\"http://ws.gematik.de/conn/CertificateService/v6.0\"\nxmlns:ZSTI_CERTCMN=\"http://ws.gematik.de/conn/CertificateServiceCommon/v2.0\" xmlns:CONN=\"http://ws.gematik.de/conn/ConnectorCommon/v5.0\"\nxmlns:ZSTI_GERROR=\"http://ws.gematik.de/tel/error/v2.0\" xmlns:CCTX=\"http://ws.gematik.de/conn/ConnectorContext/v2.0\"\nxsl:version=\"1.0\">\n  <soap:Body>\n<CERT:ReadCardCertificate>\n <CONN:CardHandle>%s</CONN:CardHandle>\n <CCTX:Context>\n <CONN:MandantId>%s</CONN:MandantId>\n <CONN:ClientSystemId>%s</CONN:ClientSystemId>\n <CONN:WorkplaceId>%s</CONN:WorkplaceId>\n <CONN:UserId>%s</CONN:UserId>\n </CCTX:Context>\n <CERT:CertRefList>\n <CERT:CertRef>" + certRef + "</CERT:CertRef>\n </CERT:CertRefList>\n</CERT:ReadCardCertificate>  </soap:Body>\n</soap:Envelope>", this.escaper.translate((CharSequence)cardInfoType.getCardHandle()), this.escaper.translate((CharSequence)context.getMandantId()), this.escaper.translate((CharSequence)context.getClientSystemId()), this.escaper.translate((CharSequence)context.getWorkplaceId()), this.escaper.translate((CharSequence)context.getUserId().orElse("Test")));
        URI subUri = tiEndpoints.getServiceURL(TiEndpoints.TiService.CertificateService, connectorConfiguration.useTLS());
        this.log.info("process readCertificate");
        this.log.info("Send to {} with body\n{}", (Object)subUri, (Object)body);
        ClassicHttpRequest request = ClassicRequestBuilder.post((URI)subUri).addHeader("Content-Type", "text/xml; charset=utf-8;").addHeader("SOAPAction", "\"http://ws.gematik.de/conn/CertificateService/v6.0#ReadCardCertificate\"").addHeader("User-Agent", "wsdl2objc;").setEntity((HttpEntity)new StringEntity(body)).build();
        CloseableHttpResponse response = null;
        try {
            response = this.clientProvider.getHttpClient(connectorConfiguration).execute(request);
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.log.info("Retrieve response: {}\n", (Object)result);
            String contextMsg = "Ein unbekannter Fehler ist beim Auslesen des Kartenzertifikats aufgetreten";
            if (result.isEmpty()) {
                throw this.makeConnectorEmptyResponseException("Ein unbekannter Fehler ist beim Auslesen des Kartenzertifikats aufgetreten", (HttpResponse)response);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ReadCardCertificateResponseEnvelope.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            X509DataInfoListType.X509DataInfo x509DataInfo = (X509DataInfoListType.X509DataInfo)((ReadCardCertificateResponse)TIConnectorServiceImpl.unwrapResult((ReadCardCertificateResponseEnvelope)unmarshaller.unmarshal(IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8)))).getX509DataInfoList().getX509DataInfo().stream().findAny().orElseThrow(() -> new ConnectorException("no certificate found", ConnectorException.ExceptionType.UNKNOWN));
            return x509DataInfo;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    @NotNull
    public SignDocumentResponse signDocument(@NotNull TIConnectorConfiguration tiConnectorConfiguration, @NotNull TiEndpoints tiEndpoints, @NotNull String cardHandle, @NotNull String jobNumber, @NotNull DocumentType documentType, @NotNull InputStream document) {
        String result = null;
        String contextMsg = "Ein unbekannter Fehler ist bei der Signierung eines Dokumentes aufgetreten.";
        CloseableHttpResponse response = null;
        try {
            TIConnectorContext context = tiConnectorConfiguration.getContext();
            byte[] content = IOUtils.toByteArray((InputStream)document);
            String base64Content = Base64.getEncoder().encodeToString(content);
            String body = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ZSTI_SignatureService=\"http://ws.gematik.de/conn/SignatureService/WSDL/v7.4\" xmlns:ZSTI_SIG=\"http://ws.gematik.de/conn/SignatureService/v7.4\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:sp=\"urn:oasis:names:tc:dss-x:1.0:profiles:SignaturePolicy:schema#\" xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\" xmlns:dss=\"urn:oasis:names:tc:dss:1.0:core:schema\" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\" xmlns:vr=\"urn:oasis:names:tc:dss-x:1.0:profiles:verificationreport:schema#\" xmlns:tsl=\"http://uri.etsi.org/02231/v2#\" xmlns:saml2=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:ZSTI_CERTCMN=\"http://ws.gematik.de/conn/CertificateServiceCommon/v2.0\" xmlns:ZSTI_CONN=\"http://ws.gematik.de/conn/ConnectorCommon/v5.0\" xmlns:ZSTI_GERROR=\"http://ws.gematik.de/tel/error/v2.0\" xmlns:ZSTI_CCTX=\"http://ws.gematik.de/conn/ConnectorContext/v2.0\" xsl:version=\"1.0\">\n  <soap:Body>\n    <ZSTI_SIG:SignDocument>\n      <ZSTI_CONN:CardHandle>%s</ZSTI_CONN:CardHandle>\n      <ZSTI_CCTX:Context>\n        <ZSTI_CONN:MandantId>%s</ZSTI_CONN:MandantId>\n        <ZSTI_CONN:ClientSystemId>%s</ZSTI_CONN:ClientSystemId>\n        <ZSTI_CONN:WorkplaceId>%s</ZSTI_CONN:WorkplaceId>\n$USER_ID$      </ZSTI_CCTX:Context>\n      <ZSTI_SIG:TvMode>NONE</ZSTI_SIG:TvMode>\n      <ZSTI_SIG:JobNumber>%s</ZSTI_SIG:JobNumber>\n      <ZSTI_SIG:SignRequest RequestID=\"PUP-000\">\n        <ZSTI_SIG:OptionalInputs>\n          <dss:SignatureType>%s</dss:SignatureType>\n        </ZSTI_SIG:OptionalInputs>\n        <ZSTI_SIG:Document ShortText=\"Impfzertifikat\">\n          <dss:Base64Data MimeType=\"%s\">%s</dss:Base64Data>\n        </ZSTI_SIG:Document>\n        <ZSTI_SIG:IncludeRevocationInfo>false</ZSTI_SIG:IncludeRevocationInfo>\n      </ZSTI_SIG:SignRequest>\n    </ZSTI_SIG:SignDocument>\n  </soap:Body>\n</soap:Envelope>\n", this.escaper.translate((CharSequence)cardHandle), this.escaper.translate((CharSequence)context.getMandantId()), this.escaper.translate((CharSequence)context.getClientSystemId()), this.escaper.translate((CharSequence)context.getWorkplaceId()), this.escaper.translate((CharSequence)jobNumber), this.escaper.translate((CharSequence)documentType.getSignatureType()), this.escaper.translate((CharSequence)documentType.getMimeType()), this.escaper.translate((CharSequence)base64Content));
            String userId = context.getUserId().orElse(null);
            body = userId == null ? body.replace("$USER_ID$", "") : body.replace("$USER_ID$", "        <ZSTI_CONN:UserId>" + this.escaper.translate((CharSequence)userId) + "</ZSTI_CONN:UserId>\n");
            URI subUri = tiEndpoints.getServiceURL(TiEndpoints.TiService.SignatureService, tiConnectorConfiguration.useTLS());
            this.log.info("process signDocument");
            this.log.info("Send to {} with body\n{}", (Object)subUri, (Object)body);
            ClassicHttpRequest request = ClassicRequestBuilder.post((URI)subUri).addHeader("Content-Type", "text/xml; charset=utf-8;").addHeader("SOAPAction", "\"http://ws.gematik.de/conn/SignatureService/WSDL/v7.4#SignDocument\"").addHeader("User-Agent", "wsdl2objc;").setEntity((HttpEntity)new StringEntity(body)).build();
            response = this.clientProvider.getHttpClient(tiConnectorConfiguration).execute(request);
            result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.log.info("Retrieve response: {}\n", (Object)result);
            if (result.isEmpty()) {
                throw this.makeConnectorEmptyResponseException("Ein unbekannter Fehler ist bei der Signierung eines Dokumentes aufgetreten.", (HttpResponse)response);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SignDocumentResponeEnvelope.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SignDocumentResponse signDocumentResponse = (SignDocumentResponse)TIConnectorServiceImpl.unwrapResult((SignDocumentResponeEnvelope)unmarshaller.unmarshal(IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8)));
            return signDocumentResponse;
        }
        catch (ConnectorException t2) {
            throw t2;
        }
        catch (Throwable t) {
            throw this.convertToConnectorException("Ein unbekannter Fehler ist bei der Signierung eines Dokumentes aufgetreten.", result, t);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    @Override
    @NotNull
    public ExternalAuthenticateResponse externalAuthenticate(@NotNull TIConnectorConfiguration connectorConfiguration, @NotNull CardInfoType cardInfoType, @NotNull String challenge) throws ConnectorException {
        String result = null;
        String contextMsg = "Ein unbekannter Fehler ist bei der Ausstellung der Authentifizierungssignatur aufgetreten";
        CloseableHttpResponse response = null;
        try {
            TiEndpoints tiEndpoints = this.getConnectorServices(connectorConfiguration, this.authServiceMinVersion);
            TIConnectorContext context = connectorConfiguration.getContext();
            byte[] hash = Hashing.sha256().hashBytes(challenge.getBytes(StandardCharsets.UTF_8)).asBytes();
            String hashEnc = Base64.getEncoder().encodeToString(hash);
            String body = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n    <soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ZSTI_AuthSignatureService=\"http://ws.gematik.de/conn/AuthSignatureService/WSDL/v7.4\" xmlns:ZSTI_SIG=\"http://ws.gematik.de/conn/SignatureService/v7.4\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:sp=\"urn:oasis:names:tc:dss-x:1.0:profiles:SignaturePolicy:schema#\" xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\" xmlns:dss=\"urn:oasis:names:tc:dss:1.0:core:schema\" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\" xmlns:vr=\"urn:oasis:names:tc:dss-x:1.0:profiles:verificationreport:schema#\" xmlns:tsl=\"http://uri.etsi.org/02231/v2#\" xmlns:saml2=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:ZSTI_CERTCMN=\"http://ws.gematik.de/conn/CertificateServiceCommon/v2.0\" xmlns:ZSTI_CONN=\"http://ws.gematik.de/conn/ConnectorCommon/v5.0\" xmlns:ZSTI_GERROR=\"http://ws.gematik.de/tel/error/v2.0\" xmlns:ZSTI_CCTX=\"http://ws.gematik.de/conn/ConnectorContext/v2.0\" xsl:version=\"1.0\">\n      <soap:Body>\n        <ZSTI_SIG:ExternalAuthenticate>\n          <ZSTI_CONN:CardHandle>%s</ZSTI_CONN:CardHandle>\n          <ZSTI_CCTX:Context>\n            <ZSTI_CONN:MandantId>%s</ZSTI_CONN:MandantId>\n            <ZSTI_CONN:ClientSystemId>%s</ZSTI_CONN:ClientSystemId>\n            <ZSTI_CONN:WorkplaceId>%s</ZSTI_CONN:WorkplaceId>\n          </ZSTI_CCTX:Context>\n          <ZSTI_SIG:OptionalInputs>\n            <dss:SignatureType>urn:ietf:rfc:3447</dss:SignatureType>\n            <ZSTI_SIG:SignatureSchemes>RSASSA-PSS</ZSTI_SIG:SignatureSchemes>\n          </ZSTI_SIG:OptionalInputs>\n          <ZSTI_SIG:BinaryString>\n            <dss:Base64Data MimeType=\"application/octet-stream\">%s</dss:Base64Data>\n          </ZSTI_SIG:BinaryString>\n        </ZSTI_SIG:ExternalAuthenticate>\n      </soap:Body>\n    </soap:Envelope>", this.escaper.translate((CharSequence)cardInfoType.getCardHandle()), this.escaper.translate((CharSequence)context.getMandantId()), this.escaper.translate((CharSequence)context.getClientSystemId()), this.escaper.translate((CharSequence)context.getWorkplaceId()), this.escaper.translate((CharSequence)hashEnc));
            URI subUri = tiEndpoints.getServiceURL(TiEndpoints.TiService.AuthSignatureService, connectorConfiguration.useTLS());
            this.log.info("process externalAuth");
            this.log.info("Send to {} with body\n{}", (Object)subUri, (Object)body);
            ClassicHttpRequest request = ClassicRequestBuilder.post((URI)subUri).addHeader("Content-Type", "text/xml; charset=utf-8;").addHeader("SOAPAction", "\"http://ws.gematik.de/conn/SignatureService/v7.4#ExternalAuthenticate\"").addHeader("User-Agent", "wsdl2objc;").setEntity((HttpEntity)new StringEntity(body)).build();
            response = this.clientProvider.getHttpClient(connectorConfiguration).execute(request);
            result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.log.info("Retrieve response: {}\n", (Object)result);
            if (result.isEmpty()) {
                throw this.makeConnectorEmptyResponseException("Ein unbekannter Fehler ist bei der Ausstellung der Authentifizierungssignatur aufgetreten", (HttpResponse)response);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ExternalAuthenticateResponeEnvelope.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ExternalAuthenticateResponse externalAuthenticateResponse = (ExternalAuthenticateResponse)TIConnectorServiceImpl.unwrapResult((ExternalAuthenticateResponeEnvelope)unmarshaller.unmarshal(IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8)));
            return externalAuthenticateResponse;
        }
        catch (ConnectorException t2) {
            throw t2;
        }
        catch (Throwable t) {
            throw this.convertToConnectorException("Ein unbekannter Fehler ist bei der Ausstellung der Authentifizierungssignatur aufgetreten", result, t);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    @Override
    @NotNull
    public PinResponseType verifyPin(@NotNull TIConnectorConfiguration connectorConfiguration, @Nullable String cardIccsn) throws ConnectorException {
        String contextMsg = "Ein unbekannter Fehler ist bei der Verifikation der Karten-PIN aufgetreten.";
        CloseableHttpResponse response = null;
        try {
            String pinTyp;
            TiEndpoints tiEndpoints = this.getConnectorServices(connectorConfiguration, this.cardServiceMinVersion);
            TIConnectorContext context = connectorConfiguration.getContext();
            CardInfoType cardInfoType = this.getCards(connectorConfiguration, tiEndpoints).getCards().getCard().stream().filter(cit -> cardIccsn == null || cit.getIccsn().equals(cardIccsn)).findAny().orElseThrow(() -> new ConnectorException("Im Connector wurde keine passende Karte gefunden!", ConnectorException.ExceptionType.NO_CARD));
            switch (cardInfoType.getCardType()) {
                case HBA: 
                case HBA_Q_SIG: 
                case HB_AX: {
                    pinTyp = "PIN.CH";
                    break;
                }
                case SMC_B: {
                    pinTyp = "PIN.SMC";
                    break;
                }
                default: {
                    throw new ConnectorException("Kann Pin nicht freischalten, da der Kartentyp nicht unterst\u00fctzt wird " + (Object)((Object)cardInfoType.getCardType()), ConnectorException.ExceptionType.CONNECTOR_ERROR);
                }
            }
            String body = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n    <soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ZSTI_AuthSignatureService=\"http://ws.gematik.de/conn/AuthSignatureService/WSDL/v7.4\" xmlns:ZSTI_SIG=\"http://ws.gematik.de/conn/SignatureService/v7.4\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:sp=\"urn:oasis:names:tc:dss-x:1.0:profiles:SignaturePolicy:schema#\" xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\" xmlns:dss=\"urn:oasis:names:tc:dss:1.0:core:schema\" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\" xmlns:vr=\"urn:oasis:names:tc:dss-x:1.0:profiles:verificationreport:schema#\" xmlns:tsl=\"http://uri.etsi.org/02231/v2#\" xmlns:saml2=\"urn:oasis:names:tc:SAML:2.0:assertion\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:ZSTI_CERTCMN=\"http://ws.gematik.de/conn/CertificateServiceCommon/v2.0\" xmlns:ZSTI_CONN=\"http://ws.gematik.de/conn/ConnectorCommon/v5.0\" xmlns:ZSTI_GERROR=\"http://ws.gematik.de/tel/error/v2.0\" xmlns:ZSTI_CCTX=\"http://ws.gematik.de/conn/ConnectorContext/v2.0\" xmlns:ZSTI_CARD=\"http://ws.gematik.de/conn/CardService/v8.1\" xmlns:ZSTI_CARDCMN=\"http://ws.gematik.de/conn/CardServiceCommon/v2.0\" xsl:version=\"1.0\">\n<soap:Body>\n<ZSTI_CARD:VerifyPin>\n<ZSTI_CCTX:Context>\n<ZSTI_CONN:MandantId>%s</ZSTI_CONN:MandantId>\n<ZSTI_CONN:ClientSystemId>%s</ZSTI_CONN:ClientSystemId>\n<ZSTI_CONN:WorkplaceId>%s</ZSTI_CONN:WorkplaceId>\n<ZSTI_CONN:UserId>%s</ZSTI_CONN:UserId>\n</ZSTI_CCTX:Context>\n<ZSTI_CONN:CardHandle>%s</ZSTI_CONN:CardHandle>\n<ZSTI_CARDCMN:PinTyp>%s</ZSTI_CARDCMN:PinTyp>\n</ZSTI_CARD:VerifyPin>\n</soap:Body>\n</soap:Envelope>", this.escaper.translate((CharSequence)context.getMandantId()), this.escaper.translate((CharSequence)context.getClientSystemId()), this.escaper.translate((CharSequence)context.getWorkplaceId()), this.escaper.translate((CharSequence)context.getUserId().orElse("unk")), this.escaper.translate((CharSequence)cardInfoType.getCardHandle()), this.escaper.translate((CharSequence)pinTyp));
            URI subUri = tiEndpoints.getServiceURL(TiEndpoints.TiService.CardService, connectorConfiguration.useTLS());
            this.log.info("process externalAuth");
            this.log.info("Send to {} with body\n{}", (Object)subUri, (Object)body);
            ClassicHttpRequest request = ClassicRequestBuilder.post((URI)subUri).addHeader("Content-Type", "text/xml; charset=utf-8;").addHeader("SOAPAction", "\"http://ws.gematik.de/conn/CardService/v8.1#VerifyPin\"").addHeader("User-Agent", "wsdl2objc;").setEntity((HttpEntity)new StringEntity(body)).build();
            response = this.clientProvider.getHttpClient(connectorConfiguration).execute(request);
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            this.log.info("Retrieve response: {}\n", (Object)result);
            if (result.isEmpty()) {
                throw this.makeConnectorEmptyResponseException("Ein unbekannter Fehler ist bei der Verifikation der Karten-PIN aufgetreten.", (HttpResponse)response);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PinResponseEnvelope.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            PinResponseType pinResponseType = (PinResponseType)TIConnectorServiceImpl.unwrapResult((PinResponseEnvelope)unmarshaller.unmarshal(IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8)));
            return pinResponseType;
        }
        catch (Throwable t) {
            if (t instanceof ConnectorException) {
                throw (ConnectorException)t;
            }
            throw new ConnectorException(t.toString(), ConnectorException.ExceptionType.UNKNOWN, t);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    @NotNull
    private static <T extends Envelope<V>, V extends Body<W>, W> W unwrapResult(@NotNull T envelope) throws ConnectorException {
        W body = ((Body)envelope.getBody()).getResponse().orElse(null);
        if (body == null) {
            Fault fault = ((Body)envelope.getBody()).getFault().orElse(null);
            if (fault != null) {
                Error.Trace t;
                Error error = fault.getError().orElse(null);
                if (error != null && (t = (Error.Trace)error.getTrace().stream().findFirst().orElse(null)) != null && t.getCode().intValue() == 4085) {
                    throw new ConnectorException("Die PIN muss verifiziert werden!", ConnectorException.ExceptionType.PIN_NEEDS_VERIFICATION);
                }
                throw new ConnectorException(fault.getFaultDescription().orElse("<UNKNOWN>"), ConnectorException.ExceptionType.CONNECTOR_ERROR);
            }
            throw new ConnectorException("<UNKNOWN*>", ConnectorException.ExceptionType.CONNECTOR_ERROR);
        }
        return body;
    }

    @NotNull
    public TiEndpoints getConnectorServices(@NotNull TIConnectorConfiguration tiConnectorConfiguration, @Nullable TiVersion requiredProductVersion) {
        try {
            ConnectorServices services;
            String result;
            URI subUri = new URI(tiConnectorConfiguration.getUri().toString() + "/connector.sds");
            ClassicHttpRequest request = ClassicRequestBuilder.get((URI)subUri).addHeader("Content-Type", "text/xml; charset=utf-8;").build();
            CloseableHttpResponse response = null;
            try {
                response = this.clientProvider.getHttpClient(tiConnectorConfiguration).execute(request);
                result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                this.log.info("Retrieve response: {}\n", (Object)result);
            }
            catch (Throwable t) {
                CertPathBuilderException exception = Utilities.findCause(t, CertPathBuilderException.class).orElse(null);
                if (exception != null) {
                    try {
                        Method m = exception.getClass().getMethod("getAdjacencyList", new Class[0]);
                        m.setAccessible(true);
                        this.log.info("result:" + m.invoke((Object)exception, new Object[0]));
                        this.log.error("PKIX Building failed: ", (Object)m.invoke((Object)exception, new Object[0]).toString());
                    }
                    catch (Throwable t2) {
                        this.log.error(t2.toString(), t2);
                    }
                    throw new ConnectorException("Auf den Konnektor konnte nicht zugegriffen werden, da das Server-Zertifikat des Konnektors nicht als vertrauensw\u00fcrdig erkannt wird.", ConnectorException.ExceptionType.CONFIGURATION_ERROR, t);
                }
                throw new ConnectorException("Auf den Konnektor konnte nicht zugegriffen werden. Bitte pr\u00fcfen Sie die Adresse des Konnektors!", ConnectorException.ExceptionType.CONFIGURATION_ERROR, t);
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            if (response.getCode() == 401) {
                throw new ConnectorException("Der Zugriff wurde vom Konnektor verweigert. Pr\u00fcfen Sie Nutzername/Password/Client-Zertifikat", ConnectorException.ExceptionType.CONFIGURATION_ERROR);
            }
            if (response.getCode() == 404) {
                throw new ConnectorException("Der Zugriff auf den Konnektor ist mit Fehler 404 gescheitert. Bitte pr\u00fcfen Sie die Adresse des Konnektors!", ConnectorException.ExceptionType.CONFIGURATION_ERROR);
            }
            if (result.isEmpty()) {
                throw this.makeConnectorEmptyResponseException("Beim Abruf des Service-Directories ist ein Fehler aufgetreten.", (HttpResponse)response);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConnectorServices.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (requiredProductVersion != null) {
                Pattern pattern = Pattern.compile("<ProductTypeVersion>.*</ProductTypeVersion>");
                Matcher matcher = pattern.matcher(result);
                if (!matcher.find()) {
                    String startTxt = result.substring(0, Math.min(100, result.length()));
                    throw new ConnectorException("Das Service-Directory kann nicht gelesen werden! Pr\u00fcfen Sie ob eine Firewall den Zugriff blockiert oder die Firmware des Konnektors zu alt ist. Die empfangene Nachricht lautet: " + startTxt + "[..]", ConnectorException.ExceptionType.CONFIGURATION_ERROR);
                }
                String version = matcher.group().replace("<ProductTypeVersion>", "").replace("</ProductTypeVersion>", "");
                TiVersion currentVersion = TiVersion.fromString(version);
                if (currentVersion.isLessThan(requiredProductVersion)) {
                    throw new ConnectorException(String.format("Die Firmware des Konnektors ist veraltet! F\u00fcr die Funktion wird Version %s ben\u00f6tigt. Der Konnektor ist aktuell auf Version %s", currentVersion.toString(), requiredProductVersion.toString()), ConnectorException.ExceptionType.WRONG_VERSION);
                }
            }
            try {
                services = (ConnectorServices)unmarshaller.unmarshal(IOUtils.toInputStream((String)result, (Charset)StandardCharsets.UTF_8));
            }
            catch (Throwable t) {
                throw new ConnectorException("Das Service-Directory kann nicht ausgelesen werden. Ist die Firmware des Konnektors aktuell?", ConnectorException.ExceptionType.DISCOVERY_ERROR);
            }
            boolean mandatoryTls = services.isTLSMandatory();
            if (!tiConnectorConfiguration.useTLS() && mandatoryTls) {
                throw new ConnectorException("Der Konnektor kann nur per TLS angesteuert werden. Bitte geben Sie eine HTTPS URL ein!", ConnectorException.ExceptionType.CONFIGURATION_ERROR);
            }
            return new TiEndpoints(services.getServiceInformation().getService());
        }
        catch (ConnectorException t) {
            throw t;
        }
        catch (Throwable t2) {
            throw new ConnectorException(t2.toString(), ConnectorException.ExceptionType.UNKNOWN, t2);
        }
    }

    @NotNull
    private ConnectorException makeConnectorEmptyResponseException(@NotNull String contextMsg, @NotNull HttpResponse response) {
        return new ConnectorException(contextMsg + "Der Konnektor liefert Status " + response.getCode() + "aber keine weiteren Informationen!", ConnectorException.ExceptionType.UNKNOWN);
    }

    @NotNull
    private ConnectorException convertToConnectorException(@NotNull String contextMsg, @Nullable String result, @NotNull Throwable t) {
        if (t instanceof ConnectorException) {
            ConnectorException ce = (ConnectorException)t;
            throw new ConnectorException(ce.getMessage(), ce.getType(), ce.getCause());
        }
        if (result != null) {
            throw new ConnectorException(contextMsg + " Der Konnektor meldet: " + result, ConnectorException.ExceptionType.UNKNOWN, t);
        }
        throw new ConnectorException(contextMsg, ConnectorException.ExceptionType.UNKNOWN, t);
    }

    @Override
    public void setupRoutes(@NotNull TIConnectorConfiguration connectorConfiguration) {
        String tiConnectorIp = connectorConfiguration.getUri().getHost();
        try {
            this.routeManager.removeRoute("100.102.0.0");
            this.routeManager.removeRoute("100.103.0.0");
            this.routeManager.removeRoute("100.102.128.0");
            this.routeManager.addRoute("100.102.0.0", tiConnectorIp, "255.255.128.0");
            this.routeManager.addRoute("100.103.0.0", tiConnectorIp, "255.255.0.0");
            this.routeManager.addRoute("100.102.128.0", tiConnectorIp, "255.255.128.0");
        }
        catch (ConnectorException fe) {
            throw fe;
        }
        catch (Throwable t) {
            throw new ConnectorException(t.toString(), ConnectorException.ExceptionType.UNKNOWN, t);
        }
    }

    static enum DocumentType {
        PDF("http://uri.etsi.org/02778/3", "application/pdf-a"),
        TEXT_PLAIN("urn:ietf:rfc:5652", "text/plain; charset=utf-8");

        @NotNull
        private final String signatureType;
        @NotNull
        private final String mimeType;

        private DocumentType(String signatureType, String mimeType) {
            this.signatureType = signatureType;
            this.mimeType = mimeType;
        }

        @NotNull
        public String getSignatureType() {
            return this.signatureType;
        }

        @NotNull
        public String getMimeType() {
            return this.mimeType;
        }
    }
}

