/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector;

import de.impfsoft.ticonnector.TIConnectorContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.KeyStore;
import java.util.Optional;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;

public interface TIConnectorConfiguration {
    @NotNull
    public URI getUri();

    default public boolean useTLS() {
        try {
            return this.getUri().toURL().getProtocol().equalsIgnoreCase("https");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @NotNull
    public Optional<String> getCardIccsn();

    @NotNull
    public TIConnectorContext getContext();

    @NotNull
    public Optional<UsernamePasswordCredentials> getCredentials();

    @NotNull
    public Optional<ClientCertificate> getClientCertificate();

    @NotNull
    public KeyStore getTrustedCertificates();

    public static class ClientCertificate {
        private final KeyStore clientCertificate;
        private final char[] privateKeyPassword;

        public ClientCertificate(KeyStore clientCertificate, char[] privateKeyPassword) {
            this.clientCertificate = clientCertificate;
            this.privateKeyPassword = privateKeyPassword;
        }

        @NotNull
        public KeyStore getClientCertificate() {
            return this.clientCertificate;
        }

        @NotNull
        public char[] getPrivateKeyPassword() {
            return this.privateKeyPassword;
        }
    }
}

