/*
 * Decompiled with CFR 0.152.
 */
package de.impfsoft.ticonnector;

import de.impfsoft.ticonnector.model.Fault;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectorException
extends RuntimeException {
    @NotNull
    private final ExceptionType type;
    @Nullable
    private final Fault fault;

    public ConnectorException(@NotNull String message, @NotNull ExceptionType type) {
        this(message, type, (Throwable)null);
    }

    public ConnectorException(@NotNull String message, @NotNull ExceptionType type, @Nullable Throwable t) {
        super(message, t);
        this.type = type;
        this.fault = null;
    }

    public ConnectorException(@NotNull String message, @NotNull ExceptionType type, @Nullable Fault t) {
        super(message);
        this.type = type;
        this.fault = t;
    }

    @NotNull
    public ExceptionType getType() {
        return this.type;
    }

    @NotNull
    public Optional<Fault> getTiFault() {
        return Optional.ofNullable(this.fault);
    }

    public static enum ExceptionType {
        UNKNOWN,
        INTERNAL,
        NO_CARD,
        CONNECTOR_ERROR,
        CONFIGURATION_ERROR,
        DISCOVERY_ERROR,
        WRONG_VERSION,
        PIN_NEEDS_VERIFICATION,
        MAX_TRIES_EXCEEDED,
        ROUTE_SETUP_ERROR;

    }
}

