/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm.defaultreader;

import de.gzim.secupharm.CodeContent;
import de.gzim.secupharm.Constants;
import de.gzim.secupharm.defaultreader.CodeSegment;
import de.gzim.secupharm.defaultreader.ParsingResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultTreeNode {
    public static final int unbalancedGrowthThreshold = 3;
    @NotNull
    private final ParsingResult parsingResult;
    @Nullable
    private ResultTreeNode parent;
    @NotNull
    private List<ResultTreeNode> children;
    private boolean fullGrown = false;
    private boolean treeFullGrown = false;
    private int blockedSeparators = 0;
    private int depth = 0;
    @NotNull
    private List<ResultTreeNode> elementsIndex;
    private static final SproutComparator sproutComparator = new SproutComparator();

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public ResultTreeNode(@NotNull ParsingResult parsingResult) {
        this.parsingResult = parsingResult;
        this.children = new LinkedList<ResultTreeNode>();
        this.elementsIndex = new LinkedList<ResultTreeNode>();
        this.elementsIndex.add(this);
    }

    @NotNull
    public ParsingResult getParsingResult() {
        return this.parsingResult;
    }

    @NotNull
    public Optional<ResultTreeNode> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @NotNull
    public List<ResultTreeNode> getChildren() {
        return this.children;
    }

    public void setParent(@Nullable ResultTreeNode parent) {
        this.parent = parent;
        if (parent != null) {
            this.depth = parent.getDepth() + 1;
        }
    }

    @NotNull
    public ResultTreeNode addChild(@NotNull ParsingResult child) {
        ResultTreeNode childNode = new ResultTreeNode(child);
        childNode.setParent(this);
        if (childNode.getBlockedSegment().map(s -> s.getIdentifier().equals((Object)Constants.SegmentIdentifier.Separator)).orElse(false).booleanValue()) {
            childNode.setBlockedSeparators(this.blockedSeparators + 1);
        } else {
            childNode.setBlockedSeparators(this.blockedSeparators);
        }
        this.children.add(childNode);
        this.registerChildForSearch(childNode);
        return childNode;
    }

    public int getLevel() {
        if (this.isRoot()) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }

    private void registerChildForSearch(@NotNull ResultTreeNode node) {
        this.elementsIndex.add(node);
        if (this.parent != null) {
            this.parent.registerChildForSearch(node);
        }
    }

    @NotNull
    public Optional<ResultTreeNode> findTreeNode(Comparable<ParsingResult> cmp) {
        for (ResultTreeNode element : this.elementsIndex) {
            ParsingResult elData = element.getParsingResult();
            if (cmp.compareTo(elData) != 0) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    @NotNull
    public Optional<CodeSegment> getBlockedSegment() {
        return this.getParsingResult().getBlockedSegment();
    }

    public List<CodeSegment> getBlockedSegments() {
        ArrayList<CodeSegment> blockedSegments = new ArrayList<CodeSegment>();
        ResultTreeNode parent = this;
        while (parent != null && !parent.isRoot()) {
            parent.getParsingResult().getBlockedSegment().ifPresent(segment -> blockedSegments.add(0, (CodeSegment)segment));
            parent = parent.getParent().orElse(null);
        }
        return blockedSegments;
    }

    public List<CodeSegment> getBlockedSegmentsOfChildren() {
        ArrayList<CodeSegment> blockedSegments = new ArrayList<CodeSegment>();
        for (ResultTreeNode childNode : this.getChildren()) {
            childNode.getBlockedSegment().ifPresent(blockedSegments::add);
        }
        return blockedSegments;
    }

    public float getParsedPercentage() {
        return this.getParsingResult().getParsedPercentage();
    }

    public List<CodeSegment> getParsedSegments() {
        return this.getParsingResult().getParsedSegments();
    }

    public List<CodeSegment> getParsedSegmentsWithData() {
        return this.getParsingResult().getParsedSegmentsWithData();
    }

    public CodeContent getContent() {
        return this.getParsingResult().getContent();
    }

    public boolean isBetterThanParent() {
        if (this.parent == null) {
            return true;
        }
        return this.getParsingResult().isBetterThan(this.parent.getParsingResult());
    }

    public float compareToParentResult() {
        return this.getParent().isPresent() ? this.getParsingResult().compareTo(this.getParent().get().getParsingResult()) : -1.0f;
    }

    public int compareTo(@NotNull ResultTreeNode comparedNode) {
        int directComparisonScore = Float.compare(this.getParsingResult().compareTo(comparedNode.getParsingResult()), 0.0f);
        float betterThanParentDiff = this.compareToParentResult() - comparedNode.compareToParentResult();
        int betterThanParentScore = Float.compare(betterThanParentDiff, 0.0f);
        float summedDepth = this.getDepth() + comparedNode.getDepth();
        int depthScore = 0;
        if (summedDepth != 0.0f) {
            float depthWeighting = 6.0f / summedDepth;
            float depthDiff = (float)(this.getDepth() - comparedNode.getDepth()) / summedDepth * depthWeighting;
            depthScore = Float.compare(depthDiff, 0.0f);
        }
        float summedBlockedSeparators = this.getBlockedSeparators() + comparedNode.getBlockedSeparators();
        int blockedSeparatorScore = 0;
        if (summedBlockedSeparators != 0.0f) {
            float separatorWeighting = 0.33333334f;
            float separatorDiff = (float)(this.getBlockedSeparators() - comparedNode.getBlockedSeparators()) / summedBlockedSeparators * separatorWeighting;
            blockedSeparatorScore = Float.compare(separatorDiff, 0.0f);
        }
        if (directComparisonScore != 0) {
            return directComparisonScore;
        }
        if (betterThanParentScore != 0) {
            return betterThanParentScore;
        }
        if (depthScore != 0) {
            return depthScore;
        }
        return blockedSeparatorScore;
    }

    public List<ResultTreeNode> getBestLeaves() {
        return this.elementsIndex.stream().filter(ResultTreeNode::isLeaf).sorted((node1, node2) -> Float.compare(node2.getParsedPercentage(), node1.getParsedPercentage())).collect(Collectors.toList());
    }

    public int getDepth() {
        return this.depth;
    }

    public List<ResultTreeNode> getNextSprouts() {
        List<ResultTreeNode> nextSprouts = this.elementsIndex.stream().filter(node -> !node.isNodeFullGrown()).sorted(sproutComparator).collect(Collectors.toList());
        if (nextSprouts.isEmpty()) {
            this.treeFullGrown = true;
        }
        return nextSprouts;
    }

    public boolean isNodeFullGrown() {
        this.fullGrown = this.fullGrown || this.getParsedSegmentsWithData().isEmpty() || this.getBlockedSegmentsOfChildren().containsAll(this.getParsedSegmentsWithData());
        return this.fullGrown;
    }

    public boolean isTreeFullGrown() {
        this.treeFullGrown = this.treeFullGrown || this.getNextSprouts().isEmpty();
        return this.treeFullGrown;
    }

    public void setFullGrown(boolean fullGrown) {
        this.fullGrown = fullGrown;
    }

    public void setTreeFullGrown(boolean treeFullGrown) {
        this.treeFullGrown = treeFullGrown;
    }

    public void setBlockedSeparators(int blockedSeparators) {
        this.blockedSeparators = blockedSeparators;
    }

    public int getBlockedSeparators() {
        return this.blockedSeparators;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    private static class SproutComparator
    implements Comparator<ResultTreeNode> {
        private SproutComparator() {
        }

        @Override
        public int compare(ResultTreeNode node1, ResultTreeNode node2) {
            float score = node1.compareTo(node2);
            if (score < 0.0f) {
                return -1;
            }
            if (score > 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

