/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm.defaultreader;

import de.gzim.secupharm.CodeContent;
import de.gzim.secupharm.Constants;
import de.gzim.secupharm.InformationType;
import de.gzim.secupharm.defaultreader.ChargeLengthStatistics;
import de.gzim.secupharm.defaultreader.CodeSegment;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParsingResult {
    @Nullable
    private final CodeSegment blockedSegment;
    @NotNull
    private final List<CodeSegment> parsedSegments;
    @NotNull
    private final CodeContent content;
    private final float parsedPercentage;
    private int numberOfData = 0;
    private int numberOfEssentialData = 0;
    private int reliability = 0;
    private double plausibility = 0.0;
    private boolean overlappingSegments = false;

    public ParsingResult(@Nullable CodeSegment blockedSegment, float parsedPercentage, @NotNull List<CodeSegment> parsedSegments, @NotNull CodeContent content) {
        this.blockedSegment = blockedSegment;
        this.parsedPercentage = parsedPercentage;
        this.parsedSegments = parsedSegments;
        this.content = new CodeContent(content);
        boolean pzn = false;
        boolean expirationDate = false;
        boolean charge = false;
        for (CodeSegment segment : parsedSegments) {
            if (segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Fin) || segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Separator)) continue;
            ++this.numberOfData;
            this.reliability += segment.getIdentifier().getMark().getReliability();
            if (segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Charge_AI) || segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Charge_DI)) {
                int chargeLength = segment.getContent().orElse("").length();
                this.plausibility = ChargeLengthStatistics.getProbabilityForLength(chargeLength);
            }
            if (!pzn && segment.getIdentifier().getMark().equals((Object)Constants.Mark.PPN) || segment.getIdentifier().getMark().equals((Object)Constants.Mark.ProductCode) || segment.getIdentifier().getMark().equals((Object)Constants.Mark.PZN)) {
                pzn = true;
                ++this.numberOfEssentialData;
            }
            if (!charge && segment.getIdentifier().getMark().equals((Object)Constants.Mark.Charge)) {
                charge = true;
                if (!Constants.isIncludeSpecialMarks()) {
                    ++this.numberOfEssentialData;
                }
            }
            if (!expirationDate && segment.getIdentifier().getMark().equals((Object)Constants.Mark.ExpirationDate)) {
                expirationDate = true;
                ++this.numberOfEssentialData;
            }
            for (CodeSegment segment2 : parsedSegments) {
                if (segment2.equals(segment) || !segment2.overlaps(segment)) continue;
                this.overlappingSegments = true;
            }
        }
    }

    @NotNull
    public Optional<CodeSegment> getBlockedSegment() {
        return Optional.ofNullable(this.blockedSegment);
    }

    public float getParsedPercentage() {
        return this.parsedPercentage;
    }

    public double getPlausibility() {
        return this.plausibility;
    }

    @NotNull
    public List<CodeSegment> getParsedSegments() {
        return this.parsedSegments;
    }

    public boolean hasOverlappingSegments() {
        return this.overlappingSegments;
    }

    @NotNull
    public List<CodeSegment> getParsedSegmentsWithData() {
        return this.parsedSegments.stream().filter(segment -> !segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Fin) && !segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Separator)).collect(Collectors.toList());
    }

    @NotNull
    public CodeContent getContent() {
        return this.content;
    }

    public int getNumberOfData() {
        return this.numberOfData;
    }

    public int getNumberOfEssentialData() {
        return this.numberOfEssentialData;
    }

    public boolean hasAllEssentialInformation() {
        return this.numberOfEssentialData >= 3;
    }

    public int getReliability() {
        return this.reliability;
    }

    public float compareTo(@NotNull ParsingResult comparedResult) {
        return this.compareTo(comparedResult, false);
    }

    public float compareTo(@NotNull ParsingResult comparedResult, boolean checkAmbiguities) {
        double summedPlausibility;
        float summedPercentages;
        int summedEssentialData;
        int summedData;
        float reliabilityFactor = 0.0f;
        float informationFactor = 0.0f;
        float completenessFactor = 0.0f;
        int summedReliability = this.reliability + comparedResult.getReliability();
        if (summedReliability > 0) {
            reliabilityFactor = (float)(comparedResult.getReliability() - this.reliability) / (float)summedReliability;
        }
        if ((summedData = this.numberOfData + comparedResult.getNumberOfData()) > 0) {
            informationFactor = (float)(comparedResult.getNumberOfData() - this.numberOfData) / (float)summedData;
        }
        if ((summedEssentialData = this.numberOfEssentialData + comparedResult.getNumberOfEssentialData()) > 0) {
            informationFactor += (float)(comparedResult.getNumberOfEssentialData() - this.numberOfEssentialData) / (float)summedEssentialData;
        }
        if ((summedPercentages = this.parsedPercentage + comparedResult.getParsedPercentage()) > 0.0f) {
            completenessFactor = (comparedResult.getParsedPercentage() - this.parsedPercentage) / summedPercentages;
        }
        float score = reliabilityFactor + completenessFactor + informationFactor;
        if (checkAmbiguities && (score == 0.0f || completenessFactor == 0.0f && (double)Math.abs(score) < 0.5)) {
            Arrays.stream(InformationType.values()).forEach(info -> this.checkAmbiguity((InformationType)((Object)info), comparedResult));
        }
        if (score == 0.0f && (summedPlausibility = this.plausibility + comparedResult.getPlausibility()) > 0.0) {
            return (float)((comparedResult.getPlausibility() - this.plausibility) / summedPlausibility);
        }
        return score;
    }

    private static boolean equalsForOptional(@NotNull Optional<?> o1, @NotNull Optional<?> o2) {
        if (!o1.isPresent() && !o2.isPresent()) {
            return true;
        }
        if (o1.isPresent() && !o2.isPresent()) {
            return false;
        }
        return o1.map(t -> t.equals(o2.get())).orElse(false);
    }

    public boolean isBetterThan(@NotNull ParsingResult comparedResult) {
        return this.compareTo(comparedResult) < 0.0f;
    }

    @NotNull
    public Optional<?> get(@NotNull InformationType info) {
        return this.content.get(info);
    }

    public void checkAmbiguity(@NotNull InformationType info, @NotNull ParsingResult that) {
        Optional<?> thatInfo;
        Optional<?> thisInfo = this.get(info);
        if (ParsingResult.equalsForOptional(thisInfo, thatInfo = that.get(info))) {
            return;
        }
        thisInfo.ifPresent(o -> that.addAmbiguity(info, o));
        thatInfo.ifPresent(o -> this.addAmbiguity(info, o));
    }

    public void addAmbiguity(@NotNull InformationType info, @Nullable Object alternative) {
        this.content.addAmbiguity(info, alternative);
    }
}

