/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm.defaultreader;

import de.gzim.secupharm.AbstractSecuPharmReader;
import de.gzim.secupharm.CodeContent;
import de.gzim.secupharm.Constants;
import de.gzim.secupharm.InformationType;
import de.gzim.secupharm.SecuPharmReadException;
import de.gzim.secupharm.defaultreader.ChargeLengthStatistics;
import de.gzim.secupharm.defaultreader.CodeSegment;
import de.gzim.secupharm.defaultreader.DefaultReaderConfig;
import de.gzim.secupharm.defaultreader.ParsingResult;
import de.gzim.secupharm.defaultreader.ResultTreeNode;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSecuPharmReader
extends AbstractSecuPharmReader {
    private final DefaultReaderConfig config = new DefaultReaderConfig();
    private ResultTreeNode resultTreeAi;
    private ResultTreeNode resultTreeDi;
    private int aiScore;
    private int diScore;
    private final List<CodeSegment> potentialAiSegments = new ArrayList<CodeSegment>();
    private final List<CodeSegment> potentialDiSegments = new ArrayList<CodeSegment>();
    private final Map<Constants.SegmentIdentifier, Integer> aiIdentifierOccurence = new HashMap<Constants.SegmentIdentifier, Integer>();
    private final Map<Constants.SegmentIdentifier, Integer> diIdentifierOccurence = new HashMap<Constants.SegmentIdentifier, Integer>();
    private CodeContent aiContent = null;
    private CodeContent diContent = null;
    private Set<Constants.Mark> preliminaryMarks = new HashSet<Constants.Mark>();
    private Set<Constants.Mark> foundMarks = new HashSet<Constants.Mark>();
    private List<CodeSegment> parsedSegments = new ArrayList<CodeSegment>();
    private List<CodeSegment> failedSegments = new ArrayList<CodeSegment>();
    private List<CodeSegment> blockedSegments = new ArrayList<CodeSegment>();
    private Constants.Mode mode = Constants.Mode.AI;

    public DefaultSecuPharmReader(@NotNull String code) throws SecuPharmReadException {
        super(code);
        this.findPotentialMarks();
        this.determineInitialMode();
        ResultTreeNode currentResult = null;
        ResultTreeNode bestResult = null;
        int minCycles = this.calcMinCycles();
        int maxCycles = this.calcMaxCycles();
        int cycle = 0;
        boolean isFirst = true;
        while (!(cycle >= maxCycles || cycle + 1 > minCycles && this.fulfillsSuccessCondition(bestResult))) {
            ++cycle;
            if (isFirst) {
                isFirst = false;
            } else {
                this.clearData();
                if (!currentResult.isBetterThanParent() || currentResult.isNodeFullGrown()) {
                    currentResult = this.chooseModeAndNextTreeSprout().orElse(null);
                }
                if (currentResult != null) {
                    while (!this.blockSegmentsForNextParsingAttempt(currentResult)) {
                        currentResult.setFullGrown(true);
                        currentResult = this.chooseModeAndNextTreeSprout().orElse(null);
                        if (currentResult != null) continue;
                    }
                    if (this.blockedSegments.stream().filter(s -> s.getIdentifier().equals((Object)Constants.SegmentIdentifier.Separator)).count() > 2L) break;
                }
                if (currentResult == null && this.getCurrentResultTree().isPresent()) break;
                this.readReliableSegments();
            }
            this.readAll();
            currentResult = currentResult == null ? (this.mode.equals((Object)Constants.Mode.AI) ? (this.resultTreeAi = new ResultTreeNode(new ParsingResult(this.blockedSegments.isEmpty() ? null : this.blockedSegments.get(this.blockedSegments.size() - 1), this.getParsedPercentage(), this.parsedSegments, new CodeContent(this.getContent())))) : (this.resultTreeDi = new ResultTreeNode(new ParsingResult(this.blockedSegments.isEmpty() ? null : this.blockedSegments.get(this.blockedSegments.size() - 1), this.getParsedPercentage(), this.parsedSegments, new CodeContent(this.getContent()))))) : currentResult.addChild(new ParsingResult(this.blockedSegments.isEmpty() ? null : this.blockedSegments.get(this.blockedSegments.size() - 1), this.getParsedPercentage(), this.parsedSegments, new CodeContent(this.getContent())));
            if (bestResult != null && !(bestResult.getParsingResult().compareTo(currentResult.getParsingResult(), true) > 0.0f) || currentResult.getParsingResult().hasOverlappingSegments()) continue;
            if (bestResult != null) {
                System.out.println(bestResult.getParsingResult().compareTo(currentResult.getParsingResult(), true) > 0.0f);
            }
            bestResult = currentResult;
        }
        float minAcceptedPercentage = this.config.getMinAcceptedPercentage();
        float f = bestResult.getParsedPercentage();
        int n = bestResult.getContent().get(InformationType.EXPIRATION_DATE).isPresent() ? 0 : 10;
        if (f < minAcceptedPercentage + (float)n) {
            throw new SecuPharmReadException(SecuPharmReadException.Type.INTERNAL, "Parsing insufficient. - Original code: " + this.getCode() + " - Parsed code: " + this.getParsedCode());
        }
        this.setContent(bestResult.getContent());
    }

    public boolean fulfillsSuccessCondition(@Nullable ResultTreeNode result) {
        float successPercentage = this.config.getSuccessPercentage();
        return result != null && result.getParsedPercentage() >= successPercentage && !result.getParsingResult().hasOverlappingSegments() && this.expirationDate != null && result.getParsingResult().getNumberOfData() >= 3 && result.getParsingResult().getPlausibility() >= 0.05;
    }

    private int calcMinCycles() {
        int ambiguitites = this.mode.equals((Object)Constants.Mode.AI) ? this.aiIdentifierOccurence.values().stream().filter(v -> v > 1).mapToInt(v -> v - 1).sum() : this.diIdentifierOccurence.values().stream().filter(v -> v > 1).mapToInt(v -> v - 1).sum();
        return ambiguitites + 1;
    }

    private int calcMaxCycles() {
        long totalElements;
        long maxCombinations = 1L;
        for (totalElements = (long)(this.potentialAiSegments.size() - 1); totalElements > 0L; --totalElements) {
            maxCombinations *= totalElements;
        }
        long maxCombinations2 = 1L;
        for (totalElements = (long)(this.potentialDiSegments.size() - 1); totalElements > 0L; --totalElements) {
            maxCombinations2 *= totalElements;
        }
        double logCombinations = Math.log10(maxCombinations += maxCombinations2) * 1.5;
        return (int)Math.min(200L + Math.round(logCombinations * logCombinations), Integer.MAX_VALUE);
    }

    private void readAll() {
        this.readSegments();
        this.findSpecialSeparators();
    }

    private void apply(@NotNull Constants.Mode mode, @NotNull ResultTreeNode result) {
        this.clearData();
        this.mode = mode;
        this.blockedSegments = result.getBlockedSegments();
        this.readReliableSegments();
        this.readAll();
    }

    @NotNull
    private Optional<ResultTreeNode> getCurrentResultTree() {
        if (this.mode.equals((Object)Constants.Mode.AI)) {
            return Optional.ofNullable(this.resultTreeAi);
        }
        return Optional.ofNullable(this.resultTreeDi);
    }

    @NotNull
    private Optional<ResultTreeNode> chooseModeAndNextTreeSprout() {
        ResultTreeNode nextSprout = null;
        if (!this.getCurrentResultTree().isPresent()) {
            return Optional.empty();
        }
        Iterator<ResultTreeNode> nextSprouts = this.getCurrentResultTree().get().getNextSprouts().iterator();
        if (nextSprouts.hasNext() && (nextSprout = nextSprouts.next()).isBetterThanParent()) {
            return Optional.of(nextSprout);
        }
        this.switchMode();
        if (!this.getCurrentResultTree().isPresent()) {
            return Optional.empty();
        }
        nextSprouts = this.getCurrentResultTree().get().getNextSprouts().iterator();
        if (nextSprouts.hasNext()) {
            nextSprout = nextSprouts.next();
            return Optional.of(nextSprout);
        }
        this.switchMode();
        return Optional.ofNullable(nextSprout);
    }

    private boolean blockSegmentsForNextParsingAttempt(@NotNull ResultTreeNode currentSprout) {
        List<CodeSegment> blockedSegmentsCurrentSprout = currentSprout.getBlockedSegments();
        List<CodeSegment> blockedSegmentsOtherChildren = currentSprout.getBlockedSegmentsOfChildren();
        List blockableSegments = currentSprout.getParsedSegments().stream().filter(segment -> !blockedSegmentsOtherChildren.contains(segment)).collect(Collectors.toList());
        Map<Constants.SegmentIdentifier, Integer> totalOccurence = this.mode.equals((Object)Constants.Mode.AI) ? this.aiIdentifierOccurence : this.diIdentifierOccurence;
        HashMap<Constants.SegmentIdentifier, Integer> remainingOccurence = new HashMap<Constants.SegmentIdentifier, Integer>(totalOccurence);
        for (CodeSegment segment2 : blockedSegmentsCurrentSprout) {
            Integer frequency = (Integer)remainingOccurence.get((Object)segment2.getIdentifier());
            if (frequency == null) continue;
            frequency = frequency - 1;
            remainingOccurence.put(segment2.getIdentifier(), frequency);
        }
        List ambiguousIdentifiers = remainingOccurence.entrySet().stream().filter(e -> !((Constants.SegmentIdentifier)((Object)((Object)e.getKey()))).equals((Object)Constants.SegmentIdentifier.Fin)).sorted((e1, e2) -> ((Constants.SegmentIdentifier)((Object)((Object)e1.getKey()))).equals((Object)Constants.SegmentIdentifier.Separator) ? 1 : (((Constants.SegmentIdentifier)((Object)((Object)e2.getKey()))).equals((Object)Constants.SegmentIdentifier.Separator) ? -1 : Integer.compare((Integer)e2.getValue(), (Integer)e1.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
        this.blockedSegments = blockedSegmentsCurrentSprout;
        for (Constants.SegmentIdentifier ambiguousIdentifier : ambiguousIdentifiers) {
            CodeSegment ambiguousSegment = blockableSegments.stream().filter(segment -> segment.getIdentifier().equals((Object)ambiguousIdentifier)).findAny().orElse(null);
            if (ambiguousSegment == null) continue;
            this.blockedSegments.add(ambiguousSegment);
            return true;
        }
        return false;
    }

    private void clearData() {
        this.clearContent();
        this.potentialAiSegments.forEach(segment -> segment.setContent(null));
        this.potentialDiSegments.forEach(segment -> segment.setContent(null));
        this.blockedSegments = new ArrayList<CodeSegment>();
        this.parsedSegments = new ArrayList<CodeSegment>();
        this.foundMarks = new HashSet<Constants.Mark>();
        this.preliminaryMarks.clear();
        this.failedSegments.clear();
    }

    private void findSpecialSeparators() {
        int count0029 = 0;
        String unparsedString = this.getRemainder();
        count0029 += StringUtils.countMatches((CharSequence)unparsedString, (CharSequence)"0029");
        if (this.charge != null && this.charge.endsWith("0029")) {
            count0029 += 2;
        }
        if (this.serialNumber != null && this.serialNumber.endsWith("0029")) {
            ++count0029;
        }
        for (CodeSegment parsedSegment : this.parsedSegments) {
            try {
                if (parsedSegment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Fin) || !this.getCode().substring(parsedSegment.getStartPos(), parsedSegment.getEndPos()).contains("0029")) continue;
                ++count0029;
            }
            catch (Throwable throwable) {}
        }
        if (count0029 > 1) {
            if (this.charge != null && this.charge.endsWith("0029")) {
                this.charge = this.charge.substring(0, this.charge.length() - 4);
            }
            if (this.serialNumber != null && this.serialNumber.endsWith("0029")) {
                this.serialNumber = this.serialNumber.substring(0, this.serialNumber.length() - 4);
            }
            for (CodeSegment parsedSegment : this.parsedSegments) {
                if (!parsedSegment.getIdentifier().getMark().equals((Object)Constants.Mark.SerialNumber) && !parsedSegment.getIdentifier().getMark().equals((Object)Constants.Mark.Charge) || !parsedSegment.getContent().isPresent() || !parsedSegment.getContent().get().endsWith("0029")) continue;
                parsedSegment.setContent(parsedSegment.getContent().get().substring(0, parsedSegment.getContent().get().length() - 4));
            }
            unparsedString = this.getRemainder();
            while (unparsedString.contains("0029")) {
                this.parsedSegments.add(new CodeSegment(unparsedString.indexOf("0029"), Constants.SegmentIdentifier.Separator, "0029"));
                unparsedString = unparsedString.replaceFirst("0029", "****");
            }
        }
    }

    private void findPotentialMarks() {
        int pos;
        String code = this.getCode();
        if (code.startsWith(Constants.SegmentIdentifier.CodeId.getEncoding().orElse("]"))) {
            this.codeId = code.substring(0, 3);
            pos = 3;
        } else {
            pos = 0;
        }
        while (pos <= code.length()) {
            Pair<Integer, CodeSegment> result = this.findNextPotentialMark(pos);
            pos = (Integer)result.getKey();
            CodeSegment segment = (CodeSegment)result.getValue();
            if (segment.getIdentifier().getMode().isPresent()) {
                if (segment.getIdentifier().getMode().get().equals((Object)Constants.Mode.AI)) {
                    this.potentialAiSegments.add(segment);
                } else if (segment.getIdentifier().getMode().get().equals((Object)Constants.Mode.DI)) {
                    this.potentialDiSegments.add(segment);
                }
            } else {
                this.potentialAiSegments.add(segment);
                this.potentialDiSegments.add(segment);
            }
            if (!segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Fin)) continue;
            break;
        }
        for (CodeSegment segment : this.potentialAiSegments) {
            if (this.aiIdentifierOccurence.computeIfPresent(segment.getIdentifier(), (k, v) -> v + 1) != null) continue;
            this.aiIdentifierOccurence.put(segment.getIdentifier(), 1);
        }
        for (CodeSegment segment : this.potentialDiSegments) {
            if (this.diIdentifierOccurence.computeIfPresent(segment.getIdentifier(), (k, v) -> v + 1) != null) continue;
            this.diIdentifierOccurence.put(segment.getIdentifier(), 1);
        }
    }

    @NotNull
    private Pair<Integer, CodeSegment> findNextPotentialMark(int pos) {
        String code = this.getCode();
        Constants.SegmentIdentifier identifier = Constants.SegmentIdentifier.Unknown;
        --pos;
        while (identifier.equals((Object)Constants.SegmentIdentifier.Unknown)) {
            if (++pos >= code.length()) {
                CodeSegment segment = new CodeSegment(pos, Constants.SegmentIdentifier.Fin);
                this.parsedSegments.add(segment);
                return Pair.of((Object)pos, (Object)segment);
            }
            String mark1 = code.substring(pos, pos + 1);
            if (!StringUtils.isAlphanumeric((CharSequence)mark1) || mark1.equals(" ")) {
                try {
                    CodeSegment segment = new CodeSegment(pos, Constants.SegmentIdentifier.Separator);
                    this.readSeparator(segment);
                    this.parsedSegments.add(segment);
                    return Pair.of((Object)(pos += segment.getLength()), (Object)segment);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((identifier = Constants.SegmentIdentifier.str2Identifier(mark1)).equals((Object)Constants.SegmentIdentifier.Unknown)) {
                String mark2 = code.substring(pos, Math.min(code.length(), pos + 2));
                identifier = Constants.SegmentIdentifier.str2Identifier(mark2);
            }
            if (!identifier.equals((Object)Constants.SegmentIdentifier.Unknown)) continue;
            String mark3 = code.substring(pos, Math.min(code.length(), pos + 3));
            identifier = Constants.SegmentIdentifier.str2Identifier(mark3);
        }
        CodeSegment segment = new CodeSegment(pos, identifier);
        return Pair.of((Object)(++pos), (Object)segment);
    }

    private void determineInitialMode() {
        this.aiScore = this.potentialAiSegments.stream().mapToInt(s -> s.getIdentifier().getEncoding().isPresent() ? s.getIdentifier().getEncoding().get().length() : 0).sum();
        this.diScore = this.potentialDiSegments.stream().mapToInt(s -> s.getIdentifier().getEncoding().isPresent() ? s.getIdentifier().getEncoding().get().length() : 0).sum();
        this.switchModeAndReadReliableSegments(this.aiScore >= this.diScore);
        if (this.reliableSegmentsParsedSuccessfully()) {
            return;
        }
        this.switchModeAndReadReliableSegments(this.mode == Constants.Mode.DI);
        if (this.reliableSegmentsParsedSuccessfully()) {
            return;
        }
        if (this.aiScore >= this.diScore) {
            this.mode = Constants.Mode.AI;
            this.setContent(this.aiContent);
        } else {
            this.mode = Constants.Mode.DI;
            this.setContent(this.diContent);
        }
    }

    private void switchModeAndReadReliableSegments(boolean newModeIsAi) {
        if (newModeIsAi) {
            this.mode = Constants.Mode.AI;
            this.aiScore = this.readDateAndCode(this.potentialAiSegments, this.aiScore);
        } else {
            this.mode = Constants.Mode.DI;
            this.diScore = this.readDateAndCode(this.potentialDiSegments, this.diScore);
        }
    }

    private void switchMode() {
        this.mode = this.mode.equals((Object)Constants.Mode.AI) ? Constants.Mode.DI : Constants.Mode.AI;
    }

    private void readReliableSegments() {
        if (this.mode.equals((Object)Constants.Mode.AI)) {
            this.readDateAndCode(this.potentialAiSegments, 0);
        } else {
            this.readDateAndCode(this.potentialDiSegments, 0);
        }
    }

    private int readDateAndCode(@NotNull List<CodeSegment> segments, int score) {
        for (CodeSegment segment : segments) {
            if (!segment.getIdentifier().getMark().equals((Object)Constants.Mark.PPN) && !segment.getIdentifier().getMark().equals((Object)Constants.Mark.ProductCode) && !segment.getIdentifier().getMark().equals((Object)Constants.Mark.ExpirationDate) || this.failedSegments.contains(segment) || this.blockedSegments.contains(segment) || this.foundMarks.contains((Object)segment.getIdentifier().getMark()) && !segment.getIdentifier().getMark().equals((Object)Constants.Mark.ExpirationDate)) continue;
            this.preliminaryMarks.clear();
            if (!this.readSegment(segment)) continue;
            score += segment.getLength();
        }
        return score;
    }

    private boolean reliableSegmentsParsedSuccessfully() {
        if ((this.productCode != null || this.ppn != null || this.pzn != null) && this.expirationDate != null) {
            return true;
        }
        if (this.mode == Constants.Mode.AI) {
            this.aiContent = new CodeContent();
            this.aiContent.setContent(this.getContent());
        } else {
            this.diContent = new CodeContent();
            this.diContent.setContent(this.getContent());
        }
        this.setContent(null);
        return false;
    }

    private void readSegments() {
        CodeSegment currentSegment = null;
        while ((currentSegment = (CodeSegment)this.getNextPotentialSegment(currentSegment, null).orElse(null)) != null) {
            if (this.parsedSegments.contains(currentSegment)) continue;
            this.preliminaryMarks.clear();
            this.readSegment(currentSegment);
        }
    }

    private boolean readSegment(@NotNull CodeSegment segment) {
        try {
            this.readContent(segment);
            this.parsedSegments.add(segment);
            if (!segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Separator)) {
                this.foundMarks.add(segment.getIdentifier().getMark());
            }
        }
        catch (Throwable t) {
            this.failedSegments.add(segment);
            return false;
        }
        return true;
    }

    private boolean overlapsParsedSegment(@NotNull CodeSegment segment) {
        for (CodeSegment parsedSegment : this.parsedSegments) {
            if (!parsedSegment.overlaps(segment)) continue;
            return true;
        }
        return false;
    }

    private void readContent(@NotNull CodeSegment segment) throws SecuPharmReadException {
        switch (segment.getIdentifier().getMark()) {
            case PPN: {
                this.ppn = this.readPpn(segment);
                break;
            }
            case SerialNumber: {
                this.serialNumber = this.readUnformattedTextWithMaxLength(segment, 20, 3);
                break;
            }
            case Charge: {
                this.charge = this.readUnformattedTextWithMaxLength(segment, 20, 2);
                break;
            }
            case ProductCode: {
                this.productCode = this.readProductCode(segment);
                break;
            }
            case ExpirationDate: {
                this.expirationDate = this.readExpirationDate(segment);
                break;
            }
            case BestBeforeDate: {
                this.bestBeforeDate = this.readDate(segment);
                break;
            }
            case ProductionDate: {
                this.productionDate = this.readDate(segment);
                break;
            }
            case PZN: {
                this.pzn = this.readPzn(segment);
                break;
            }
            case AdditionalId: {
                this.additionalId = this.readUnformattedTextWithMaxLength(segment, 30, 2);
                break;
            }
            case Separator: {
                this.readSeparator(segment);
            }
        }
    }

    private void readSeparator(@NotNull CodeSegment segment) throws SecuPharmReadException {
        int startPos = segment.getStartPos();
        String currentChar = this.getCode().substring(startPos, startPos + 1);
        if (StringUtils.isAlphanumeric((CharSequence)currentChar)) {
            throw new SecuPharmReadException(SecuPharmReadException.Type.DATA_IS_ABSENT, "Separator is expected to be non-alphanumeric.");
        }
        String separatorContent = "";
        int i = 1;
        do {
            separatorContent = separatorContent + currentChar;
        } while (!StringUtils.isAlphanumeric((CharSequence)(currentChar = this.getCode().substring(startPos + i, startPos + i + 1))) && startPos + ++i < this.getCode().length());
        segment.setContent(separatorContent);
    }

    private LocalDate readExpirationDate(@NotNull CodeSegment segment) throws SecuPharmReadException {
        LocalDate potentialExpirationDate = this.readDate(segment);
        if (this.expirationDate != null && (this.expirationDate.isBefore(LocalDate.now()) && potentialExpirationDate.isBefore(this.expirationDate) || this.expirationDate.isAfter(LocalDate.now()) && potentialExpirationDate.isAfter(this.expirationDate))) {
            throw new SecuPharmReadException(SecuPharmReadException.Type.CONFLICTING_INFORMATION, "Expiration date was already found");
        }
        this.parsedSegments.removeIf(codeSegment -> codeSegment.getIdentifier().getMark().equals((Object)Constants.Mark.ExpirationDate));
        return potentialExpirationDate;
    }

    @NotNull
    private String readPpn(@NotNull CodeSegment segment) throws SecuPharmReadException {
        String ppn = this.getCode().substring(segment.getContentPos(), segment.getContentPos() + 12);
        segment.setContent(ppn);
        return this.parsePpn(ppn);
    }

    @NotNull
    private String readCodeId(@NotNull CodeSegment segment) {
        this.codeId = this.getCode().substring(segment.getContentPos(), segment.getContentPos() + 2);
        segment.setContent(this.codeId);
        return this.codeId;
    }

    @NotNull
    private String readPzn(@NotNull CodeSegment segment) throws SecuPharmReadException {
        String pzn = this.getCode().substring(segment.getContentPos(), segment.getContentPos() + 8);
        segment.setContent(pzn);
        return this.parsePzn(pzn);
    }

    @NotNull
    private String readUnformattedTextWithMaxLength(@NotNull CodeSegment segment, int maxLength, int minLength) throws SecuPharmReadException {
        int startPos = segment.getContentPos();
        int endPos = this.findEndPos(segment, maxLength, minLength);
        String sn = this.getCode().substring(startPos, endPos);
        segment.setContent(sn);
        if (this.overlapsParsedSegment(segment)) {
            throw new SecuPharmReadException(SecuPharmReadException.Type.INTERNAL, "Overlaps parsed segment.");
        }
        return sn;
    }

    @NotNull
    private LocalDate readDate(@NotNull CodeSegment segment) {
        String dateString = this.getCode().substring(segment.getContentPos(), segment.getContentPos() + 6);
        segment.setContent(dateString);
        int year = Integer.parseInt(dateString.substring(0, 2)) + 2000;
        int month = Integer.parseInt(dateString.substring(2, 4));
        if (!dateString.startsWith("00", 4)) {
            int day = Integer.parseInt(dateString.substring(4, 6));
            return LocalDate.of(year, month, day);
        }
        return LocalDate.of(year, month, 1).with(TemporalAdjusters.lastDayOfMonth());
    }

    @NotNull
    private String readProductCode(@NotNull CodeSegment segment) throws SecuPharmReadException {
        String ntin = this.getCode().substring(segment.getContentPos(), segment.getContentPos() + 14);
        segment.setContent(ntin);
        return this.parseNtin(ntin);
    }

    private int findEndPos(@NotNull CodeSegment segment, int maxLength, int minLength) throws SecuPharmReadException {
        CodeSegment nextSegment;
        this.preliminaryMarks.add(segment.getIdentifier().getMark());
        int startPos = segment.getContentPos();
        int minStartPosForNextSegment = startPos + minLength;
        int endpos = startPos;
        while ((nextSegment = (CodeSegment)this.getNextPotentialSegment(segment, minStartPosForNextSegment).orElse(null)) != null) {
            minStartPosForNextSegment = nextSegment.getStartPos() + 1;
            if (nextSegment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Unknown)) continue;
            endpos = nextSegment.getStartPos();
            if (endpos - startPos > maxLength) {
                this.preliminaryMarks.remove((Object)segment.getIdentifier().getMark());
                throw new SecuPharmReadException(SecuPharmReadException.Type.INTERNAL, "End position not found.");
            }
            if (!nextSegment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Fin) && (endpos - startPos <= 1 || !this.parsedSegments.contains(nextSegment) && !this.readSegment(nextSegment))) continue;
        }
        if (endpos <= startPos) {
            this.preliminaryMarks.remove((Object)segment.getIdentifier().getMark());
            throw new SecuPharmReadException(SecuPharmReadException.Type.DATA_IS_ABSENT, "No content found for marker.");
        }
        if (endpos - startPos > maxLength) {
            this.preliminaryMarks.remove((Object)segment.getIdentifier().getMark());
            throw new SecuPharmReadException(SecuPharmReadException.Type.INTERNAL, "End position not found.");
        }
        return endpos;
    }

    @NotNull
    private Optional<CodeSegment> getNextPotentialSegment(@Nullable CodeSegment currentSegment, @Nullable Integer minStartPos) {
        boolean sortByReliability = minStartPos == null;
        boolean sortByChargeLengthPlausibility = currentSegment != null && currentSegment.getIdentifier().getMark().equals((Object)Constants.Mark.Charge);
        List<CodeSegment> potentialSegments = this.mode.equals((Object)Constants.Mode.AI) ? new ArrayList<CodeSegment>(this.potentialAiSegments) : new ArrayList<CodeSegment>(this.potentialDiSegments);
        if (sortByReliability) {
            potentialSegments = potentialSegments.stream().sorted((s1, s2) -> {
                int result = Integer.compare(s2.getIdentifier().getMark().getReliability(), s1.getIdentifier().getMark().getReliability());
                if (result != 0) {
                    return result;
                }
                return Integer.compare(s1.getStartPos(), s2.getStartPos());
            }).collect(Collectors.toList());
        } else if (sortByChargeLengthPlausibility) {
            potentialSegments = potentialSegments.stream().sorted((s1, s2) -> {
                int startPos = currentSegment.getContentPos();
                int length1 = s1.getStartPos() - startPos;
                int length2 = s2.getStartPos() - startPos;
                double prob1 = ChargeLengthStatistics.getProbabilityForLength(length1);
                double prob2 = ChargeLengthStatistics.getProbabilityForLength(length2);
                int result = Double.compare(prob2, prob1);
                if (result != 0) {
                    return result;
                }
                return Integer.compare(s1.getStartPos(), s2.getStartPos());
            }).collect(Collectors.toList());
        }
        for (CodeSegment potentialSegment : potentialSegments) {
            if (sortByReliability && potentialSegments.indexOf(potentialSegment) <= potentialSegments.indexOf(currentSegment) || !this.isNextPotentialSegment(potentialSegment, currentSegment, minStartPos)) continue;
            return Optional.of(potentialSegment);
        }
        return Optional.empty();
    }

    private boolean isNextPotentialSegment(@NotNull CodeSegment segment, @Nullable CodeSegment currentSegment, @Nullable Integer minStartPos) {
        boolean sortByReliability;
        boolean bl = sortByReliability = minStartPos == null;
        if (!this.isPotentialSegment(segment)) {
            return false;
        }
        if (!sortByReliability && segment.getStartPos() < minStartPos) {
            return false;
        }
        return currentSegment == null || sortByReliability || !segment.getIdentifier().equals((Object)currentSegment.getIdentifier()) && segment.getStartPos() > currentSegment.getEndPos() && !this.preliminaryMarks.contains((Object)segment.getIdentifier().getMark());
    }

    private boolean isPotentialSegment(@NotNull CodeSegment segment) {
        if (segment.getIdentifier().getMode().isPresent() && !segment.getIdentifier().getMode().get().equals((Object)this.mode)) {
            return false;
        }
        if (this.blockedSegments.contains(segment)) {
            return false;
        }
        if (this.failedSegments.contains(segment)) {
            return false;
        }
        return this.parsedSegments.contains(segment) || !this.foundMarks.contains((Object)segment.getIdentifier().getMark()) && !this.overlapsParsedSegment(segment);
    }

    private int getParsedInformationLength() {
        int startIndex = this.getInformationStartIndex().orElse(0);
        return this.parsedSegments.stream().filter(segment -> segment.getStartPos() >= startIndex).mapToInt(CodeSegment::getLength).sum();
    }

    private String extractPrefix() {
        String prefix = "";
        Optional<Integer> startIndex = this.getInformationStartIndex();
        if (startIndex.isPresent()) {
            prefix = this.getCode().substring(0, startIndex.get());
        }
        return prefix;
    }

    private Optional<Integer> getInformationStartIndex() {
        return this.parsedSegments.stream().filter(s -> !s.getIdentifier().equals((Object)Constants.SegmentIdentifier.Separator)).min(Comparator.comparingInt(CodeSegment::getStartPos)).map(CodeSegment::getStartPos);
    }

    private int countAlphanumericChars(@NotNull String string) {
        String nonAlphanumericPart = string.replaceAll("[a-zA-Z0-9]*", "");
        return string.length() - nonAlphanumericPart.length();
    }

    private float getParsedPercentage() {
        String prefix = this.extractPrefix();
        int alphanumericPrefixChars = this.countAlphanumericChars(prefix);
        int informationLength = this.getCode().length() - prefix.length();
        float parsedPercentage = 0.0f;
        if (informationLength > 0) {
            parsedPercentage = 100.0f * (alphanumericPrefixChars > 7 ? (float)this.getParsedInformationLength() / (float)(informationLength + alphanumericPrefixChars) : (float)this.getParsedInformationLength() / (float)informationLength);
        }
        return parsedPercentage;
    }

    private String getParsedCode() {
        String parsedCode = "";
        int endpos = -1;
        for (CodeSegment segment : this.sortByPosition(this.parsedSegments)) {
            while (segment.getStartPos() > endpos + 1) {
                parsedCode = parsedCode + "*";
                ++endpos;
            }
            parsedCode = parsedCode + segment.asString();
            endpos = segment.getEndPos();
        }
        return parsedCode;
    }

    private String getRemainder() {
        String remainder = this.getCode();
        for (CodeSegment segment : this.sortByPosition(this.parsedSegments)) {
            if (segment.getIdentifier().equals((Object)Constants.SegmentIdentifier.Fin)) break;
            try {
                remainder = remainder.substring(0, segment.getStartPos()) + StringUtils.repeat((String)"*", (int)segment.getLength()) + remainder.substring(segment.getEndPos() + 1);
            }
            catch (Throwable throwable) {}
        }
        return remainder;
    }

    private List<CodeSegment> sortByPosition(@NotNull List<CodeSegment> segments) {
        return segments.stream().sorted(Comparator.comparingInt(CodeSegment::getStartPos)).collect(Collectors.toList());
    }
}

