/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm.defaultreader;

import de.gzim.secupharm.Constants;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeSegment {
    final int startPos;
    @NotNull
    private final Constants.SegmentIdentifier identifier;
    @Nullable
    private String content;

    public CodeSegment(int startPos, @NotNull Constants.SegmentIdentifier identifier) {
        this(startPos, identifier, null);
    }

    public CodeSegment(int startPos, @NotNull Constants.SegmentIdentifier identifier, @Nullable String content) {
        this.startPos = startPos;
        this.identifier = identifier;
        this.content = content;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getContentPos() {
        return this.startPos + (this.identifier.getEncoding().isPresent() ? this.identifier.getEncoding().get().length() : 0);
    }

    @NotNull
    public Constants.SegmentIdentifier getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public Optional<String> getContent() {
        return Optional.ofNullable(this.content);
    }

    public void setContent(@Nullable String content) {
        this.content = content;
    }

    public int getLength() {
        if (this.identifier.equals((Object)Constants.SegmentIdentifier.Fin)) {
            return 0;
        }
        int length = (this.identifier.getEncoding().isPresent() ? this.identifier.getEncoding().get().length() : 0) + (this.content == null ? 0 : this.content.length());
        if (length > 0) {
            return length;
        }
        return 1;
    }

    public int getEndPos() {
        int length = this.getLength();
        return this.startPos + (length > 0 ? this.getLength() - 1 : 0);
    }

    @NotNull
    public String asString() {
        return this.identifier.getEncoding().orElse("") + (this.content == null ? "" : this.content);
    }

    public boolean overlaps(@NotNull CodeSegment segment) {
        return segment.getStartPos() <= this.getEndPos() && segment.getStartPos() >= this.getStartPos() || this.getStartPos() <= segment.getEndPos() && this.getStartPos() >= segment.getStartPos();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodeSegment)) {
            return false;
        }
        CodeSegment that = (CodeSegment)obj;
        return that.getStartPos() == this.startPos && that.getIdentifier().equals((Object)this.identifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startPos, this.identifier});
    }
}

