/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm;

import java.time.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecuPharmWriter {
    @NotNull
    public static String generateCode(@NotNull String charge, @Nullable String pzn, @Nullable String sn, @NotNull LocalDate date) {
        String expirationDateString = String.format("%02d%02d%02d", date.getYear() - 2000, date.getMonthValue(), date.getDayOfMonth());
        if (sn == null) {
            if (pzn == null) {
                return String.format("17%s 10%s", expirationDateString, charge);
            }
            int v = SecuPharmWriter.generateCheckSum(pzn);
            return String.format("01000000%s%d 17%s 10%s", pzn, v, expirationDateString, charge);
        }
        if (pzn == null) {
            return String.format("21%s 17%s 10%s", sn, expirationDateString, charge);
        }
        int v = SecuPharmWriter.generateCheckSum(pzn);
        return String.format("01000000%s%d 21%s 17%s 10%s", pzn, v, sn, expirationDateString, charge);
    }

    private static int generateCheckSum(@NotNull String pzn) {
        int v = 0;
        int k = 0;
        for (int i = 0; i < pzn.length() - 1; ++i) {
            v += ++k * (pzn.charAt(i) - 48);
        }
        return v %= 11;
    }
}

