/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm;

import de.gzim.secupharm.AbstractSecuPharmReader;
import de.gzim.secupharm.Ambiguity;
import de.gzim.secupharm.BlockBasedSecuPharmReader;
import de.gzim.secupharm.CodeContent;
import de.gzim.secupharm.Constants;
import de.gzim.secupharm.SecuPharmCode;
import de.gzim.secupharm.SecuPharmReadException;
import de.gzim.secupharm.defaultreader.DefaultSecuPharmReader;
import java.time.LocalDate;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class SecuPharmReader {
    public static String READER_IMPLEMENTATION_PROPERTY = "impfdoc.secupharm.reader";

    @NotNull
    public static SecuPharmCode getSecuPharmaCode(@NotNull String code) throws SecuPharmReadException {
        AbstractSecuPharmReader reader;
        code = code.toUpperCase();
        String implementation = System.getProperty(READER_IMPLEMENTATION_PROPERTY);
        Constants.setIncludeSpecialMarks(false);
        if (implementation != null) {
            try {
                reader = (AbstractSecuPharmReader)SecuPharmReader.class.getClassLoader().loadClass(implementation).getConstructor(String.class).newInstance(code);
            }
            catch (Throwable e) {
                Constants.setIncludeSpecialMarks(true);
                try {
                    reader = (AbstractSecuPharmReader)SecuPharmReader.class.getClassLoader().loadClass(implementation).getConstructor(String.class).newInstance(code);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        } else if (StringUtils.isAlphanumeric((CharSequence)code.substring(6))) {
            reader = SecuPharmReader.getDefaultReader(code);
        } else {
            try {
                reader = new BlockBasedSecuPharmReader(code);
            }
            catch (Throwable t) {
                reader = SecuPharmReader.getDefaultReader(code);
            }
        }
        final CodeContent content = reader.getContent();
        return new SecuPharmCode(){

            @Override
            @NotNull
            public Optional<String> getPZN() {
                return content.getPzn();
            }

            @Override
            @NotNull
            public Optional<String> getProductCode() {
                return content.getProductCode();
            }

            @Override
            @NotNull
            public Optional<String> getCodeId() {
                return content.getCodeId();
            }

            @Override
            @NotNull
            public Optional<String> getCharge() {
                return content.getCharge();
            }

            @Override
            @NotNull
            public LocalDate getExpirationDate() throws SecuPharmReadException {
                return content.getExpirationDate().orElseThrow(() -> new SecuPharmReadException(SecuPharmReadException.Type.DATA_IS_ABSENT, "Kein Verfallsdatum im Code enthalten"));
            }

            @Override
            @NotNull
            public Optional<LocalDate> getProductionDate() {
                return content.getProductionDate();
            }

            @Override
            @NotNull
            public Optional<LocalDate> getBestBeforeDate() {
                return content.getBestBeforeDate();
            }

            @Override
            @NotNull
            public Optional<String> getSerialNumber() {
                return content.getSerialNumber();
            }

            @Override
            @NotNull
            public Optional<String> getAdditionalId() {
                return content.getAdditionalId();
            }

            @Override
            @NotNull
            public Set<Ambiguity<?>> getAmbiguities() {
                return content.getAmbiguities();
            }

            public String toString() {
                String expirationDate;
                try {
                    expirationDate = this.getExpirationDate().toString();
                }
                catch (SecuPharmReadException ex) {
                    expirationDate = "-";
                }
                return String.format("Product-Code:%s, PZN:%s, Charge:%s, Expiration-Date:%s, SN:%s", this.getProductCode().orElse("-"), this.getPZN().orElse("-"), this.getCharge().orElse("-"), expirationDate, this.getSerialNumber().orElse("-"));
            }
        };
    }

    @NotNull
    public static AbstractSecuPharmReader getDefaultReader(@NotNull String code) throws SecuPharmReadException {
        DefaultSecuPharmReader reader;
        try {
            reader = new DefaultSecuPharmReader(code);
        }
        catch (Throwable t) {
            Constants.setIncludeSpecialMarks(true);
            reader = new DefaultSecuPharmReader(code);
        }
        return reader;
    }

    public static void main(String[] args) throws SecuPharmReadException {
        SecuPharmCode code = SecuPharmReader.getSecuPharmaCode(args[0]);
        System.out.println(code);
    }
}

