/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Constants {
    private static boolean includeSpecialMarks = false;

    public static void setIncludeSpecialMarks(boolean value) {
        includeSpecialMarks = value;
    }

    public static boolean isIncludeSpecialMarks() {
        return includeSpecialMarks;
    }

    public static enum SegmentIdentifier {
        ProductCode_DI(Mark.ProductCode, Mode.DI, "8P", false),
        ProductCode_AI(Mark.ProductCode, Mode.AI, "01", false),
        ExpirationDate_DI(Mark.ExpirationDate, Mode.DI, "D", false),
        ExpirationDate_AI(Mark.ExpirationDate, Mode.AI, "17", false),
        Charge_DI(Mark.Charge, Mode.DI, "1T", false),
        Charge_AI(Mark.Charge, Mode.AI, "10", false),
        SerialNumber_DI(Mark.SerialNumber, Mode.DI, "S", false),
        SerialNumber_AI(Mark.SerialNumber, Mode.AI, "21", false),
        PPN_DI(Mark.PPN, Mode.DI, "9N", false),
        PZN(Mark.PZN, null, "710", false),
        Unknown(Mark.Unknown, null, null, false),
        Separator(Mark.Separator, null, null, false),
        Fin(Mark.Fin, null, null, false),
        ProductionDate_AI(Mark.ProductionDate, Mode.AI, "11", false),
        BestBeforeDate_AI(Mark.BestBeforeDate, Mode.AI, "15", false),
        CodeId(Mark.CodeId, null, "]", false),
        VariableCount_AI(Mark.Unknown, Mode.AI, "30", true),
        AdditionalId(Mark.AdditionalId, Mode.AI, "240", true);

        @Nullable
        private final String encoding;
        @NotNull
        private final Mark mark;
        @Nullable
        private final Mode mode;
        @NotNull
        private final boolean special;

        private SegmentIdentifier(@Nullable Mark mark, Mode mode, String encoding, boolean special) {
            this.mark = mark;
            this.mode = mode;
            this.encoding = encoding;
            this.special = special;
        }

        @NotNull
        public Optional<String> getEncoding() {
            return Optional.ofNullable(this.encoding);
        }

        @NotNull
        public Mark getMark() {
            return this.mark;
        }

        @NotNull
        public Optional<Mode> getMode() {
            return Optional.ofNullable(this.mode);
        }

        public boolean isSpecial() {
            return this.special;
        }

        public boolean equals(@NotNull String encoding) {
            return encoding.equals(this.encoding);
        }

        public static SegmentIdentifier str2Identifier(@NotNull String encoding) {
            return SegmentIdentifier.str2Identifier(encoding, null);
        }

        public static SegmentIdentifier str2Identifier(@NotNull String encoding, @Nullable Mode mode) {
            for (SegmentIdentifier identifier : SegmentIdentifier.values()) {
                if (!includeSpecialMarks && identifier.isSpecial() || !identifier.equals(encoding) || mode != null && identifier.getMode().isPresent() && !mode.equals((Object)identifier.getMode().get())) continue;
                return identifier;
            }
            return Unknown;
        }
    }

    public static enum Mark {
        ExpirationDate(3),
        Charge(1),
        ProductCode(5),
        SerialNumber(1),
        PPN(5),
        PZN(4),
        Unknown(0),
        Separator(6),
        Fin(6),
        ProductionDate(2),
        BestBeforeDate(2),
        CodeId(2),
        AdditionalId(0);

        private final int reliability;

        private Mark(int reliability) {
            this.reliability = reliability;
        }

        public int getReliability() {
            return this.reliability;
        }
    }

    public static enum Mode {
        DI,
        AI;

    }

    public static enum ProductCodeType {
        NTIN,
        GTIN;

    }
}

