/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm;

import de.gzim.secupharm.Ambiguity;
import de.gzim.secupharm.Constants;
import de.gzim.secupharm.InformationType;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeContent {
    protected String ppn = null;
    protected String serialNumber = null;
    protected String charge = null;
    protected String productCode = null;
    protected String pzn = null;
    protected String codeId = null;
    protected String additionalId = null;
    protected LocalDate expirationDate = null;
    protected LocalDate productionDate = null;
    protected LocalDate bestBeforeDate = null;
    protected Constants.ProductCodeType productCodeType = null;
    private Set<Ambiguity<?>> ambiguities = new HashSet();

    public CodeContent() {
    }

    public CodeContent(@NotNull CodeContent content) {
        this();
        this.setContent(content);
    }

    public void setContent(@Nullable CodeContent newContent) {
        if (newContent == null) {
            this.ppn = null;
            this.serialNumber = null;
            this.charge = null;
            this.productCode = null;
            this.pzn = null;
            this.codeId = null;
            this.expirationDate = null;
            this.productionDate = null;
            this.bestBeforeDate = null;
            this.productCodeType = null;
            this.additionalId = null;
        } else {
            this.ppn = newContent.ppn;
            this.serialNumber = newContent.serialNumber;
            this.charge = newContent.charge;
            this.productCode = newContent.productCode;
            this.pzn = newContent.pzn;
            this.codeId = newContent.codeId;
            this.expirationDate = newContent.expirationDate;
            this.productionDate = newContent.productionDate;
            this.bestBeforeDate = newContent.bestBeforeDate;
            this.productCodeType = newContent.productCodeType;
            this.additionalId = newContent.additionalId;
            this.ambiguities = new HashSet(newContent.getAmbiguities());
        }
    }

    protected CodeContent getContent() {
        return this;
    }

    protected void clearContent() {
        this.setContent(null);
    }

    @NotNull
    protected Optional<String> getPzn() {
        if (this.pzn != null) {
            return Optional.of(this.pzn);
        }
        if (this.ppn != null) {
            return Optional.of(this.ppn.substring(2, 10));
        }
        if (this.productCode != null) {
            if (this.productCode.length() <= 8) {
                return Optional.of(this.productCode);
            }
            if (this.productCode.length() >= 12 && this.productCode.startsWith("4150")) {
                return Optional.of(this.productCode.substring(4, 12));
            }
            if (this.productCode.length() >= 12 && this.productCode.startsWith("908888")) {
                this.pzn = this.appendCheckDigit(this.productCode.substring(6, 12));
                return Optional.of(this.pzn);
            }
            if (this.productCode.length() >= 13 && this.productCode.startsWith("0908888")) {
                this.pzn = this.appendCheckDigit(this.productCode.substring(7, 13));
                return Optional.of(this.pzn);
            }
        }
        return Optional.empty();
    }

    @NotNull
    protected Optional<String> getCharge() {
        return Optional.ofNullable(this.charge);
    }

    @NotNull
    protected Optional<String> getProductCode() {
        return Optional.ofNullable(this.productCode);
    }

    @NotNull
    protected Optional<String> getCodeId() {
        return Optional.ofNullable(this.codeId);
    }

    @NotNull
    protected Optional<LocalDate> getExpirationDate() {
        return Optional.ofNullable(this.expirationDate);
    }

    @NotNull
    protected Optional<LocalDate> getProductionDate() {
        return Optional.ofNullable(this.productionDate);
    }

    @NotNull
    protected Optional<LocalDate> getBestBeforeDate() {
        return Optional.ofNullable(this.bestBeforeDate);
    }

    @NotNull
    protected Optional<String> getSerialNumber() {
        return Optional.ofNullable(this.serialNumber);
    }

    @NotNull
    protected Optional<String> getAdditionalId() {
        return Optional.ofNullable(this.additionalId);
    }

    @NotNull
    public Optional<?> get(@NotNull InformationType info) {
        switch (info) {
            case CHARGE: {
                return this.getCharge();
            }
            case EXPIRATION_DATE: {
                return this.getExpirationDate();
            }
            case PZN: {
                return this.getPzn();
            }
            case PRODUCT_CODE: {
                return this.getProductCode();
            }
            case PRODUCTION_DATE: {
                return this.getProductionDate();
            }
            case SERIAL_NUMBER: {
                return this.getSerialNumber();
            }
            case BEST_BEFORE_DATE: {
                return this.getBestBeforeDate();
            }
            case CODE_ID: {
                return this.getCodeId();
            }
            case ADDITIONAL_ID: {
                return this.getAdditionalId();
            }
        }
        return Optional.empty();
    }

    @NotNull
    protected Set<Ambiguity<?>> getAmbiguities() {
        return this.ambiguities;
    }

    public <T> void addAmbiguity(@NotNull InformationType info, final @Nullable T alternative) {
        if (alternative == null) {
            return;
        }
        Optional<Ambiguity> existingAmbiguity = this.getAmbiguities().stream().filter(a -> a.getInfo().equals((Object)info)).findAny();
        if (existingAmbiguity.isPresent()) {
            existingAmbiguity.get().addAlternative(alternative);
        } else {
            this.getAmbiguities().add(new Ambiguity(info, new HashSet<T>(){
                {
                    this.add(alternative);
                }
            }));
        }
    }

    @NotNull
    private String appendCheckDigit(@NotNull String pzn) {
        try {
            if (pzn.length() == 6) {
                pzn = pzn + this.calcCheckDigit(pzn.toCharArray());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Pr\u00fcfziffer f\u00fcr die PZN %s konnte nicht berechnet werden.", pzn), t);
        }
        return pzn;
    }

    private int calcCheckDigit(char[] pzn) {
        int sum = 0;
        int i = 2;
        for (char digitChar : pzn) {
            int digit = Character.getNumericValue(digitChar);
            sum += digit * i;
            ++i;
        }
        int checkDigit = sum % 11;
        return checkDigit == 10 ? 0 : checkDigit;
    }
}

