/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm;

import de.gzim.secupharm.AbstractSecuPharmReader;
import de.gzim.secupharm.Constants;
import de.gzim.secupharm.SecuPharmReadException;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class BlockBasedSecuPharmReader
extends AbstractSecuPharmReader {
    /*
     * Enabled aggressive block sorting
     */
    BlockBasedSecuPharmReader(@NotNull String code) throws SecuPharmReadException {
        super(code);
        Pattern pattern = Pattern.compile("\\(\\d{2}\\)");
        Matcher matcher = pattern.matcher(code);
        if (matcher.find()) {
            code = code.replace(")", "");
        }
        String[] blocks = code.split("[^0-9a-zA-Z\\]]");
        State state = new State();
        HashSet<Constants.Mark> parsedMarks = new HashSet<Constants.Mark>();
        String[] stringArray = blocks;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String block = stringArray[n2];
            state.setNextBlock(block);
            block15: while (true) {
                Constants.Mark mark;
                if (parsedMarks.contains((Object)(mark = this.readMark(state)))) {
                    state.incPosBy(1);
                    continue;
                }
                switch (mark) {
                    case CodeId: {
                        this.codeId = this.readCodeId(state);
                        break;
                    }
                    case PPN: {
                        this.ppn = this.readPpn(state);
                        break;
                    }
                    case SerialNumber: {
                        this.serialNumber = this.readSerialNumber(state);
                        break;
                    }
                    case Charge: {
                        this.charge = this.readCharge(state);
                        break;
                    }
                    case ProductionDate: {
                        this.productionDate = this.readDate(state);
                        break;
                    }
                    case BestBeforeDate: {
                        this.bestBeforeDate = this.readDate(state);
                        break;
                    }
                    case ProductCode: {
                        this.productCode = this.readProductCode(state);
                        break;
                    }
                    case ExpirationDate: {
                        this.expirationDate = this.readDate(state);
                        break;
                    }
                    case PZN: {
                        this.pzn = this.readPzn(state);
                        break;
                    }
                    case AdditionalId: {
                        this.additionalId = this.readAdditionalId(state);
                        break;
                    }
                    case Fin: {
                        break block15;
                    }
                    case Separator: 
                    case Unknown: {
                        continue block15;
                    }
                }
                parsedMarks.add(mark);
            }
            ++n2;
        }
        return;
    }

    @NotNull
    private String readCodeId(@NotNull State state) {
        return "]" + state.incPosBy(2);
    }

    @NotNull
    private Constants.Mark readMark(@NotNull State state) throws SecuPharmReadException {
        String code = state.getBlock();
        if (state.isFin()) {
            return Constants.Mark.Fin;
        }
        int pos = state.getPos();
        String mark1 = code.substring(pos, pos + 1);
        String mark2 = code.substring(pos, Math.min(code.length(), pos + 2));
        String mark3 = code.substring(pos, Math.min(code.length(), pos + 3));
        if (!state.getMode().isPresent()) {
            switch (mark1) {
                case "]": {
                    state.incPosBy(1);
                    state.setMode(Constants.Mode.AI);
                    return Constants.Mark.CodeId;
                }
                case "D": {
                    state.incPosBy(1);
                    state.setMode(Constants.Mode.DI);
                    return Constants.Mark.ExpirationDate;
                }
                case "S": {
                    state.incPosBy(1);
                    state.setMode(Constants.Mode.DI);
                    return Constants.Mark.SerialNumber;
                }
            }
            switch (mark2) {
                case "01": {
                    state.incPosBy(2);
                    state.setMode(Constants.Mode.AI);
                    return Constants.Mark.ProductCode;
                }
                case "8P": {
                    state.incPosBy(2);
                    state.setMode(Constants.Mode.DI);
                    return Constants.Mark.ProductCode;
                }
                case "10": {
                    state.incPosBy(2);
                    state.setMode(Constants.Mode.AI);
                    return Constants.Mark.Charge;
                }
                case "1T": {
                    state.incPosBy(2);
                    state.setMode(Constants.Mode.DI);
                    return Constants.Mark.Charge;
                }
                case "17": {
                    state.incPosBy(2);
                    state.setMode(Constants.Mode.AI);
                    return Constants.Mark.ExpirationDate;
                }
                case "21": {
                    state.incPosBy(2);
                    state.setMode(Constants.Mode.AI);
                    return Constants.Mark.SerialNumber;
                }
                case "9N": {
                    state.incPosBy(2);
                    state.setMode(Constants.Mode.DI);
                    return Constants.Mark.PPN;
                }
            }
            switch (mark3) {
                case "710": {
                    state.incPosBy(3);
                    return Constants.Mark.PZN;
                }
                case "240": {
                    state.incPosBy(3);
                    return Constants.Mark.AdditionalId;
                }
            }
            state.incPosBy(1);
            return Constants.Mark.Unknown;
        }
        if (state.getMode().orElse(null) == Constants.Mode.AI) {
            switch (mark2) {
                case "01": {
                    state.incPosBy(2);
                    return Constants.Mark.ProductCode;
                }
                case "10": {
                    state.incPosBy(2);
                    return Constants.Mark.Charge;
                }
                case "11": {
                    state.incPosBy(2);
                    return Constants.Mark.ProductionDate;
                }
                case "15": {
                    state.incPosBy(2);
                    return Constants.Mark.BestBeforeDate;
                }
                case "17": {
                    state.incPosBy(2);
                    return Constants.Mark.ExpirationDate;
                }
                case "21": {
                    state.incPosBy(2);
                    return Constants.Mark.SerialNumber;
                }
            }
            switch (mark3) {
                case "710": {
                    state.incPosBy(3);
                    return Constants.Mark.PZN;
                }
                case "240": {
                    state.incPosBy(3);
                    return Constants.Mark.AdditionalId;
                }
            }
            state.incPosBy(1);
            return Constants.Mark.Unknown;
        }
        if (state.getMode().orElse(null) == Constants.Mode.DI) {
            switch (mark1) {
                case "D": {
                    state.incPosBy(1);
                    return Constants.Mark.ExpirationDate;
                }
                case "S": {
                    state.incPosBy(1);
                    return Constants.Mark.SerialNumber;
                }
            }
            switch (mark2) {
                case "8P": {
                    state.incPosBy(2);
                    return Constants.Mark.ProductCode;
                }
                case "1T": {
                    state.incPosBy(2);
                    return Constants.Mark.Charge;
                }
                case "9N": {
                    state.incPosBy(2);
                    return Constants.Mark.PPN;
                }
            }
            switch (mark3) {
                case "710": {
                    state.incPosBy(3);
                    return Constants.Mark.PZN;
                }
            }
            state.incPosBy(1);
            return Constants.Mark.Unknown;
        }
        throw new SecuPharmReadException(SecuPharmReadException.Type.INTERNAL, "mode in unknown state:" + state.getMode());
    }

    @NotNull
    private String readPpn(@NotNull State state) throws SecuPharmReadException {
        String ppn = state.incPosBy(12);
        return this.parsePpn(ppn);
    }

    @NotNull
    private String readPzn(@NotNull State state) throws SecuPharmReadException {
        String pzn = state.incPosBy(8);
        return this.parsePzn(pzn);
    }

    @NotNull
    private String readSerialNumber(@NotNull State state) {
        return state.incPosBy(20);
    }

    @NotNull
    private String readCharge(@NotNull State state) {
        return state.incPosBy(20);
    }

    @NotNull
    private String readAdditionalId(@NotNull State state) {
        return state.incPosBy(30);
    }

    @NotNull
    private LocalDate readDate(@NotNull State state) {
        String expirationDate = state.incPosBy(6);
        int year = Integer.parseInt(expirationDate.substring(0, 2)) + 2000;
        int month = Integer.parseInt(expirationDate.substring(2, 4));
        int day = Integer.parseInt(expirationDate.substring(4, 6));
        if (day == 0) {
            return LocalDate.of(year, month, 1).with(TemporalAdjusters.lastDayOfMonth());
        }
        return LocalDate.of(year, month, day);
    }

    @NotNull
    private String readProductCode(@NotNull State state) throws SecuPharmReadException {
        String ntin = state.incPosBy(14);
        return this.parseNtin(ntin);
    }

    private static class State {
        private int pos = 0;
        private String block = "";
        private Constants.Mode mode = null;

        State() {
        }

        public void setNextBlock(@NotNull String block) {
            this.pos = 0;
            this.block = block;
        }

        @NotNull
        public String getBlock() {
            return this.block;
        }

        public int getPos() {
            return this.pos;
        }

        @NotNull
        public String incPosBy(int inc) {
            if (this.pos + inc <= this.block.length()) {
                return this.block.substring(this.pos, this.pos += inc);
            }
            int oldpos = this.pos;
            this.pos = this.block.length();
            return this.block.substring(oldpos);
        }

        public void setMode(@NotNull Constants.Mode mode) {
            this.mode = mode;
        }

        @NotNull
        public Optional<Constants.Mode> getMode() {
            return Optional.ofNullable(this.mode);
        }

        public boolean isFin() {
            return this.pos >= this.block.length();
        }
    }
}

