/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm;

import de.gzim.secupharm.InformationType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ambiguity<T> {
    @NotNull
    private final InformationType info;
    @NotNull
    private final Set<T> alternatives;

    public Ambiguity(@NotNull InformationType info) {
        this(info, null);
    }

    public Ambiguity(@NotNull InformationType info, @Nullable Set<T> alternatives) {
        this.info = info;
        this.alternatives = alternatives == null ? new HashSet() : alternatives;
    }

    @NotNull
    public InformationType getInfo() {
        return this.info;
    }

    @NotNull
    public Set<T> getAlternatives() {
        return this.alternatives;
    }

    public void addAlternative(@NotNull T alternative) {
        Class<?> expectedClass = this.info.getClazz();
        if (!alternative.getClass().equals(expectedClass)) {
            throw new IllegalArgumentException("Alternative has wrong class. Expected: " + expectedClass.getName());
        }
        this.alternatives.add(alternative);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ambiguity ambiguity = (Ambiguity)o;
        return this.info == ambiguity.info;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.info});
    }
}

