/*
 * Decompiled with CFR 0.152.
 */
package de.gzim.secupharm;

import de.gzim.secupharm.CodeContent;
import de.gzim.secupharm.Constants;
import de.gzim.secupharm.SecuPharmReadException;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSecuPharmReader
extends CodeContent {
    private final String code;

    public AbstractSecuPharmReader(@NotNull String code) {
        this.code = code;
    }

    @NotNull
    protected String getCode() {
        return this.code;
    }

    @NotNull
    protected String parseNtin(@NotNull String ntin) throws SecuPharmReadException {
        int i;
        if (ntin.length() < 4) {
            throw new SecuPharmReadException(SecuPharmReadException.Type.INTERNAL, "Eingelesener String ist zu kurz f\u00fcr eine NTIN!");
        }
        int v = 0;
        int k = 0;
        int p = Integer.parseInt(ntin.substring(ntin.length() - 1));
        int leadingZeros = 0;
        for (i = 0; i < ntin.length() && ntin.charAt(i) == '0'; ++i) {
            ++leadingZeros;
        }
        if (leadingZeros >= 6) {
            this.productCodeType = Constants.ProductCodeType.NTIN;
            for (i = 6; i < ntin.length() - 1; ++i) {
                v += ++k * (ntin.charAt(i) - 48);
            }
            if ((v %= 11) != p) {
                throw new SecuPharmReadException(SecuPharmReadException.Type.CHECKSUM, String.format("NTIN-Pr\u00fcfziffer nicht korrekt! Erwarte %d, gefunden %d", v, p));
            }
            return ntin.substring(6, 14);
        }
        this.productCodeType = Constants.ProductCodeType.GTIN;
        for (i = 0; i < ntin.length() - 1; ++i) {
            int x = ntin.length() - 2 - i;
            int m = x % 2 == 0 ? 3 : 1;
            v += m * (ntin.charAt(x) - 48);
        }
        if ((v = (10 - v % 10) % 10) != p) {
            throw new SecuPharmReadException(SecuPharmReadException.Type.CHECKSUM, String.format("GTIN-Pr\u00fcfziffer nicht korrekt! Erwarte %d, gefunden %d", v, p));
        }
        return ntin.substring(leadingZeros);
    }

    @NotNull
    protected String parsePzn(@NotNull String pzn) throws SecuPharmReadException {
        int v = 0;
        int p = Integer.parseInt(pzn.substring(pzn.length() - 1));
        int k = 0;
        for (int i = 0; i < pzn.length() - 1; ++i) {
            v += ++k * (pzn.charAt(i) - 48);
        }
        if ((v %= 11) != p) {
            throw new SecuPharmReadException(SecuPharmReadException.Type.CHECKSUM, String.format("NTIN-Pr\u00fcfziffer nicht korrekt! Erwarte %d. Gefunden %d", v, p));
        }
        return pzn;
    }

    @NotNull
    protected String parsePpn(@NotNull String ppn) throws SecuPharmReadException {
        int v = 0;
        int p = Integer.parseInt(ppn.substring(ppn.length() - 2));
        for (int i = 0; i < ppn.length() - 2; ++i) {
            v += (i + 2) * ppn.charAt(i);
        }
        if ((v %= 97) != p) {
            throw new SecuPharmReadException(SecuPharmReadException.Type.CHECKSUM, String.format("PPN-Pr\u00fcfziffer nicht korrekt! Erwarte %d. Gefunden %d", v, p));
        }
        return ppn;
    }
}

