/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v2.model;

import com.google.common.hash.Hashing;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.common.utils.SignatureLogger;
import de.impfdoc.impfzert.v2.model.BaseVaccinationContentV2;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseVaccinationToMioConverterV2 {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(BaseVaccinationToMioConverterV2.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final Map<String, Function<BaseVaccinationContentV2, String>> mapper = new HashMap<String, Function<BaseVaccinationContentV2, String>>(){
        {
            this.put("$DOCUMENT_ID", c -> BaseVaccinationToMioConverterV2.generateDeterministicUUID(c, 1).toString());
            this.put("$PATIENT_ID", c -> BaseVaccinationToMioConverterV2.generateDeterministicUUID(c, 2).toString());
            this.put("$VACCINATION_ADDON_ID", c -> BaseVaccinationToMioConverterV2.generateDeterministicUUID(c, 3).toString());
            this.put("$PRACTITIONER_ID", c -> BaseVaccinationToMioConverterV2.generateDeterministicUUID(c, 4).toString());
            this.put("$ORGANIZATION_ID", c -> BaseVaccinationToMioConverterV2.generateDeterministicUUID(c, 5).toString());
            this.put("$PRACTITIONER_ROLE_ID", c -> BaseVaccinationToMioConverterV2.generateDeterministicUUID(c, 6).toString());
            this.put("$VACCINATION_RECORD_ID", c -> BaseVaccinationToMioConverterV2.generateDeterministicUUID(c, 7).toString());
            this.put("$VACCINATION_ID", c -> BaseVaccinationToMioConverterV2.generateDeterministicUUID(c, 8).toString());
            this.put("$LANR", c -> c.getField(BaseVaccinationContentV2.Field.PRACTITIONER_LANR));
            this.put("$PRACTITIONER_TITLE", c -> c.getField(BaseVaccinationContentV2.Field.DOCTOR_TITLE));
            this.put("$PRACTITIONER_FIRSTNAME", c -> c.getField(BaseVaccinationContentV2.Field.DOCTOR_FIRSTNAME));
            this.put("$PRACTITIONER_LASTNAME", c -> c.getField(BaseVaccinationContentV2.Field.DOCTOR_LASTNAME));
            this.put("$PRACTITIONER_STREET", c -> c.getField(BaseVaccinationContentV2.Field.DOCTOR_STREET));
            this.put("$PRACTITIONER_CITY", c -> c.getField(BaseVaccinationContentV2.Field.DOCTOR_CITY));
            this.put("$PRACTITIONER_PLZ", c -> c.getField(BaseVaccinationContentV2.Field.DOCTOR_PLZ));
            this.put("$PRACTITIONER_PHONE", c -> c.getField(BaseVaccinationContentV2.Field.DOCTOR_PHONE));
            this.put("$PRACTITIONER_COUNTRY", c -> c.getField(BaseVaccinationContentV2.Field.DOCTOR_COUNTRY));
            this.put("$PATIENT_REISEPASSNR", c -> c.getField(BaseVaccinationContentV2.Field.PATIENT_PASSNUMBER));
            this.put("$PATIENT_TITLE", c -> c.getField(BaseVaccinationContentV2.Field.PATIENT_TITLE));
            this.put("$PATIENT_FIRSTNAME", c -> c.getField(BaseVaccinationContentV2.Field.PATIENT_FIRSTNAME));
            this.put("$PATIENT_LASTNAME", c -> c.getField(BaseVaccinationContentV2.Field.PATIENT_LASTNAME));
            this.put("$PATIENT_GENDER", c -> {
                switch (c.getField(BaseVaccinationContentV2.Field.PATIENT_SEX)) {
                    case "m": {
                        return "male";
                    }
                    case "w": {
                        return "female";
                    }
                    case "u": {
                        return "undetermined";
                    }
                    case "0": {
                        return "unknown";
                    }
                }
                return "";
            });
            this.put("$PATIENT_BIRTHDAY", c -> c.getField(BaseVaccinationContentV2.Field.PATIENT_BIRTHDAY));
            this.put("$VACCINATION_DATE_TIME", c -> LocalDate.parse(c.getField(BaseVaccinationContentV2.Field.VACCINATION_DATE), formatter) + "T000000.000Z");
            this.put("$VACCINATION_DATE", c -> c.getField(BaseVaccinationContentV2.Field.VACCINATION_DATE));
            this.put("$VACCINE_ATC", c -> c.getField(BaseVaccinationContentV2.Field.VACCINATION_ATC));
            this.put("$VACCINE_NAME", c -> c.getField(BaseVaccinationContentV2.Field.VACCINE));
            this.put("$MANUFACTURER_NAME", c -> c.getField(BaseVaccinationContentV2.Field.MARKETING_AUTHORIZATION_HOLDER));
            this.put("$CHARGE", c -> c.getField(BaseVaccinationContentV2.Field.CHARGE));
            this.put("$DOSE_NR", c -> c.getField(BaseVaccinationContentV2.Field.DOSE));
        }
    };

    @NotNull
    public static String generateMioForSingleVaccination(@NotNull BaseVaccinationContentV2 unsignedContent) {
        log.info("Generate FHIR");
        try {
            InputStream inputStream = BaseVaccinationToMioConverterV2.class.getClassLoader().getResourceAsStream("content/mio_fhir_base64.txt");
            if (inputStream == null) {
                throw new IllegalStateException("content/mio_fhir.xml not found");
            }
            String template = new String(Base64.getDecoder().decode(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            for (Map.Entry entry : mapper.entrySet().stream().sorted((o1, o2) -> -Integer.compare(((String)o1.getKey()).length(), ((String)o2.getKey()).length())).collect(Collectors.toList())) {
                String placeholder = (String)entry.getKey();
                String value = StringEscapeUtils.escapeXml11((String)((String)((Function)entry.getValue()).apply(unsignedContent)));
                template = template.replace(placeholder, value);
            }
            SignatureLogger.logFhir(template);
            String string = template;
            return string;
        }
        catch (Throwable t) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, t.toString(), t);
        }
        finally {
            log.info("Generated FHIR");
        }
    }

    @NotNull
    private static UUID generateDeterministicUUID(@NotNull BaseVaccinationContentV2 content, int n) {
        String base = content.generateHash();
        try {
            byte[] hash = Hashing.sha256().hashBytes(base.getBytes(StandardCharsets.UTF_8)).asBytes();
            MessageDigest md4 = MessageDigest.getInstance("MD4");
            for (int j = 0; j < n; ++j) {
                hash = md4.digest(hash);
            }
            String part1 = Hex.encodeHexString((byte[])Arrays.copyOfRange(hash, 0, 4));
            String part2 = Hex.encodeHexString((byte[])Arrays.copyOfRange(hash, 4, 6));
            String part3 = Hex.encodeHexString((byte[])Arrays.copyOfRange(hash, 6, 8));
            String part4 = Hex.encodeHexString((byte[])Arrays.copyOfRange(hash, 8, 10));
            String part5 = Hex.encodeHexString((byte[])Arrays.copyOfRange(hash, 10, 16));
            return UUID.fromString(String.format("%s-%s-%s-%s-%s", part1, part2, part3, part4, part5));
        }
        catch (Throwable t) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, t.toString(), t);
        }
    }
}

