/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v2.encoder;

import de.impfdoc.impfzert.common.encoder.QRCodeEncoder;
import de.impfdoc.impfzert.common.utils.SignatureLogger;
import de.impfdoc.impfzert.v2.encoder.Base44;
import de.impfdoc.impfzert.v2.encoder.EncodedSignedVaccinationV2;
import de.impfdoc.impfzert.v2.encoder.QRCodeEncoderV2;
import de.impfdoc.impfzert.v2.model.SignedVaccinationV2;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base32;
import org.bouncycastle.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class SignedVaccinationEncoderV2 {
    @NotNull
    private final QRCodeEncoder generator;
    @NotNull
    private final String validationBaseDomain;

    public SignedVaccinationEncoderV2(@NotNull String validationBaseDomain) {
        this.validationBaseDomain = validationBaseDomain;
        this.generator = new QRCodeEncoderV2();
    }

    @NotNull
    public EncodedSignedVaccinationV2 encode(@NotNull SignedVaccinationV2 content) {
        byte[] compressedContent = this.generator.compress(this.generateQRContent(content));
        Base32 base32 = new Base32();
        String qrCodeContent = "2-" + Base44.getEncoder().encodeToString(compressedContent);
        String linkContent = "2-" + base32.encodeAsString(compressedContent).replace('=', '$');
        String url = this.generateLink(linkContent, this.validationBaseDomain);
        BufferedImage qrCode = this.generator.generate(qrCodeContent);
        SignatureLogger.logQrCode(qrCodeContent);
        SignatureLogger.logQrCodeDocument(qrCode);
        return new EncodedSignedVaccinationV2(qrCode, url, content);
    }

    @NotNull
    private String generateLink(@NotNull String encodedContent, @NotNull String validationBaseDomain) {
        return validationBaseDomain + "#" + encodedContent;
    }

    private byte[] generateQRContent(@NotNull SignedVaccinationV2 content) {
        List params = content.getFields().stream().filter(e -> !((String)e.getKey()).isEmpty()).map(e -> {
            try {
                return String.format("%s=%s", e.getKey(), URLEncoder.encode((String)e.getValue(), StandardCharsets.ISO_8859_1.name()));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }).collect(Collectors.toList());
        byte[] binaryCert = content.getBinaryCertificate();
        byte[] r = Arrays.concatenate((byte[])("?" + String.join((CharSequence)"&", params) + "?").getBytes(StandardCharsets.ISO_8859_1), (byte[])binaryCert);
        SignatureLogger.logTiCertPart(binaryCert);
        return r;
    }
}

