/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v2.encoder;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.DataMatrixWriter;
import com.google.zxing.qrcode.QRCodeWriter;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.common.encoder.QRCodeEncoder;
import de.impfdoc.impfzert.v2.encoder.Base44;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class QRCodeEncoderV2
implements QRCodeEncoder {
    private final byte[] dictionary;
    @NotNull
    private final QRCodeWriter qrCodeWriter = new QRCodeWriter();
    private final Base32 base32 = new Base32();

    public QRCodeEncoderV2() {
        this(null);
    }

    public QRCodeEncoderV2(@Nullable String dictionary) {
        if (dictionary != null) {
            this.dictionary = Base64.getDecoder().decode(dictionary);
        } else {
            try {
                this.dictionary = this.initDictionary();
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read resource \"dictionaries/dict_v2.txt\"");
            }
        }
    }

    private byte[] initDictionary() throws IOException {
        InputStream inputStream = QRCodeEncoderV2.class.getClassLoader().getResourceAsStream("dictionaries/dict_v2.txt");
        if (inputStream == null) {
            throw new IllegalStateException("Resource at \"dictionaries/dict_v2.txt\" not found");
        }
        String encodedDict = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.ISO_8859_1);
        return Base64.getDecoder().decode(encodedDict);
    }

    @Override
    @NotNull
    public String encode(byte[] content) {
        return this.encode(content, null);
    }

    @NotNull
    public String encode(byte[] content, @Nullable String dict) {
        return Base44.getEncoder().encodeToString(this.compress(content, dict));
    }

    @NotNull
    public String encodeBase32(byte[] content) {
        return this.encodeBase32(content, null);
    }

    @NotNull
    public String encodeBase32(byte[] content, @Nullable String dict) {
        return this.base32.encodeAsString(this.compress(content, dict)).replace('=', '$');
    }

    @Override
    public byte[] decode(@NotNull String content) {
        return this.decode(content, null);
    }

    public byte[] decode(@NotNull String content, @Nullable String dict) {
        return this.decompress(Base44.getDecoder().decode(content), dict);
    }

    public byte[] decodeBase32(@NotNull String content) {
        return this.decodeBase32(content, null);
    }

    public byte[] decodeBase32(@NotNull String content, @Nullable String dict) {
        return this.decompress(this.base32.decode(content.replace('$', '=')), dict);
    }

    @Override
    @NotNull
    public byte[] compress(@NotNull byte[] in) {
        return this.compress(in, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] compress(@NotNull byte[] in, @Nullable String dict) {
        try {
            Deflater deflater = new Deflater(9, true);
            try {
                byte[] byArray;
                if (dict == null) {
                    deflater.setDictionary(this.dictionary);
                } else {
                    deflater.setDictionary(Base64.getDecoder().decode(dict));
                }
                deflater.setInput(in);
                deflater.finish();
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    byte[] buf = new byte[4096];
                    while (!deflater.finished()) {
                        int len = deflater.deflate(buf, 0, buf.length);
                        out.write(buf, 0, len);
                    }
                    deflater.end();
                    byte[] result = out.toByteArray();
                    LoggerFactory.getLogger(this.getClass()).info("Compressed from {} bytes to {} bytes", (Object)in.length, (Object)result.length);
                    byArray = result;
                }
                return byArray;
            }
            finally {
                deflater.end();
            }
        }
        catch (IOException ioe) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
        }
    }

    @Override
    @NotNull
    public byte[] decompress(@NotNull byte[] in) {
        return this.decompress(in, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] decompress(@NotNull byte[] in, @Nullable String dict) {
        try {
            Inflater inflater = new Inflater(true);
            try {
                byte[] byArray;
                if (dict == null) {
                    inflater.setDictionary(this.dictionary);
                } else {
                    inflater.setDictionary(Base64.getDecoder().decode(dict));
                }
                inflater.setInput(in);
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    int len;
                    byte[] buf = new byte[4096];
                    while (!inflater.finished() && (len = inflater.inflate(buf, 0, buf.length)) != 0) {
                        out.write(buf, 0, len);
                    }
                    byArray = out.toByteArray();
                }
                return byArray;
            }
            finally {
                inflater.end();
            }
        }
        catch (IOException | DataFormatException ioe) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
        }
    }

    @Override
    @NotNull
    public BufferedImage generate(@NotNull String content) {
        LoggerFactory.getLogger(this.getClass()).info("Write QR-Code (Length={}) {}", (Object)content.length(), (Object)content);
        try {
            HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>(){
                {
                    this.put(EncodeHintType.CHARACTER_SET, "ISO_8859_1");
                }
            };
            BitMatrix matrix = this.qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, 440, 440, (Map)hints);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
        }
        catch (Throwable t) {
            if (t instanceof WriterException && t.getMessage().contains("Data too big for requested version")) {
                try {
                    DataMatrixWriter dataMatrixWriter = new DataMatrixWriter();
                    BitMatrix matrix = dataMatrixWriter.encode(content, BarcodeFormat.DATA_MATRIX, 512, 512);
                    return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
                }
                catch (Throwable t2) {
                    throw new ImpfZertException(ImpfZertException.Type.Unknown, t2.toString(), t2);
                }
            }
            throw new ImpfZertException(ImpfZertException.Type.Unknown, t.toString(), t);
        }
    }
}

