/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v2.encoder;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Base44 {
    private static final int BaseSize = 44;
    private static final int ChunkSize = 2;
    private static final int EncodedChunkSize = 3;
    private static final int SmallEncodedChunkSize = 2;
    private static final int ByteSize = 256;

    private Base44() {
    }

    public static Encoder getEncoder() {
        return Encoder.ENCODER;
    }

    public static Decoder getDecoder() {
        return Decoder.DECODER;
    }

    public static class Decoder {
        private static final int[] fromBase44 = new int[256];
        static final Decoder DECODER;

        private Decoder() {
        }

        public byte[] decode(byte[] src) {
            int remainderSize = src.length % 3;
            int[] buffer = new int[src.length];
            for (int i = 0; i < src.length; ++i) {
                buffer[i] = fromBase44[src[i]];
                if (buffer[i] != -1) continue;
                System.out.println(i);
                System.out.println(src[i]);
                System.out.println((char)src[i]);
                throw new IllegalArgumentException();
            }
            int wholeChunkCount = buffer.length / 3;
            byte[] result = new byte[wholeChunkCount * 2 + (remainderSize == 2 ? 1 : 0)];
            int resultIndex = 0;
            int wholeChunkLength = wholeChunkCount * 3;
            int i = 0;
            while (i < wholeChunkLength) {
                int val = buffer[i++] + 44 * buffer[i++] + 1936 * buffer[i++];
                result[resultIndex++] = (byte)(val / 256);
                result[resultIndex++] = (byte)(val % 256);
            }
            if (remainderSize != 0) {
                result[resultIndex] = (byte)(buffer[buffer.length - 2] + 44 * buffer[buffer.length - 1]);
            }
            return result;
        }

        public byte[] decode(String src) {
            return this.decode(src.getBytes(StandardCharsets.ISO_8859_1));
        }

        static {
            Arrays.fill(fromBase44, -1);
            for (int i = 0; i < Encoder.toBase44.length; ++i) {
                Decoder.fromBase44[Encoder.toBase44[i]] = i;
            }
            DECODER = new Decoder();
        }
    }

    public static class Encoder {
        private static final byte[] toBase44 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 32, 36, 37, 42, 43, 46, 47, 58};
        static final Encoder ENCODER = new Encoder();

        public byte[] encode(byte[] src) {
            int wholeChunkCount = src.length / 2;
            byte[] result = new byte[wholeChunkCount * 3 + (src.length % 2 == 1 ? 2 : 0)];
            int resultIndex = 0;
            int wholeChunkLength = wholeChunkCount * 2;
            int i = 0;
            while (i < wholeChunkLength) {
                int value = (src[i++] & 0xFF) * 256 + (src[i++] & 0xFF);
                result[resultIndex++] = toBase44[value % 44];
                result[resultIndex++] = toBase44[value / 44 % 44];
                result[resultIndex++] = toBase44[value / 1936 % 44];
            }
            if (src.length % 2 != 0) {
                result[result.length - 2] = toBase44[(src[src.length - 1] & 0xFF) % 44];
                result[result.length - 1] = (src[src.length - 1] & 0xFF) < 44 ? toBase44[0] : toBase44[(src[src.length - 1] & 0xFF) / 44 % 44];
            }
            return result;
        }

        public String encodeToString(byte[] src) {
            byte[] encoded = this.encode(src);
            return new String(encoded, 0, 0, encoded.length);
        }
    }
}

