/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v2;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import de.gematik.ws.conn.certificateservicecommon.v2.X509DataInfoListType;
import de.impfdoc.impfzert.QRStructure;
import de.impfdoc.impfzert.api.ImpfZertQrReader;
import de.impfdoc.impfzert.api.Signer;
import de.impfdoc.impfzert.common.KnownRoots;
import de.impfdoc.impfzert.model.ImpfZertCertifiedVaccination;
import de.impfdoc.impfzert.v2.model.BaseVaccinationContentV2;
import de.impfdoc.impfzert.v2.model.SignedVaccinationV2;
import de.impfsoft.ticonnector.Signature;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ImpfZertQrReaderV2
implements ImpfZertQrReader {
    @NotNull
    private final KnownRoots knownRoots;

    public ImpfZertQrReaderV2(boolean isWithTests) {
        this.knownRoots = new KnownRoots(isWithTests);
    }

    @Override
    @NotNull
    public ImpfZertCertifiedVaccination read(@NotNull QRStructure qrStructure) {
        return this.readValidationQrCode(qrStructure).getBaseVaccinationContent().toCertifiedVaccination();
    }

    @NotNull
    private SignedVaccinationV2 readValidationQrCode(@NotNull QRStructure qrStructure) {
        byte[] decodedContent = qrStructure.getDecodedContent();
        int signatureBegin = qrStructure.getSignatureBegin();
        String code = new String(Arrays.copyOfRange(decodedContent, 0, signatureBegin), StandardCharsets.ISO_8859_1);
        final byte[] certSection = Arrays.copyOfRange(decodedContent, signatureBegin + 1, decodedContent.length);
        String paramSection = "http:\\test.de" + code;
        Multimap<String, String> params = ImpfZertQrReaderV2.getQueryParams(paramSection);
        Map<String, String> singleParams = params.entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        SignedVaccinationV2 signedVaccination = new BaseVaccinationContentV2(singleParams).withSigner(new Signer(){

            @Override
            @NotNull
            public Signature sign(@NotNull String content) {
                ByteArrayInputStream bais = new ByteArrayInputStream(certSection);
                return new Signature((InputStream)bais, CardTypeType.HBA);
            }

            @Override
            @NotNull
            public X509DataInfoListType.X509DataInfo queryCertificate() {
                return null;
            }
        });
        signedVaccination.validateSignature(this.knownRoots);
        return signedVaccination;
    }

    @NotNull
    private static Multimap<String, String> getQueryParams(@NotNull String url) {
        try {
            ArrayListMultimap params = ArrayListMultimap.create();
            String[] urlParts = url.split("\\?");
            if (urlParts.length > 1) {
                String query = urlParts[1];
                for (String param : query.split("&")) {
                    String[] pair = param.split("=");
                    String key = URLDecoder.decode(pair[0], StandardCharsets.UTF_8.name());
                    String value = "";
                    if (pair.length > 1) {
                        value = URLDecoder.decode(pair[1], StandardCharsets.UTF_8.name());
                    }
                    params.put((Object)key, (Object)value);
                }
            }
            return params;
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
    }
}

