/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v1.pdf;

import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.common.pdf.PdfUtils;
import de.impfdoc.impfzert.v1.pdf.ImpfZertFormDataV1;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import org.apache.pdfbox.multipdf.Overlay;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.jetbrains.annotations.NotNull;
import rst.pdfbox.layout.shape.RoundRect;
import rst.pdfbox.layout.text.Position;

public class ImpfZertFormGeneratorV1 {
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    final PDColor blue = new PDColor(new float[]{0.9f, 0.6f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceCMYK.INSTANCE);
    final PDColor black = new PDColor(new float[]{0.0f, 0.0f, 0.0f, 0.8f}, (PDColorSpace)PDDeviceCMYK.INSTANCE);
    final PDColor white = new PDColor(new float[]{0.0f, 0.0f, 0.0f, 0.0f}, (PDColorSpace)PDDeviceCMYK.INSTANCE);
    final PDColor grey = new PDColor(new float[]{0.0f, 0.0f, 0.0f, 0.2f}, (PDColorSpace)PDDeviceCMYK.INSTANCE);

    public InputStream createForm(@NotNull ImpfZertFormDataV1 data) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/content/impfzertifikat_vorlage.pdf");
        PDDocument originalDoc = PDDocument.load((InputStream)inputStream);
        PDDocument overlayDoc = new PDDocument();
        PDPage page1 = new PDPage();
        PDPageContentStream contentStream1 = new PDPageContentStream(overlayDoc, page1, true, true);
        PDColor black = new PDColor(new float[]{0.0f, 0.0f, 0.0f, 0.8f}, (PDColorSpace)PDDeviceCMYK.INSTANCE);
        this.fillForm(data, overlayDoc, contentStream1);
        float x = 31.0f;
        float s = 350.0f;
        float y = 75.0f;
        data.getQRCode().ifPresent(qrCode -> {
            try {
                PDImageXObject imageXObject = LosslessFactory.createFromImage((PDDocument)overlayDoc, (BufferedImage)qrCode);
                contentStream1.drawImage(imageXObject, 31.0f, 75.0f, 350.0f, 350.0f);
            }
            catch (IOException ioe) {
                throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
            }
        });
        data.getLink().ifPresent(link -> {
            Color blue = Color.blue;
            float[] components = new float[]{(float)blue.getRed() / 255.0f, (float)blue.getGreen() / 255.0f, (float)blue.getBlue() / 255.0f};
            PDAnnotationLink txtLink = new PDAnnotationLink();
            PDRectangle position = new PDRectangle();
            position.setLowerLeftX(21.0f);
            position.setLowerLeftY(65.0f);
            position.setUpperRightX(391.0f);
            position.setUpperRightY(485.0f);
            txtLink.setRectangle(position);
            PDActionURI action = new PDActionURI();
            action.setURI(link);
            txtLink.setAction((PDAction)action);
            PdfUtils.addTextAt(contentStream1, "Link zur direkten Validierung", 49.0f, 70.0f, 9.0f, new PDColor(components, (PDColorSpace)PDDeviceRGB.INSTANCE));
            PDPage orgPage = originalDoc.getPage(0);
            try {
                orgPage.getAnnotations().add(txtLink);
            }
            catch (IOException ioe) {
                throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
            }
        });
        contentStream1.close();
        overlayDoc.addPage(page1);
        Overlay overlayObj = new Overlay();
        HashMap ovmap = new HashMap();
        overlayObj.setOverlayPosition(Overlay.Position.FOREGROUND);
        overlayObj.setInputPDF(originalDoc);
        overlayObj.setAllPagesOverlayPDF(overlayDoc);
        overlayObj.overlay(ovmap);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        originalDoc.save((OutputStream)byteArrayOutputStream);
        originalDoc.close();
        overlayDoc.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private void fillForm(@NotNull ImpfZertFormDataV1 data, @NotNull PDDocument pdDocument, @NotNull PDPageContentStream contentStream) throws IOException {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy").withLocale(Locale.getDefault());
        String birthday = dateFormatter.format(data.getBirthday());
        ImpfZertFormDataV1.VaccinationFormData firstVaccination = data.getFirstVaccination().orElse(null);
        ImpfZertFormDataV1.VaccinationFormData secondVaccination = data.getSecondVaccination().orElse(null);
        int xstart = 45;
        int ystart = 700;
        PdfUtils.addTextAt(contentStream, data.getPatientLastnameFirstnameTitle(), 45.0f, 700.0f, 14.0f, this.black);
        PdfUtils.addTextAt(contentStream, birthday, 365.0f, 700.0f, 14.0f, this.black);
        if (firstVaccination != null) {
            PdfUtils.addTextAt(contentStream, firstVaccination.getVaccineName(), 45.0f, 565.0f, 14.0f);
            PdfUtils.addTextAt(contentStream, firstVaccination.getManufactor(), 45.0f, 510.0f, 14.0f);
            float y = 640.0f;
            float boxWidth = 230.0f;
            float boxHeight = 50.0f;
            RoundRect shape = new RoundRect(10.0f);
            shape.fill(pdDocument, contentStream, new Position(45.0f, 640.0f), 230.0f, 50.0f, new Color(this.blue.toRGB()), null);
            PdfUtils.addTextAt(contentStream, "1. Impfung am:", 50.0f, 616.0f, 14.0f, this.white);
            PdfUtils.addTextAt(contentStream, "1st injection on:", 50.0f, 604.0f, 11.0f, this.grey);
            PdfUtils.addTextAt(contentStream, firstVaccination.getVaccinationDate().format(this.formatter), 150.0f, 610.0f, 18.0f, this.white);
            if (secondVaccination != null) {
                float xcol2 = 315.0f;
                PdfUtils.addTextAt(contentStream, secondVaccination.getVaccineName(), xcol2, 565.0f, 14.0f, this.black);
                PdfUtils.addTextAt(contentStream, secondVaccination.getManufactor(), xcol2, 510.0f, 14.0f, this.black);
                shape.fill(pdDocument, contentStream, new Position(xcol2, 640.0f), 230.0f, 50.0f, new Color(this.blue.toRGB()), null);
                PdfUtils.addTextAt(contentStream, "2. Impfung am:", xcol2 + 5.0f, 616.0f, 14.0f, this.white);
                PdfUtils.addTextAt(contentStream, "2nd injection on:", xcol2 + 5.0f, 604.0f, 11.0f, this.grey);
                PdfUtils.addTextAt(contentStream, secondVaccination.getVaccinationDate().format(this.formatter), xcol2 + 105.0f, 610.0f, 18.0f, this.white);
            }
        }
    }
}

