/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v1.pdf;

import de.impfdoc.impfzert.api.VaccinationInfo;
import de.impfdoc.impfzert.model.ImpfZertPatient;
import de.impfdoc.impfzert.model.ImpfZertVaccination;
import de.impfdoc.impfzert.model.KnownVaccine;
import de.impfdoc.impfzert.v1.encoder.EncodedSignedVaccinationV1;
import de.impfdoc.impfzert.v1.model.BaseVaccinationContentV1;
import java.awt.image.BufferedImage;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImpfZertFormDataV1 {
    @NotNull
    private final String UVCI;
    @NotNull
    private final String issuer;
    @Nullable
    private final BufferedImage qrCode;
    @Nullable
    private final String link;
    @NotNull
    private final ImpfZertPatient patient;
    @Nullable
    private final ImpfZertVaccination firstVaccination;
    @Nullable
    private final ImpfZertVaccination secondVaccination;

    public ImpfZertFormDataV1(@NotNull VaccinationInfo vaccinationInfo, @Nullable EncodedSignedVaccinationV1 encodedSignedVaccination) {
        this.patient = vaccinationInfo.getPatient();
        this.firstVaccination = vaccinationInfo.getVaccinations().stream().min(Comparator.comparing(ImpfZertVaccination::getVaccinationDate)).orElse(null);
        this.secondVaccination = vaccinationInfo.getVaccinations().stream().filter(v -> !v.equals(this.firstVaccination)).max(Comparator.comparing(ImpfZertVaccination::getVaccinationDate)).orElse(null);
        if (encodedSignedVaccination != null) {
            this.link = encodedSignedVaccination.getLink();
            this.qrCode = encodedSignedVaccination.getImage();
            this.issuer = encodedSignedVaccination.getSignedVaccination().getBaseVaccinationContent().getField(BaseVaccinationContentV1.Field.CERTIFICATE_ISSUER);
            this.UVCI = encodedSignedVaccination.getSignedVaccination().getBaseVaccinationContent().getField(BaseVaccinationContentV1.Field.UVCI);
        } else {
            this.link = null;
            this.qrCode = null;
            this.issuer = "";
            this.UVCI = "";
        }
    }

    public ImpfZertFormDataV1(@NotNull ImpfZertPatient patient, @Nullable ImpfZertVaccination firstVaccination, @Nullable ImpfZertVaccination secondVaccination, @NotNull String uvci, @NotNull String issuer, @Nullable BufferedImage qrCode, @Nullable String link) {
        this.UVCI = uvci;
        this.issuer = issuer;
        this.patient = patient;
        this.qrCode = qrCode;
        this.link = link;
        this.firstVaccination = firstVaccination;
        this.secondVaccination = secondVaccination;
    }

    @NotNull
    public LocalDate getBirthday() {
        return this.patient.getBirthday();
    }

    @NotNull
    public String getPatientLastnameFirstnameTitle() {
        String title = this.patient.getTitle().orElse(null);
        return String.format("%s, %s", this.patient.getLastname(), this.patient.getFirstname()) + (title != null && !title.isEmpty() ? ", " + title : "");
    }

    @NotNull
    public Optional<VaccinationFormData> getFirstVaccination() {
        if (this.firstVaccination != null) {
            return Optional.of(new VaccinationFormData(this.firstVaccination));
        }
        return Optional.empty();
    }

    @NotNull
    public Optional<VaccinationFormData> getSecondVaccination() {
        if (this.secondVaccination != null) {
            return Optional.of(new VaccinationFormData(this.secondVaccination));
        }
        return Optional.empty();
    }

    @NotNull
    public String getUVCI() {
        return this.UVCI;
    }

    @NotNull
    public String getIssuer() {
        return this.issuer;
    }

    @NotNull
    public Optional<BufferedImage> getQRCode() {
        return Optional.ofNullable(this.qrCode);
    }

    @NotNull
    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    public static class VaccinationFormData {
        @NotNull
        private final ImpfZertVaccination vaccination;

        public VaccinationFormData(@NotNull ImpfZertVaccination vaccination) {
            this.vaccination = vaccination;
        }

        @NotNull
        public LocalDate getVaccinationDate() {
            return this.vaccination.getVaccinationDate();
        }

        @NotNull
        public String getVaccineName() {
            return this.vaccination.getVaccine().getName();
        }

        @NotNull
        public String getManufactor() {
            return KnownVaccine.findById(this.vaccination.getVaccine().getIdentifier()).getManufacturerName().orElse("unbekannt");
        }
    }
}

