/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v1.model;

import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.api.Signer;
import de.impfdoc.impfzert.common.KnownRoots;
import de.impfdoc.impfzert.common.model.SignatureDesc;
import de.impfdoc.impfzert.common.utils.SignatureLogger;
import de.impfdoc.impfzert.v1.model.BaseVaccinationContentV1;
import de.impfdoc.impfzert.v1.model.BaseVaccinationToMioConverterV1;
import de.impfsoft.ticonnector.Signature;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedVaccinationV1 {
    @NotNull
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final BaseVaccinationContentV1 baseVaccinationContent;
    @NotNull
    private final Set<SignatureDesc> signatures = new HashSet<SignatureDesc>();
    @NotNull
    private final Signer signer;

    public SignedVaccinationV1(@NotNull BaseVaccinationContentV1 baseVaccinationContent, @NotNull Signer signer) {
        this.baseVaccinationContent = baseVaccinationContent;
        this.signer = signer;
    }

    @NotNull
    public BaseVaccinationContentV1 getBaseVaccinationContent() {
        return this.baseVaccinationContent;
    }

    @NotNull
    public String getHash() {
        return this.baseVaccinationContent.generateHash();
    }

    @NotNull
    public String getFhir() {
        return BaseVaccinationToMioConverterV1.generateMioForSingleVaccination(this.baseVaccinationContent);
    }

    @NotNull
    public SignatureDesc getSignature(@NotNull SignatureDesc.ContentType contentType) {
        SignatureDesc signatureDesc = this.signatures.stream().filter(info -> info.getContentType() == contentType).findAny().orElse(contentType.handle(new SignatureDesc.ContentTypeHandler<SignatureDesc>(){

            @Override
            @NotNull
            public SignatureDesc handleHash_Signature() {
                SignedVaccinationV1.this.logger.info("Sign HASH");
                Signature signature = SignedVaccinationV1.this.signer.sign(SignedVaccinationV1.this.getHash());
                return SignedVaccinationV1.this.makeDesc(signature, SignatureDesc.ContentType.Hash_Signature);
            }

            @Override
            @NotNull
            public SignatureDesc handleFhir_Signature() {
                SignedVaccinationV1.this.logger.info("Sign FHIR");
                Signature signature = SignedVaccinationV1.this.signer.sign(SignedVaccinationV1.this.getFhir());
                return SignedVaccinationV1.this.makeDesc(signature, SignatureDesc.ContentType.FHIR_Signature);
            }
        }));
        this.signatures.add(signatureDesc);
        return signatureDesc;
    }

    @NotNull
    private SignatureDesc makeDesc(@NotNull Signature signature, @NotNull SignatureDesc.ContentType contentType) {
        SignatureDesc.SignatureType signatureType;
        switch (signature.getCardType()) {
            case HBA: 
            case HBA_Q_SIG: {
                signatureType = SignatureDesc.SignatureType.EHBA;
                break;
            }
            case SMC_B: 
            case SMC_KT: 
            case SM_B: {
                signatureType = SignatureDesc.SignatureType.SMBC;
                break;
            }
            default: {
                throw new ImpfZertException(ImpfZertException.Type.NoCard, "unsupported card type" + signature.getCardType(), null);
            }
        }
        try {
            return new SignatureDesc(contentType, signatureType, Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)signature.getSignature())));
        }
        catch (IOException ioe) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, "some i/o error occured" + ioe.toString(), ioe);
        }
    }

    @NotNull
    public byte[] getFhirSignatureCertificate() {
        String fhirSignature = this.getSignature(SignatureDesc.ContentType.FHIR_Signature).getSignature();
        byte[] signature = Base64.getDecoder().decode(fhirSignature);
        SignatureLogger.logTiCert(signature);
        try {
            CMSSignedData contentInfo = new CMSSignedData(signature);
            Store certs = contentInfo.getCertificates();
            Collection signerCollection = contentInfo.getSignerInfos().getSigners();
            HashSet<BigInteger> selectedSerialNumbers = new HashSet<BigInteger>();
            for (SignerInformation signer : signerCollection) {
                Collection cert2 = certs.getMatches((Selector)signer.getSID());
                X509CertificateHolder x509CertificateHolder = cert2.stream().findAny().orElse(null);
                if (x509CertificateHolder == null) continue;
                selectedSerialNumbers.add(x509CertificateHolder.getSerialNumber());
            }
            Collection certs2 = contentInfo.getCertificates().getMatches(null);
            certs2.removeIf(cert -> !selectedSerialNumbers.contains(cert.getSerialNumber()));
            CollectionStore newStore = new CollectionStore(certs2);
            CMSSignedData newCI = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)contentInfo, (Store)newStore, (Store)contentInfo.getAttributeCertificates(), (Store)contentInfo.getCRLs());
            SignatureLogger.logTiCertPart(newCI.getEncoded());
            return newCI.getEncoded();
        }
        catch (Throwable t) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, "Bei der Verarbeitung der Signatur ist ein Fehler aufgetreten", t);
        }
    }

    public byte[] getBinaryCertificate() {
        try {
            return this.getFhirSignatureCertificate();
        }
        catch (Throwable e) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, "Bei der Verarbeitung der Signatur ist ein Fehler aufgetreten", e);
        }
    }

    @NotNull
    public List<Map.Entry<String, String>> getFields() {
        return this.baseVaccinationContent.getFields();
    }

    public void validateSignature(@NotNull KnownRoots knownRoots) {
        try {
            String fhir = this.getFhir();
            byte[] inCert = this.getFhirSignatureCertificate();
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(fhir.getBytes(StandardCharsets.UTF_8)), inCert);
            Store certs = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection signerCollection = signers.getSigners();
            for (SignerInformation signer : signerCollection) {
                Collection certCollection = certs.getMatches((Selector)signer.getSID());
                X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)certCollection.iterator().next();
                X509Certificate cert = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
                try {
                    if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert.getPublicKey()))) {
                        throw new IllegalStateException("Cannot verify message!");
                    }
                }
                catch (CMSException e) {
                    throw new IllegalStateException("Cannot verify message!", e);
                }
                X509Certificate rootCertificate = knownRoots.findRoot(cert).orElseThrow(() -> new SignatureException("unknown root"));
                cert.verify(rootCertificate.getPublicKey());
            }
        }
        catch (Throwable t) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, "Bei der Verarbeitung der Signatur ist ein Fehler aufgetreten", t);
        }
    }
}

