/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v1.model;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.api.Signer;
import de.impfdoc.impfzert.api.VaccinationInfo;
import de.impfdoc.impfzert.common.utils.SignatureLogger;
import de.impfdoc.impfzert.model.ImpfZertCertifiedVaccination;
import de.impfdoc.impfzert.model.ImpfZertEmployee;
import de.impfdoc.impfzert.model.ImpfZertPatient;
import de.impfdoc.impfzert.model.ImpfZertVaccination;
import de.impfdoc.impfzert.model.ImpfZertVaccine;
import de.impfdoc.impfzert.model.KnownVaccine;
import de.impfdoc.impfzert.v1.model.SignedVaccinationV1;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseVaccinationContentV1 {
    public static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Nullable
    private final String title;
    @NotNull
    private final String firstname;
    @NotNull
    private final String lastname;
    @NotNull
    private final LocalDate birthday;
    @Nullable
    private final String passNumber;
    @NotNull
    private String nonce = RandomStringUtils.randomAlphanumeric((int)8);
    @NotNull
    private final String disease = "Sars-Cov-2";
    @NotNull
    private final String vaccine = "J07BX03 covid-19 vaccines";
    @NotNull
    private final String charge;
    @NotNull
    private final String productName;
    @NotNull
    private final String marketingAuthorizationHolder;
    @Nullable
    private final String dose;
    @NotNull
    private final LocalDate vaccinationDate;
    @NotNull
    private final String atc;
    @NotNull
    private final String entityIdentification = "zollsoft";
    @NotNull
    private final String country = "";
    @NotNull
    private final String UVCI;
    @NotNull
    private final String certificateIssuer;
    @NotNull
    private final LocalDate certificateValidFrom;
    @Nullable
    private final LocalDate certificateValidTo;
    private final String schemaVersion;
    @NotNull
    private final String practitionerTitle;
    @NotNull
    private final String practitionerFirstname;
    @NotNull
    private final String practitionerLastname;
    @NotNull
    private final String practitionerStreet;
    @NotNull
    private final String practitionerCity;
    @NotNull
    private final String practitionerPlz;
    @NotNull
    private final String practitionerPhone;
    @NotNull
    private final String practitionerCountry;
    @Nullable
    private final String practitionerLanr;
    @NotNull
    private final String sex;
    @NotNull
    private final String identificationType = "2";

    public BaseVaccinationContentV1(@NotNull Map<String, String> params) {
        this.title = params.get(Field.PATIENT_TITLE.code);
        this.firstname = params.get(Field.PATIENT_FIRSTNAME.code);
        this.lastname = params.get(Field.PATIENT_LASTNAME.code);
        this.birthday = LocalDate.parse(params.get(Field.PATIENT_BIRTHDAY.code), formatter);
        this.passNumber = params.get(Field.PATIENT_PASSNUMBER.code);
        this.sex = params.get(Field.PATIENT_SEX.code);
        this.productName = params.get(Field.PRODUCT_NAME.code);
        this.nonce = params.get(Field.NONCE.code);
        this.atc = params.get(Field.VACCINATION_ATC.code);
        this.charge = params.get(Field.CHARGE.code);
        this.marketingAuthorizationHolder = params.get(Field.MARKETING_AUTHORIZATION_HOLDER.code);
        this.dose = params.get(Field.DOSE.code);
        this.vaccinationDate = LocalDate.parse(params.get(Field.VACCINATION_DATE.code), formatter);
        this.practitionerLanr = params.get(Field.PRACTITIONER_LANR.code);
        this.practitionerStreet = params.get(Field.DOCTOR_STREET.code);
        this.practitionerCity = params.get(Field.DOCTOR_CITY.code);
        this.practitionerPlz = params.get(Field.DOCTOR_PLZ.code);
        this.practitionerCountry = params.get(Field.DOCTOR_COUNTRY.code);
        this.practitionerFirstname = params.get(Field.DOCTOR_FIRSTNAME.code);
        this.practitionerLastname = params.get(Field.DOCTOR_LASTNAME.code);
        this.practitionerPhone = params.get(Field.DOCTOR_PHONE.code);
        this.practitionerTitle = params.get(Field.DOCTOR_TITLE.code);
        this.UVCI = params.get(Field.UVCI.code);
        this.certificateValidFrom = LocalDate.parse(params.get(Field.CERTIFICATE_VALID_FROM.code), formatter);
        String validTo = params.get(Field.CERTIFICATE_VALID_TO.code);
        this.certificateValidTo = validTo != null && !validTo.isEmpty() ? LocalDate.parse(params.get(Field.CERTIFICATE_VALID_TO.code), formatter) : null;
        this.certificateIssuer = params.get(Field.CERTIFICATE_ISSUER.code);
        this.schemaVersion = params.get(Field.CERTIFICATE_SCHEMA_VERSION.code);
    }

    public BaseVaccinationContentV1(@NotNull VaccinationInfo vaccinationInfo, @NotNull String certificateIssuer, @NotNull String uvci) {
        ImpfZertVaccination vaccination = vaccinationInfo.getVaccinations().stream().max(Comparator.comparing(ImpfZertVaccination::getVaccinationDate)).orElseThrow(() -> new ImpfZertException(ImpfZertException.Type.IllegalArgument, "no vaccination given", null));
        ImpfZertEmployee doctor = vaccinationInfo.getEmployee();
        ImpfZertPatient patient = vaccinationInfo.getPatient();
        this.title = patient.getTitle().orElse(null);
        this.firstname = patient.getFirstname();
        this.lastname = patient.getLastname();
        this.birthday = patient.getBirthday();
        this.passNumber = "";
        switch (patient.getGender()) {
            case MALE: {
                this.sex = "m";
                break;
            }
            case FEMALE: {
                this.sex = "w";
                break;
            }
            case UNDETERMINED: {
                this.sex = "u";
                break;
            }
            default: {
                this.sex = "0";
            }
        }
        ImpfZertVaccine vaccine = vaccination.getVaccine();
        this.productName = vaccine.getName();
        String vaccineAtc = vaccine.getAtc().orElse(null);
        if (vaccineAtc == null) {
            vaccineAtc = vaccine.isCovidVaccine() ? "J07BX03" : "";
        }
        this.atc = vaccineAtc;
        this.charge = vaccination.getCharge();
        KnownVaccine knownVaccine = KnownVaccine.findById(vaccine.getIdentifier());
        this.marketingAuthorizationHolder = knownVaccine.getManufacturerName().orElse("unbekannt");
        this.dose = vaccinationInfo.getVaccinations().size() > 1 ? "2 of 2" : (vaccine.getIdentifier().equals(KnownVaccine.COVID_JANSSEN.getIdentifier()) ? "1 of 1" : "1 of 2");
        this.vaccinationDate = vaccination.getVaccinationDate();
        this.practitionerLanr = doctor.getLanr().orElse(null);
        this.practitionerStreet = doctor.getAddressLine1();
        this.practitionerCity = doctor.getCity();
        this.practitionerPlz = doctor.getPostalCode();
        this.practitionerCountry = "DE";
        this.practitionerFirstname = "";
        this.practitionerLastname = "";
        this.practitionerPhone = doctor.getPhone().orElse("");
        this.practitionerTitle = "";
        this.UVCI = uvci;
        this.certificateValidFrom = vaccination.getVaccinationDate();
        this.certificateValidTo = null;
        this.certificateIssuer = certificateIssuer;
        this.schemaVersion = "1.0.0";
    }

    @NotNull
    public ImpfZertCertifiedVaccination toCertifiedVaccination() {
        UUID vaccineId = this.marketingAuthorizationHolder.toLowerCase().contains("astrazeneca") ? KnownVaccine.COVID_ASTRAZENECA.getIdentifier() : (this.marketingAuthorizationHolder.toLowerCase().contains("moderna") ? KnownVaccine.COVID_MODERNA.getIdentifier() : (this.marketingAuthorizationHolder.toLowerCase().contains("biontech") ? KnownVaccine.COVID_BIONTECH.getIdentifier() : (this.marketingAuthorizationHolder.toLowerCase().contains("johnson") ? KnownVaccine.COVID_JANSSEN.getIdentifier() : (this.atc.equals("J07BX03") ? KnownVaccine.COVID_UNBEKANNT.getIdentifier() : UUID.randomUUID()))));
        return new ImpfZertCertifiedVaccination(this.firstname, this.lastname, this.birthday, vaccineId, this.charge, this.dose != null ? this.dose : "", this.vaccinationDate, this.practitionerFirstname, this.practitionerLastname, this.practitionerTitle, this.practitionerLanr != null ? this.practitionerLanr : "");
    }

    @NotNull
    public String getField(@NotNull Field field) {
        return this.getFields().stream().filter(e -> ((String)e.getKey()).equals(field.getFieldName())).findAny().map(Map.Entry::getValue).orElse("");
    }

    @NotNull
    public LocalDate getVaccinationDate() {
        return this.vaccinationDate;
    }

    public void setTestNonce() {
        this.nonce = "66666";
    }

    @NotNull
    public List<Map.Entry<String, String>> getFields() {
        return Arrays.stream(Field.values()).map(f -> new AbstractMap.SimpleEntry<String, String>(f.getFieldName(), f.getContent(this).orElse(""))).collect(Collectors.toList());
    }

    @NotNull
    public String generateHash() {
        String content = this.getFields().stream().map(e -> this.jsonField((String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(","));
        String json = String.format("{%s}", content);
        SignatureLogger.logJSON(json);
        HashCode code = Hashing.sha256().hashBytes(json.getBytes(StandardCharsets.UTF_8));
        String hash = Base64.getEncoder().encodeToString(code.asBytes());
        SignatureLogger.logHash(hash);
        return hash;
    }

    @NotNull
    public SignedVaccinationV1 withSigner(@NotNull Signer signer) {
        return new SignedVaccinationV1(this, signer);
    }

    @NotNull
    private String jsonField(@NotNull String key, @Nullable String value) {
        if (value == null) {
            return String.format("%s:%s", this.quote(key), "null");
        }
        return String.format("%s:%s", this.quote(key), this.quote(value));
    }

    @NotNull
    private String quote(@NotNull String s) {
        return "\"" + s + "\"";
    }

    public static enum Field {
        PATIENT_TITLE("t", c -> BaseVaccinationContentV1.access$2600(c)),
        PATIENT_FIRSTNAME("fn", c -> BaseVaccinationContentV1.access$2500(c)),
        PATIENT_LASTNAME("ln", c -> BaseVaccinationContentV1.access$2400(c)),
        PATIENT_BIRTHDAY("b", c -> formatter.format(((BaseVaccinationContentV1)c).birthday)),
        PATIENT_SEX("s", c -> BaseVaccinationContentV1.access$2200(c)),
        IDENTIFICATION_TYPE("it", c -> "2"),
        PATIENT_PASSNUMBER("rp", c -> BaseVaccinationContentV1.access$2100(c)),
        NONCE("r", c -> BaseVaccinationContentV1.access$2000(c)),
        DOCTOR_TITLE("pt", c -> BaseVaccinationContentV1.access$1900(c)),
        DOCTOR_FIRSTNAME("pv", c -> BaseVaccinationContentV1.access$1800(c)),
        DOCTOR_LASTNAME("pn", c -> BaseVaccinationContentV1.access$1700(c)),
        DOCTOR_STREET("ps", c -> BaseVaccinationContentV1.access$1600(c)),
        DOCTOR_CITY("pc", c -> BaseVaccinationContentV1.access$1500(c)),
        DOCTOR_PLZ("pp", c -> BaseVaccinationContentV1.access$1400(c)),
        DOCTOR_PHONE("ptf", c -> BaseVaccinationContentV1.access$1300(c)),
        DOCTOR_COUNTRY("pco", c -> BaseVaccinationContentV1.access$1200(c)),
        DISEASE("vt", c -> "Sars-Cov-2"),
        VACCINE("v", c -> "J07BX03 covid-19 vaccines"),
        CHARGE("c", c -> BaseVaccinationContentV1.access$1100(c)),
        PRODUCT_NAME("vp", c -> BaseVaccinationContentV1.access$1000(c)),
        MARKETING_AUTHORIZATION_HOLDER("vm", c -> BaseVaccinationContentV1.access$900(c)),
        DOSE("vn", c -> BaseVaccinationContentV1.access$800(c)),
        VACCINATION_DATE("vd", c -> formatter.format(((BaseVaccinationContentV1)c).vaccinationDate)),
        ENTITY_IDENTIFICATION("vi", c -> "zollsoft"),
        PRACTITIONER_LANR("vid", c -> BaseVaccinationContentV1.access$600(c)),
        VACCINATION_COUNTRY("vc", c -> ""),
        VACCINATION_ATC("atc", c -> BaseVaccinationContentV1.access$500(c)),
        UVCI("uvci", c -> BaseVaccinationContentV1.access$400(c)),
        CERTIFICATE_ISSUER("ci", c -> BaseVaccinationContentV1.access$300(c)),
        CERTIFICATE_VALID_FROM("cvf", c -> ((BaseVaccinationContentV1)c).certificateValidFrom.format(formatter)),
        CERTIFICATE_VALID_TO("cvu", c -> ((BaseVaccinationContentV1)c).certificateValidTo != null ? ((BaseVaccinationContentV1)c).certificateValidTo.format(formatter) : ""),
        CERTIFICATE_SCHEMA_VERSION("cs", c -> BaseVaccinationContentV1.access$000(c));

        @NotNull
        private final String code;
        @NotNull
        private final Function<BaseVaccinationContentV1, String> mapper;

        private Field(String code, Function<BaseVaccinationContentV1, String> mapper) {
            this.code = code;
            this.mapper = mapper;
        }

        @NotNull
        public String getFieldName() {
            return this.code;
        }

        @NotNull
        public Optional<String> getContent(@NotNull BaseVaccinationContentV1 unsignedContent) {
            return Optional.ofNullable(this.mapper.apply(unsignedContent));
        }
    }
}

