/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v1.encoder;

import de.impfdoc.impfzert.common.encoder.QRCodeEncoder;
import de.impfdoc.impfzert.common.utils.SignatureLogger;
import de.impfdoc.impfzert.v1.encoder.EncodedSignedVaccinationV1;
import de.impfdoc.impfzert.v1.encoder.QRCodeEncoderV1;
import de.impfdoc.impfzert.v1.model.SignedVaccinationV1;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class SignedVaccinationEncoderV1 {
    @NotNull
    private final QRCodeEncoder generator;
    @NotNull
    private final String validationBaseDomain;

    public SignedVaccinationEncoderV1(@NotNull String validationBaseDomain) {
        this.validationBaseDomain = validationBaseDomain;
        this.generator = new QRCodeEncoderV1();
    }

    @NotNull
    public EncodedSignedVaccinationV1 encode(@NotNull SignedVaccinationV1 content) {
        String qrCodeContent = this.generator.encode(this.generateQRContent(content));
        String url = this.generateLink(qrCodeContent, this.validationBaseDomain);
        BufferedImage qrCode = this.generator.generate(qrCodeContent);
        SignatureLogger.logQrCode(qrCodeContent);
        SignatureLogger.logQrCodeDocument(qrCode);
        return new EncodedSignedVaccinationV1(qrCode, url, content);
    }

    @NotNull
    private String generateLink(@NotNull String encodedContent, @NotNull String validationBaseDomain) {
        return validationBaseDomain + "#" + encodedContent;
    }

    private byte[] generateQRContent(@NotNull SignedVaccinationV1 content) {
        List params = content.getFields().stream().filter(e -> !((String)e.getKey()).isEmpty()).map(e -> {
            try {
                return String.format("%s=%s", e.getKey(), URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }).collect(Collectors.toList());
        byte[] binaryCert = content.getBinaryCertificate();
        byte[] r = Arrays.concatenate((byte[])("?" + String.join((CharSequence)"&", params) + "?").getBytes(StandardCharsets.UTF_8), (byte[])binaryCert);
        SignatureLogger.logTiCertPart(binaryCert);
        return r;
    }
}

