/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v1.encoder;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.DataMatrixWriter;
import com.google.zxing.qrcode.QRCodeWriter;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.common.encoder.QRCodeEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base32;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class QRCodeEncoderV1
implements QRCodeEncoder {
    private static final byte[] CXF_DICTIONARY = Base64.getDecoder().decode("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");
    @NotNull
    private final QRCodeWriter qrCodeWriter = new QRCodeWriter();
    private final Base32 base32 = new Base32();

    @Override
    @NotNull
    public String encode(@NotNull byte[] content) {
        return this.base32.encodeAsString(this.compress(content)).replace('=', '$');
    }

    @Override
    @NotNull
    public byte[] decode(@NotNull String content) {
        return this.decompress(this.base32.decode(content.replace('$', '=')));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public byte[] compress(@NotNull byte[] in) {
        try {
            Deflater deflater = new Deflater(9, true);
            try {
                byte[] byArray;
                deflater.setDictionary(CXF_DICTIONARY);
                deflater.setInput(in);
                deflater.finish();
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    byte[] buf = new byte[4096];
                    while (!deflater.finished()) {
                        int len = deflater.deflate(buf, 0, buf.length);
                        out.write(buf, 0, len);
                    }
                    deflater.end();
                    byte[] result = out.toByteArray();
                    LoggerFactory.getLogger(this.getClass()).info("Compressed from {} bytes to {} bytes", (Object)in.length, (Object)result.length);
                    byArray = result;
                }
                return byArray;
            }
            finally {
                deflater.end();
            }
        }
        catch (IOException ioe) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public byte[] decompress(@NotNull byte[] in) {
        try {
            Inflater inflater = new Inflater(true);
            try {
                byte[] byArray;
                inflater.setDictionary(CXF_DICTIONARY);
                inflater.setInput(in);
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    int len;
                    byte[] buf = new byte[4096];
                    while (!inflater.finished() && (len = inflater.inflate(buf, 0, buf.length)) != 0) {
                        out.write(buf, 0, len);
                    }
                    byArray = out.toByteArray();
                }
                return byArray;
            }
            finally {
                inflater.end();
            }
        }
        catch (IOException | DataFormatException ioe) {
            throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
        }
    }

    @Override
    @NotNull
    public BufferedImage generate(@NotNull String content) {
        LoggerFactory.getLogger(this.getClass()).info("Write QR-Code (Length={}) {}", (Object)content.length(), (Object)content);
        try {
            HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>(){
                {
                    this.put(EncodeHintType.CHARACTER_SET, "UTF8");
                }
            };
            BitMatrix matrix = this.qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, 512, 512, (Map)hints);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
        }
        catch (Throwable t) {
            if (t instanceof WriterException && t.getMessage().contains("Data too big for requested version")) {
                try {
                    DataMatrixWriter dataMatrixWriter = new DataMatrixWriter();
                    BitMatrix matrix = dataMatrixWriter.encode(content, BarcodeFormat.DATA_MATRIX, 512, 512);
                    return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
                }
                catch (Throwable t2) {
                    throw new ImpfZertException(ImpfZertException.Type.Unknown, t2.toString(), t2);
                }
            }
            throw new ImpfZertException(ImpfZertException.Type.Unknown, t.toString(), t);
        }
    }
}

