/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.v1;

import de.impfdoc.impfzert.api.ImpfZertConfiguration;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfdoc.impfzert.api.ImpfZertFactory;
import de.impfdoc.impfzert.api.Signer;
import de.impfdoc.impfzert.api.SignerContext;
import de.impfdoc.impfzert.api.VaccinationInfo;
import de.impfdoc.impfzert.common.utils.CertificateParser;
import de.impfdoc.impfzert.common.utils.SignatureLogger;
import de.impfdoc.impfzert.model.ImpfZert;
import de.impfdoc.impfzert.v1.encoder.EncodedSignedVaccinationV1;
import de.impfdoc.impfzert.v1.encoder.SignedVaccinationEncoderV1;
import de.impfdoc.impfzert.v1.model.BaseVaccinationContentV1;
import de.impfdoc.impfzert.v1.model.SignedVaccinationV1;
import de.impfdoc.impfzert.v1.pdf.ImpfZertFormDataV1;
import de.impfdoc.impfzert.v1.pdf.ImpfZertFormGeneratorV1;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class ImpfZertFactoryV1
implements ImpfZertFactory {
    @NotNull
    private final SignedVaccinationEncoderV1 signedVaccinationEncoder;
    @NotNull
    private final ImpfZertConfiguration configuration;
    @NotNull
    private final ImpfZertFormGeneratorV1 impfZertFormGenerator = new ImpfZertFormGeneratorV1();

    public ImpfZertFactoryV1(@NotNull ImpfZertConfiguration configuration) {
        this.configuration = configuration;
        this.signedVaccinationEncoder = new SignedVaccinationEncoderV1(configuration.getValidationBaseUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ImpfZert createImpfZert(@NotNull VaccinationInfo vaccinationInfo, @NotNull SignerContext signerContext) throws IOException {
        if (!vaccinationInfo.getEmployee().isDoctor() || !vaccinationInfo.getEmployee().getLanr().isPresent()) {
            throw new ImpfZertException(ImpfZertException.Type.OnlyDoctor, "Nur ein Arzt mit LANR darf die Best\u00e4tigung austellen!", null);
        }
        SignatureLogger.init(this.configuration.isSignatureLoggingEnabled());
        try {
            int index;
            EncodedSignedVaccinationV1 encodedSignedVaccination;
            if (this.configuration.isSignatureEnabled() && !vaccinationInfo.getVaccinations().isEmpty()) {
                Signer signer = signerContext.getSigner();
                String certificateIssuer = CertificateParser.parse(signer.queryCertificate()).getCommonName().orElse("").toUpperCase();
                String uvci = "";
                SignedVaccinationV1 signedVaccination = new BaseVaccinationContentV1(vaccinationInfo, certificateIssuer, "").withSigner(signer);
                encodedSignedVaccination = this.signedVaccinationEncoder.encode(signedVaccination);
            } else {
                encodedSignedVaccination = null;
            }
            ImpfZertFormDataV1 impfZertFormData = new ImpfZertFormDataV1(vaccinationInfo, encodedSignedVaccination);
            InputStream inputStream = this.impfZertFormGenerator.createForm(impfZertFormData);
            String code = encodedSignedVaccination != null ? ((index = encodedSignedVaccination.getLink().indexOf("#")) >= 0 ? encodedSignedVaccination.getLink().substring(index + 1) : null) : null;
            ImpfZert impfZert = new ImpfZert(inputStream, code);
            return impfZert;
        }
        finally {
            SignatureLogger.finish();
        }
    }
}

