/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.standalone;

import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.certificateservicecommon.v2.X509DataInfoListType;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfsoft.ticonnector.ConnectorException;
import de.impfsoft.ticonnector.Signature;
import de.impfsoft.ticonnector.TIConnectorConfiguration;
import de.impfsoft.ticonnector.TIConnectorService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TiConnectorServiceAdapterStandalone {
    @NotNull
    private final TIConnectorService tiConnectorService;
    @NotNull
    private final TIConnectorConfiguration tiConnectorConfiguration;

    public TiConnectorServiceAdapterStandalone(@NotNull TIConnectorService tiConnectorService, @NotNull TIConnectorConfiguration tiConnectorConfiguration) {
        this.tiConnectorService = tiConnectorService;
        this.tiConnectorConfiguration = tiConnectorConfiguration;
    }

    @NotNull
    public TIConnectorService getTiConnectorService() {
        return this.tiConnectorService;
    }

    @NotNull
    public TIConnectorConfiguration getTiConnectorConfiguration() {
        return this.tiConnectorConfiguration;
    }

    @NotNull
    public X509DataInfoListType.X509DataInfo queryCertificate() {
        CardInfoType cardInfo = (CardInfoType)this.queryCards().stream().findFirst().orElseThrow(() -> new ImpfZertException(ImpfZertException.Type.NoCard, "no card was found", null));
        return this.tiConnectorService.queryCertificateViaCardInfoType(this.tiConnectorConfiguration, cardInfo, null);
    }

    @NotNull
    public Signature signTextDocument(@NotNull String txt) throws ConnectorException {
        Signature signature;
        CardInfoType cardInfoType = (CardInfoType)this.queryCards().stream().findFirst().orElseThrow(() -> new ImpfZertException(ImpfZertException.Type.NoCard, "no card was found", null));
        ByteArrayInputStream is = new ByteArrayInputStream(txt.getBytes(StandardCharsets.UTF_8));
        try {
            signature = this.tiConnectorService.signTextDocument(this.tiConnectorConfiguration, cardInfoType.getIccsn(), (InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new ImpfZertException(ImpfZertException.Type.Unknown, ioe.toString(), ioe);
            }
        }
        ((InputStream)is).close();
        return signature;
    }

    @NotNull
    public List<CardInfoType> queryCards() {
        return this.tiConnectorService.queryCards(this.tiConnectorConfiguration).getCards().getCard().stream().filter(c -> c.getIccsn() != null).filter(c -> {
            switch (c.getCardType()) {
                case HBA: 
                case HBA_Q_SIG: 
                case SMC_B: {
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
    }

    @NotNull
    public Signature signPdfDocument(@NotNull InputStream pdf, @Nullable String iccsn) throws ConnectorException {
        return this.tiConnectorService.signPdfDocument(this.tiConnectorConfiguration, iccsn, pdf);
    }
}

