/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.standalone;

import com.google.common.base.Strings;
import de.impfdoc.impfzert.api.ImpfZertException;
import de.impfsoft.ticonnector.ConnectorException;
import de.impfsoft.ticonnector.TIConnectorConfiguration;
import de.impfsoft.ticonnector.TIConnectorContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Optional;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiConnectorConfigurationStandalone
implements TIConnectorConfiguration {
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(TiConnectorConfigurationStandalone.class);
    @NotNull
    final URL connectorUrl;
    @NotNull
    final String mandantId;
    @NotNull
    final String clientSystemId;
    @NotNull
    final String workplaceId;
    @NotNull
    final String userId;
    @NotNull
    final String clientcert;
    @NotNull
    final String servercert;
    @NotNull
    final String clientpwd;
    @Nullable
    final String clientprivatekeypwd;
    @Nullable
    final String iccsn;

    public TiConnectorConfigurationStandalone(@NotNull URL connectorUrl, @NotNull String mandantId, @NotNull String clientSystemId, @NotNull String workplaceId, @NotNull String userId, @NotNull String servercert, @NotNull String clientcert, @NotNull String clientpwd, @Nullable String clientprivatekeypwd, @Nullable String iccsn) {
        this.connectorUrl = connectorUrl;
        this.mandantId = mandantId;
        this.clientSystemId = clientSystemId;
        this.workplaceId = workplaceId;
        this.userId = userId;
        this.servercert = servercert.replaceAll("\\r\\n|\\r|\\n| ", "");
        this.clientcert = clientcert.replaceAll("\\r\\n|\\r|\\n| ", "");
        this.clientpwd = clientpwd;
        this.clientprivatekeypwd = clientprivatekeypwd;
        this.iccsn = iccsn != null && iccsn.trim().isEmpty() ? null : iccsn;
    }

    @NotNull
    public URI getUri() {
        try {
            return this.connectorUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new ConnectorException("Die URL des Connectors ist ung\u00fcltig!", ConnectorException.ExceptionType.CONFIGURATION_ERROR);
        }
    }

    @NotNull
    public Optional<String> getCardIccsn() {
        return Optional.ofNullable(this.iccsn);
    }

    @NotNull
    public TIConnectorContext getContext() {
        return new TIConnectorContext(){

            @NotNull
            public String getMandantId() {
                return TiConnectorConfigurationStandalone.this.mandantId;
            }

            @NotNull
            public String getClientSystemId() {
                return TiConnectorConfigurationStandalone.this.clientSystemId;
            }

            @NotNull
            public String getWorkplaceId() {
                return TiConnectorConfigurationStandalone.this.workplaceId;
            }

            @NotNull
            public Optional<String> getUserId() {
                if (TiConnectorConfigurationStandalone.this.userId.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(TiConnectorConfigurationStandalone.this.userId);
            }
        };
    }

    @NotNull
    public Optional<UsernamePasswordCredentials> getCredentials() {
        return Optional.empty();
    }

    @NotNull
    private Optional<KeyStore> getClientCertificateInternal() {
        if (Strings.isNullOrEmpty((String)this.clientcert) || Strings.isNullOrEmpty((String)this.clientpwd)) {
            logger.error("ClientZertikat oder Passwort sind plichtangaben");
            return Optional.empty();
        }
        try {
            byte[] decoded = Base64.getDecoder().decode(this.clientcert);
            ByteArrayInputStream is = new ByteArrayInputStream(decoded);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, this.clientpwd.toCharArray());
            return Optional.of(keyStore);
        }
        catch (Exception e) {
            try {
                byte[] decoded = Base64.getDecoder().decode(this.clientcert);
                ByteArrayInputStream is = new ByteArrayInputStream(decoded);
                KeyStore keyStore = KeyStore.getInstance("pkcs12");
                keyStore.load(is, this.clientpwd.toCharArray());
                return Optional.of(keyStore);
            }
            catch (Exception e2) {
                logger.error("Problem mit ClientZertifikat", (Throwable)e);
                return Optional.empty();
            }
        }
    }

    @NotNull
    private char[] getClientCertificatePrivateKeyPassword() {
        return this.clientprivatekeypwd != null ? this.clientprivatekeypwd.toCharArray() : this.clientpwd.toCharArray();
    }

    @NotNull
    public Optional<TIConnectorConfiguration.ClientCertificate> getClientCertificate() {
        return this.getClientCertificateInternal().map(ks -> new TIConnectorConfiguration.ClientCertificate(ks, this.getClientCertificatePrivateKeyPassword()));
    }

    @NotNull
    public KeyStore getTrustedCertificates() {
        try {
            KeyStore trustStore = KeyStore.getInstance("PKCS12");
            trustStore.load(null, "".toCharArray());
            if (Strings.isNullOrEmpty((String)this.servercert)) {
                logger.info("Kein KonnektorZertifikat angegeben");
            } else {
                byte[] decoded = Base64.getDecoder().decode(this.servercert);
                ByteArrayInputStream is = new ByteArrayInputStream(decoded);
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
                trustStore.setCertificateEntry("fiddler" + ((InputStream)is).available(), cert);
            }
            return trustStore;
        }
        catch (Throwable t) {
            logger.error("Problem mit KonnektorZertifikat", t);
            throw new ImpfZertException(ImpfZertException.Type.Unknown, "Problem mit KonnektorZertifikat", t);
        }
    }
}

