/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.standalone;

import com.google.common.base.Strings;
import de.impfdoc.impfzert.api.VaccinationInfo;
import de.impfdoc.impfzert.eu.EuImpfZertConfiguration;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.eu.json.RecoveryData;
import de.impfdoc.impfzert.eu.json.TestResultData;
import de.impfdoc.impfzert.model.ImpfZertDose;
import de.impfdoc.impfzert.model.ImpfZertEmployee;
import de.impfdoc.impfzert.model.ImpfZertGender;
import de.impfdoc.impfzert.model.ImpfZertOperatingSite;
import de.impfdoc.impfzert.model.ImpfZertPatient;
import de.impfdoc.impfzert.model.ImpfZertVaccination;
import de.impfdoc.impfzert.model.ImpfZertVaccine;
import de.impfdoc.impfzert.standalone.CertificateType;
import de.impfdoc.impfzert.standalone.TiConnectorConfigurationStandalone;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.management.modelmbean.XMLParseException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImpfZertXmlParser {
    @NotNull
    public static Optional<VaccinationInfo> parseZollsoftCertificationData(@NotNull Element root) throws XMLParseException {
        ImpfZertEmployee employee = ImpfZertXmlParser.createEmployee(root);
        ImpfZertOperatingSite operatingSite = ImpfZertXmlParser.createOperatingSite(root);
        ImpfZertPatient patient = ImpfZertXmlParser.createPatient(root);
        CertificateType type = CertificateType.valueOf(ImpfZertXmlParser.findXmlElementValue(root, "impfcerttype", true));
        switch (type) {
            default: {
                List<ImpfZertVaccination> list = ImpfZertXmlParser.createVaccionations(root);
                VaccinationInfo vaccinationInfo = new VaccinationInfo(patient, employee, operatingSite, list, null, true);
                return Optional.of(vaccinationInfo);
            }
            case IBM_VACCINATION: 
            case IBM_RECOVERY: 
            case IBM_TEST: 
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<EuImpfZertConfiguration> parseIBMConfiguration(@NotNull Element root) throws XMLParseException {
        final String serverUrl = ImpfZertXmlParser.findXmlElementValue(root, "ibmserverurl", true);
        final String realm = ImpfZertXmlParser.findXmlElementValue(root, "ibmrealm", true);
        final String clientId = ImpfZertXmlParser.findXmlElementValue(root, "ibmclientid", true);
        final String issuerUrl = ImpfZertXmlParser.findXmlElementValue(root, "ibmissuerurl", true);
        if (serverUrl.isEmpty() || realm.isEmpty() || clientId.isEmpty() || issuerUrl.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new EuImpfZertConfiguration(){

            @Override
            @NotNull
            public String getServerUrl() {
                return serverUrl;
            }

            @Override
            @NotNull
            public String getRealm() {
                return realm;
            }

            @Override
            @NotNull
            public String getClientId() {
                return clientId;
            }

            @Override
            @NotNull
            public String getIssuerUrl() {
                return issuerUrl;
            }
        });
    }

    @NotNull
    public static Optional<CertificationData> parseIBMCertificationData(@NotNull Element root) throws XMLParseException {
        ImpfZertEmployee employee = ImpfZertXmlParser.createEmployee(root);
        ImpfZertOperatingSite operatingSite = ImpfZertXmlParser.createOperatingSite(root);
        ImpfZertPatient patient = ImpfZertXmlParser.createPatient(root);
        CertificateType type = CertificateType.valueOf(ImpfZertXmlParser.findXmlElementValue(root, "impfcerttype", true));
        switch (type) {
            case IBM_VACCINATION: {
                List<ImpfZertVaccination> list = ImpfZertXmlParser.createVaccionations(root);
                VaccinationInfo vaccinationInfo = new VaccinationInfo(patient, employee, operatingSite, list, null, true);
                return Optional.of(CertificationData.forVaccinationCertificate(vaccinationInfo));
            }
            case IBM_RECOVERY: {
                RecoveryData recoveryData = ImpfZertXmlParser.createRecoveryData(root, operatingSite);
                return Optional.of(CertificationData.forRecoveryCertificate(patient, recoveryData));
            }
            case IBM_TEST: {
                TestResultData testResultData = ImpfZertXmlParser.createTestResultData(root, operatingSite);
                return Optional.of(CertificationData.forTestCertificate(patient, testResultData));
            }
        }
        return Optional.empty();
    }

    @NotNull
    public static TiConnectorConfigurationStandalone parseTiConfiguration(@NotNull Element root) throws MalformedURLException, XMLParseException {
        return new TiConnectorConfigurationStandalone(new URL(ImpfZertXmlParser.findXmlElementValue(root, "konnektor-url", false)), ImpfZertXmlParser.findXmlElementValue(root, "mandantid", false), ImpfZertXmlParser.findXmlElementValue(root, "clientid", false), ImpfZertXmlParser.findXmlElementValue(root, "workplaceid", false), ImpfZertXmlParser.findXmlElementValue(root, "userid", true), ImpfZertXmlParser.findXmlElementValue(root, "servercert", true), ImpfZertXmlParser.findXmlElementValue(root, "clientcert", true), ImpfZertXmlParser.findXmlElementValue(root, "clientpwd", true), ImpfZertXmlParser.findXmlElementValue(root, "clientprivatekeypwd", true), ImpfZertXmlParser.findXmlElementValue(root, "iccsn", true));
    }

    @NotNull
    private static ImpfZertEmployee createEmployee(@NotNull Element root) throws XMLParseException {
        return new ImpfZertEmployee(true, ImpfZertXmlParser.findXmlElementValue(root, "alanr", false), ImpfZertXmlParser.findXmlElementValue(root, "bstr", true), ImpfZertXmlParser.findXmlElementValue(root, "bort", true), ImpfZertXmlParser.findXmlElementValue(root, "bplz", true), ImpfZertXmlParser.findXmlElementValue(root, "atel", true), ImpfZertXmlParser.findXmlElementValue(root, "atit", true));
    }

    @NotNull
    private static ImpfZertOperatingSite createOperatingSite(@NotNull Element root) throws XMLParseException {
        return new ImpfZertOperatingSite(ImpfZertXmlParser.findXmlElementValue(root, "bbsnr", false), ImpfZertXmlParser.findXmlElementValue(root, "bname", false));
    }

    @NotNull
    private static ImpfZertPatient createPatient(@NotNull Element root) throws XMLParseException {
        String geb = ImpfZertXmlParser.findXmlElementValue(root, "pgeb", false);
        if (Strings.isNullOrEmpty((String)geb)) {
            throw new XMLParseException("Geburstag ist ein Pflichtfeld");
        }
        return new ImpfZertPatient(ImpfZertXmlParser.findXmlElementValue(root, "ptit", true), ImpfZertXmlParser.findXmlElementValue(root, "pvn", false), ImpfZertXmlParser.findXmlElementValue(root, "pnn", false), LocalDate.parse(geb), ImpfZertXmlParser.findXmlElementValue(root, "psex", false).toLowerCase().equals("m") ? ImpfZertGender.MALE : ImpfZertGender.FEMALE, false);
    }

    @NotNull
    private static List<ImpfZertVaccination> createVaccionations(@NotNull Element root) throws XMLParseException {
        ArrayList<ImpfZertVaccination> ret = new ArrayList<ImpfZertVaccination>();
        ImpfZertVaccine vaccine = new ImpfZertVaccine(UUID.fromString(ImpfZertXmlParser.findXmlElementValue(root, "vid", false)), ImpfZertXmlParser.findXmlElementValue(root, "vname", false), null);
        String dose = ImpfZertXmlParser.findXmlElementValue(root, "vdose", true);
        String totalDoses = ImpfZertXmlParser.findXmlElementValue(root, "vtotaldoses", true);
        if (!dose.isEmpty() && !totalDoses.isEmpty()) {
            ImpfZertDose impfZertDose = new ImpfZertDose(Integer.parseInt(dose), Integer.parseInt(totalDoses));
            ImpfZertVaccination vaccination1 = ImpfZertVaccination.createWithDose(vaccine, LocalDate.parse(ImpfZertXmlParser.findXmlElementValue(root, "vdate", false)), ImpfZertXmlParser.findXmlElementValue(root, "vcharge", false), impfZertDose);
            ret.add(vaccination1);
        } else {
            ImpfZertVaccination vaccination1 = ImpfZertVaccination.create(vaccine, LocalDate.parse(ImpfZertXmlParser.findXmlElementValue(root, "vdate", false)), ImpfZertXmlParser.findXmlElementValue(root, "vcharge", false));
            ret.add(vaccination1);
            if (ImpfZertXmlParser.findXmlElementValue(root, "v2name", true).length() > 0) {
                ImpfZertVaccine vaccine2 = new ImpfZertVaccine(UUID.fromString(ImpfZertXmlParser.findXmlElementValue(root, "v2id", false)), ImpfZertXmlParser.findXmlElementValue(root, "v2name", false), null);
                ImpfZertVaccination vaccination2 = ImpfZertVaccination.create(vaccine2, LocalDate.parse(ImpfZertXmlParser.findXmlElementValue(root, "v2date", false)), ImpfZertXmlParser.findXmlElementValue(root, "v2charge", false));
                ret.add(vaccination2);
            }
        }
        return ret;
    }

    @NotNull
    private static RecoveryData createRecoveryData(@NotNull Element root, @NotNull ImpfZertOperatingSite operatingSite) throws XMLParseException {
        return new RecoveryData(LocalDate.parse(ImpfZertXmlParser.findXmlElementValue(root, "rfirstpositiv", false)), LocalDate.parse(ImpfZertXmlParser.findXmlElementValue(root, "rvalidfrom", false)), LocalDate.parse(ImpfZertXmlParser.findXmlElementValue(root, "rvaliduntil", false)), operatingSite.getBsnr());
    }

    @NotNull
    private static TestResultData createTestResultData(@NotNull Element root, @NotNull ImpfZertOperatingSite operatingSite) throws XMLParseException {
        return new TestResultData(ImpfZertXmlParser.findXmlElementValue(root, "ttype", false), ImpfZertXmlParser.findXmlElementValue(root, "tname", false), ImpfZertXmlParser.findXmlElementValue(root, "tmanufacturer", false), LocalDateTime.parse(ImpfZertXmlParser.findXmlElementValue(root, "tsampletime", false)), LocalDateTime.parse(ImpfZertXmlParser.findXmlElementValue(root, "tresulttime", false)), operatingSite.getName(), Boolean.parseBoolean(ImpfZertXmlParser.findXmlElementValue(root, "tpositive", false)), operatingSite.getBsnr());
    }

    @NotNull
    private static String findXmlElementValue(@NotNull Element parent, @NotNull String name, boolean otional) throws XMLParseException {
        NodeList nList = parent.getElementsByTagName(name);
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            return nNode.getTextContent();
        }
        if (otional) {
            return "";
        }
        throw new XMLParseException("Der Wert f\u00fcr '" + name + "' wurde nicht \u00fcbergeben.");
    }
}

