/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.standalone;

import de.gematik.ws.conn.certificateservicecommon.v2.X509DataInfoListType;
import de.impfdoc.impfzert.api.ImpfZertConfiguration;
import de.impfdoc.impfzert.api.ImpfZertFactory;
import de.impfdoc.impfzert.api.ImpfZertVersion;
import de.impfdoc.impfzert.api.Signer;
import de.impfdoc.impfzert.api.SignerContext;
import de.impfdoc.impfzert.api.VaccinationInfo;
import de.impfdoc.impfzert.eu.EuImpfZertConfiguration;
import de.impfdoc.impfzert.eu.ImpfZertFactoryEu;
import de.impfdoc.impfzert.eu.customizer.EuCertCustomizer;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.model.ImpfZert;
import de.impfdoc.impfzert.standalone.ImpfZertXmlParser;
import de.impfdoc.impfzert.standalone.TiConnectorServiceAdapterStandalone;
import de.impfdoc.impfzert.v1.ImpfZertFactoryV1;
import de.impfdoc.impfzert.v2.ImpfZertFactoryV2;
import de.impfsoft.ticonnector.ConnectorException;
import de.impfsoft.ticonnector.Signature;
import de.impfsoft.ticonnector.TIConnectorService;
import de.impfsoft.ticonnector.TIConnectorServiceImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ImpfZertGeneratorStandalone {
    private final ImpfZertVersion impfZertVersion = ImpfZertVersion.V2;
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(ImpfZertGeneratorStandalone.class);

    public static void main(@NotNull String[] args) {
        String errorString;
        String errorFilePath;
        File errorFile;
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger.info("Starte pdf Generator");
        Options options = new Options();
        Option input = new Option("i", "input", true, "input xml-file");
        input.setRequired(true);
        options.addOption(input);
        Option output = new Option("o", "output", true, "output pdf-file");
        output.setRequired(true);
        options.addOption(output);
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
            formatter.printHelp("utility-name", options);
            System.exit(1);
        }
        String inputFilePath = cmd.getOptionValue("input");
        String outputFilePath = cmd.getOptionValue("output");
        if (!new File(inputFilePath).exists() || !inputFilePath.endsWith(".xml")) {
            logger.error("input muss eine .xml sein:  '{}'", (Object)inputFilePath);
            System.exit(1);
        }
        if (!outputFilePath.endsWith(".pdf")) {
            logger.error("input muss eine .pdf sein:  '{}'", (Object)outputFilePath);
            System.exit(1);
        }
        if ((errorFile = new File(errorFilePath = outputFilePath.replaceAll(".pdf", ".err"))).exists()) {
            errorFile.delete();
        }
        if ((errorString = ImpfZertGeneratorStandalone.createPdf(inputFilePath, outputFilePath)).length() > 0) {
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile), StandardCharsets.UTF_8);
                writer.write(errorString);
                writer.close();
            }
            catch (Exception e) {
                logger.error("Fehler beim error schreiben", (Throwable)e);
            }
        }
    }

    @NotNull
    public static String createPdf(@NotNull String inputFilePath, @NotNull String outputFilePath) {
        Element root;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFilePath);
            doc.getDocumentElement().normalize();
            root = doc.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("Fehler beim xml parsen", (Throwable)e);
            return "Interner Fehler beim xml parsen. Siehe Server log.";
        }
        try {
            ImpfZertGeneratorStandalone gen = new ImpfZertGeneratorStandalone();
            try (InputStream is = gen.createPdf(root);){
                try {
                    File targetFile = new File(outputFilePath);
                    try (FileOutputStream outStream = new FileOutputStream(targetFile);){
                        IOUtils.copy((InputStream)is, (OutputStream)outStream);
                    }
                }
                catch (Exception e) {
                    if (e.getCause() != null) {
                        if (e.getCause() instanceof ConnectorException) {
                            throw new Exception("Die Verbindung zum TI-Connetor ist scheinbar falsch konfiguriert:  " + e.getCause());
                        }
                        throw new Exception(e.getCause());
                    }
                    throw new Exception(e);
                }
                logger.info("Impfzertifikat nach '" + outputFilePath + "' geschrieben");
            }
        }
        catch (Exception e) {
            logger.error("Fehler: ", (Throwable)e);
            return "Fehler bei der Zertifikat Erzeugung:  " + e.getLocalizedMessage();
        }
        return "";
    }

    @NotNull
    private InputStream createPdf(@NotNull Element root) throws Exception {
        ImpfZert impfZert;
        TIConnectorServiceImpl tiConnectorService = new TIConnectorServiceImpl(true);
        TiConnectorServiceAdapterStandalone tiConnectorServiceAdapter = new TiConnectorServiceAdapterStandalone((TIConnectorService)tiConnectorService, ImpfZertXmlParser.parseTiConfiguration(root));
        CertificationData data = ImpfZertXmlParser.parseIBMCertificationData(root).orElse(null);
        VaccinationInfo vaccinationInfo = ImpfZertXmlParser.parseZollsoftCertificationData(root).orElse(null);
        EuImpfZertConfiguration euImpfZertConfiguration = ImpfZertXmlParser.parseIBMConfiguration(root).orElse(null);
        if (data != null) {
            if (euImpfZertConfiguration == null) {
                throw new IllegalArgumentException("Keine Konfigurationsdaten zur Ausstellung von IBM-Zertifikaten hinterlegt.");
            }
            impfZert = this.createIBMCertificate(data, euImpfZertConfiguration, tiConnectorServiceAdapter);
        } else if (vaccinationInfo != null) {
            impfZert = this.createZollsoftCertificate(vaccinationInfo, tiConnectorServiceAdapter);
        } else {
            throw new IllegalArgumentException("Unbekannter Modus. Weder zollsoft noch IBM Zertifikat wurde gew\u00e4hlt");
        }
        try {
            impfZert = new EuCertCustomizer().customizeEuCertificate(impfZert);
        }
        catch (Throwable t) {
            logger.error("Customization of eu-zert failed. ", t);
        }
        return new ByteArrayInputStream(impfZert.getPdf());
    }

    @NotNull
    private ImpfZert createZollsoftCertificate(@NotNull VaccinationInfo vaccinationInfo, final @NotNull TiConnectorServiceAdapterStandalone tiConnectorServiceAdapter) throws Exception {
        ImpfZertFactory impfZertFactory;
        Signer signer = new Signer(){

            @Override
            @NotNull
            public Signature sign(@NotNull String content) {
                return tiConnectorServiceAdapter.signTextDocument(content);
            }

            @Override
            @NotNull
            public X509DataInfoListType.X509DataInfo queryCertificate() {
                return tiConnectorServiceAdapter.queryCertificate();
            }
        };
        SignerContext signerContext = () -> signer;
        ImpfZertConfiguration configuration = new ImpfZertConfiguration(){

            @Override
            public boolean isSignatureEnabled() {
                return true;
            }

            @Override
            public boolean isSignatureLoggingEnabled() {
                return false;
            }

            @Override
            @NotNull
            public String getValidationBaseUrl() {
                return "https://corona.impfpass.de/";
            }
        };
        switch (this.impfZertVersion) {
            case V1: {
                impfZertFactory = new ImpfZertFactoryV1(configuration);
                break;
            }
            case V2: {
                impfZertFactory = new ImpfZertFactoryV2(configuration);
                break;
            }
            default: {
                impfZertFactory = new ImpfZertFactoryV2(configuration);
            }
        }
        return impfZertFactory.createImpfZert(vaccinationInfo, signerContext);
    }

    @NotNull
    private ImpfZert createIBMCertificate(@NotNull CertificationData certificationData, @NotNull EuImpfZertConfiguration euImpfZertConfiguration, @NotNull TiConnectorServiceAdapterStandalone tiConnectorServiceAdapter) throws Exception {
        ImpfZertFactoryEu impfZertFactory = new ImpfZertFactoryEu(tiConnectorServiceAdapter.getTiConnectorService());
        return impfZertFactory.createImpfZert(certificationData, euImpfZertConfiguration, tiConnectorServiceAdapter.getTiConnectorConfiguration());
    }
}

