/*
 * Decompiled with CFR 0.152.
 */
package de.impfdoc.impfzert.standalone;

import de.gematik.ws.conn.certificateservicecommon.v2.X509DataInfoListType;
import de.impfdoc.impfzert.api.ImpfZertConfiguration;
import de.impfdoc.impfzert.api.ImpfZertFactory;
import de.impfdoc.impfzert.api.ImpfZertVersion;
import de.impfdoc.impfzert.api.Signer;
import de.impfdoc.impfzert.api.SignerContext;
import de.impfdoc.impfzert.api.VaccinationInfo;
import de.impfdoc.impfzert.eu.EuImpfZertConfiguration;
import de.impfdoc.impfzert.eu.ImpfZertFactoryEu;
import de.impfdoc.impfzert.eu.customizer.EuCertCustomizer;
import de.impfdoc.impfzert.eu.json.CertificationData;
import de.impfdoc.impfzert.model.ImpfZert;
import de.impfdoc.impfzert.standalone.ImpfZertXmlParser;
import de.impfdoc.impfzert.standalone.TiConnectorServiceAdapterStandalone;
import de.impfdoc.impfzert.v1.ImpfZertFactoryV1;
import de.impfdoc.impfzert.v2.ImpfZertFactoryV2;
import de.impfsoft.ticonnector.Signature;
import de.impfsoft.ticonnector.TIConnectorService;
import de.impfsoft.ticonnector.TIConnectorServiceImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImpfZertGenerator {
    private final ImpfZertVersion impfZertVersion = ImpfZertVersion.V2;
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(ImpfZertGenerator.class);
    private final DocumentBuilder dBuilder;

    public ImpfZertGenerator() throws ParserConfigurationException {
        logger.info("init eu-zert pdf Generator");
        BouncyCastleProvider provider = new BouncyCastleProvider();
        if (Security.getProvider(provider.getName()) == null) {
            Security.addProvider((Provider)provider);
        }
        this.dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    @NotNull
    public InputStream createPdf(@NotNull InputStream xmlStream) throws Exception {
        Document doc = this.dBuilder.parse(xmlStream);
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        return this.createPdf(root);
    }

    @NotNull
    private InputStream createPdf(@NotNull Element root) throws Exception {
        ImpfZert impfZert;
        TIConnectorServiceImpl tiConnectorService = new TIConnectorServiceImpl(true);
        TiConnectorServiceAdapterStandalone tiConnectorServiceAdapter = new TiConnectorServiceAdapterStandalone((TIConnectorService)tiConnectorService, ImpfZertXmlParser.parseTiConfiguration(root));
        CertificationData data = ImpfZertXmlParser.parseIBMCertificationData(root).orElse(null);
        VaccinationInfo vaccinationInfo = ImpfZertXmlParser.parseZollsoftCertificationData(root).orElse(null);
        EuImpfZertConfiguration euImpfZertConfiguration = ImpfZertXmlParser.parseIBMConfiguration(root).orElse(null);
        if (data != null) {
            if (euImpfZertConfiguration == null) {
                throw new IllegalArgumentException("Keine Konfigurationsdaten zur Ausstellung von IBM-Zertifikaten hinterlegt.");
            }
            impfZert = this.createIBMCertificate(data, euImpfZertConfiguration, tiConnectorServiceAdapter);
        } else if (vaccinationInfo != null) {
            impfZert = this.createZollsoftCertificate(vaccinationInfo, tiConnectorServiceAdapter);
        } else {
            throw new IllegalArgumentException("Unbekannter Modus. Weder zollsoft noch IBM Zertifikat wurde gew\u00e4hlt");
        }
        try {
            impfZert = new EuCertCustomizer().customizeEuCertificate(impfZert);
        }
        catch (Throwable t) {
            logger.error("Customization of eu-zert failed. ", t);
        }
        return new ByteArrayInputStream(impfZert.getPdf());
    }

    @NotNull
    private ImpfZert createZollsoftCertificate(@NotNull VaccinationInfo vaccinationInfo, final @NotNull TiConnectorServiceAdapterStandalone tiConnectorServiceAdapter) throws Exception {
        ImpfZertFactory impfZertFactory;
        Signer signer = new Signer(){

            @Override
            @NotNull
            public Signature sign(@NotNull String content) {
                return tiConnectorServiceAdapter.signTextDocument(content);
            }

            @Override
            @NotNull
            public X509DataInfoListType.X509DataInfo queryCertificate() {
                return tiConnectorServiceAdapter.queryCertificate();
            }
        };
        SignerContext signerContext = () -> signer;
        ImpfZertConfiguration configuration = new ImpfZertConfiguration(){

            @Override
            public boolean isSignatureEnabled() {
                return true;
            }

            @Override
            public boolean isSignatureLoggingEnabled() {
                return false;
            }

            @Override
            @NotNull
            public String getValidationBaseUrl() {
                return "https://corona.impfpass.de/";
            }
        };
        switch (this.impfZertVersion) {
            case V1: {
                impfZertFactory = new ImpfZertFactoryV1(configuration);
                break;
            }
            case V2: {
                impfZertFactory = new ImpfZertFactoryV2(configuration);
                break;
            }
            default: {
                impfZertFactory = new ImpfZertFactoryV2(configuration);
            }
        }
        return impfZertFactory.createImpfZert(vaccinationInfo, signerContext);
    }

    @NotNull
    private ImpfZert createIBMCertificate(@NotNull CertificationData certificationData, @NotNull EuImpfZertConfiguration euImpfZertConfiguration, @NotNull TiConnectorServiceAdapterStandalone tiConnectorServiceAdapter) throws Exception {
        ImpfZertFactoryEu impfZertFactory = new ImpfZertFactoryEu(tiConnectorServiceAdapter.getTiConnectorService());
        return impfZertFactory.createImpfZert(certificationData, euImpfZertConfiguration, tiConnectorServiceAdapter.getTiConnectorConfiguration());
    }
}

